/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: optextbr.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: hr $ $Date: 2006/06/19 15:21:59 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// include ---------------------------------------------------------------

#ifdef WNT
#include <tools/prewin.h>
#include <shellapi.h>
#include <tools/postwin.h>
#endif

#ifndef _SHL_HXX
#include <tools/shl.hxx>
#endif
#ifndef _SV_SOUND_HXX //autogen
#include <vcl/sound.hxx>
#endif
#ifndef _SV_MSGBOX_HXX //autogen
#include <vcl/msgbox.hxx>
#endif
#ifndef _SV_GROUP_HXX //autogen
#include <vcl/group.hxx>
#endif
#ifndef _SFXSLSTITM_HXX //autogen
#include <svtools/slstitm.hxx>
#endif
#ifndef _SFXENUMITEM_HXX //autogen
#include <svtools/eitem.hxx>
#endif
#ifndef _SFXAPP_HXX //autogen
#include <sfx2/app.hxx>
#endif
#ifndef _FILEDLGHELPER_HXX
#include <sfx2/filedlghelper.hxx>
#endif
#ifndef _URLOBJ_HXX
#include <tools/urlobj.hxx>
#endif

#define _SVSTDARR_STRINGS
#include <svtools/svstdarr.hxx>

#define _SVX_OPTEXTBR_CXX

#include "optextbr.hxx"
#include "dialmgr.hxx"

#include "optextbr.hrc"
#include "dialogs.hrc"

// -----------------------------------------------------------------------

const char* INIKEY_NO_WARNING 	= "NoExternBrowserWarning";
const char* STAROFFICE_BROWSER	= "StarOffice";
const char* IE_BROWSER			= "Internet Explorer";

// class ExternBrowserQueryBox_Impl --------------------------------------

class ExternBrowserQueryBox_Impl : public ModalDialog
{
private:
	FixedImage		aImage;
	FixedText		aWarningFT;
	CheckBox		aDisableCB;
	OKButton		aYesBtn;
	CancelButton	aNoBtn;

public:
	ExternBrowserQueryBox_Impl( Window* pParent );

	BOOL		IsWarningDisabled() const { return aDisableCB.IsChecked(); }
};

// -----------------------------------------------------------------------

ExternBrowserQueryBox_Impl::ExternBrowserQueryBox_Impl( Window* pParent ) :

	ModalDialog( pParent, SVX_RES( RID_SVXDLG_OPT_EXTERN_BROWSER ) ),

	aImage		( this, ResId( IMG_EXTBRW_WARNING ) ),
	aWarningFT	( this, ResId( FT_EXTBRW_WARNING ) ),
	aDisableCB	( this, ResId( CB_EXTBRW_DISABLE ) ),
	aYesBtn		( this, ResId( BTN_EXTBRW_YES ) ),
	aNoBtn		( this, ResId( BTN_EXTBRW_NO ) )

{
	FreeResource();

	aYesBtn.SetText( Button::GetStandardText( BUTTON_YES ) );
	aNoBtn.SetText( Button::GetStandardText( BUTTON_NO ) );
	aImage.SetImage( WarningBox::GetStandardImage() );
}

// class SvxExternBrowserTabPage -----------------------------------------

IMPL_LINK( SvxExternBrowserTabPage, CheckHdl_Impl, CheckBox *, pBox )
{
/*!!! (pb) obsolete
	USHORT i;
	FASTBOOL bOn = pCheckBox->IsChecked();
	EnableControls();
	String aNewText = aExceptionText;
	if ( HAS_IE() )
		aNewText.SearchAndReplaceAscii( "%1", bOn ? String::CreateFromAscii(STAROFFICE_BROWSER) : String::CreateFromAscii(IE_BROWSER) );
	else
	{
		if ( bOn )
			aNewText.SearchAndReplaceAscii( "%1", String::CreateFromAscii(STAROFFICE_BROWSER));
		else
			aNewText.SearchAndReplaceAscii( "%1", aExternBrowserText );
	}
	aExceptionFT.SetText( aNewText );

	if ( !pBox )
		return 0;

	SvStrings* pList = new SvStrings;
	for ( i = 0; i < aExceptionLB.GetEntryCount(); ++i )
		pList->Insert( new String( aExceptionLB.GetEntry(i) ), i );

	if ( bOn )
	{
		for ( i = 0; i < pOffExceptionList->Count(); ++i )
			delete pOffExceptionList->GetObject(i);
		delete pOffExceptionList;
		pOffExceptionList = pList;
		pList = pOnExceptionList;
	}
	else
	{
		for ( i = 0; i < pOnExceptionList->Count(); ++i )
			delete pOnExceptionList->GetObject(i);
		delete pOnExceptionList;
		pOnExceptionList = pList;
		pList = pOffExceptionList;
	}

	aExceptionLB.Clear();

	for ( i = 0; i < pList->Count(); ++i )
		aExceptionLB.InsertEntry( *pList->GetObject(i) );
	aExceptionED.SetText( String() );
*/
	return 0;
}

// -----------------------------------------------------------------------

IMPL_LINK( SvxExternBrowserTabPage, ModifyHdl_Impl, Edit *, pEdit )
{
	String aTxt = pEdit->GetText().EraseLeadingChars().EraseTrailingChars();
	aAddBtn.Enable( aTxt.Len() > 0 );
	return 0;
}

// -----------------------------------------------------------------------

IMPL_LINK( SvxExternBrowserTabPage, SelectHdl_Impl, ListBox *, pBox )
{
	aDeleteBtn.Enable( pBox->GetSelectEntryPos() != LISTBOX_ENTRY_NOTFOUND );
	return 0;
}

// -----------------------------------------------------------------------

IMPL_LINK( SvxExternBrowserTabPage, ClickHdl_Impl, PushButton *, pBtn )
{
	if ( !pBtn || pBtn == &aAddBtn )
	{
		TakeServerName();

		if ( !pBtn )
		{
			// letzte "Anderung f"ur FillItemSet speichern
			SvStrings* pList = new SvStrings;
			USHORT i;

			for ( i = 0; i < aExceptionLB.GetEntryCount(); ++i )
				pList->Insert( new String( aExceptionLB.GetEntry(i) ), i );

			if ( pCheckBox->IsChecked() )
			{
				for ( i = 0; i < pOnExceptionList->Count(); ++i )
					delete pOnExceptionList->GetObject(i);
				delete pOnExceptionList;
				pOnExceptionList = pList;
			}
			else
			{
				for ( i = 0; i < pOffExceptionList->Count(); ++i )
					delete pOffExceptionList->GetObject(i);
				delete pOffExceptionList;
				pOffExceptionList = pList;
			}
		}
		aExceptionED.SetText( String() );
	}
	else if ( pBtn == &aFileBtn )
	{
    	sfx2::FileDialogHelper aDlg( ::sfx2::FILEOPEN_SIMPLE, 0 );

    	if ( aDlg.Execute() == ERRCODE_NONE )
		{
			aFileED.SetText( INetURLObject( aDlg.GetPath() ).getFSysPath( INetURLObject::FSYS_DETECT ) );
		}
	}
	else if ( pBtn == &aIEOptionsBtn )
	{
#ifdef WNT
		ShellExecute( ::GetFocus(), NULL, "control.exe", "inetcpl.cpl", "", SW_SHOW );
#endif
		return 0;
	}
	else
	{
		USHORT nPos = aExceptionLB.GetSelectEntryPos();

		if ( nPos != LISTBOX_ENTRY_NOTFOUND )
		{
			aExceptionLB.RemoveEntry( nPos );
			USHORT nCount = aExceptionLB.GetEntryCount();

			if ( nCount )
			{
				if ( nPos > nCount - 1 )
					nPos = nCount - 1;
				aExceptionLB.SelectEntryPos( nPos );
			}
		}
	}
	ModifyHdl_Impl( &aExceptionED );
	SelectHdl_Impl( &aExceptionLB );
	EnableControls();
	if ( pBtn == &aAddBtn )
		aExceptionED.GrabFocus();
	return 0;
}

// -----------------------------------------------------------------------

void SvxExternBrowserTabPage::TakeServerName()
{
	String aText = aExceptionED.GetText().EraseLeadingChars().EraseTrailingChars();

	if ( !aText.Len() )
		return;

	aExceptionED.SetText( aText );
	FASTBOOL bFound = FALSE;

	for ( USHORT i = 0; i < aExceptionLB.GetEntryCount(); ++i )
	{
		if ( aExceptionLB.GetEntry(i) == aText )
		{
			bFound = TRUE;
			break;
		}
	}

	if ( !bFound )
	{
		aExceptionLB.InsertEntry( aText );
		aExceptionED.SetSelection( Selection( 0, aExceptionED.GetText().Len() ) );
	}
}

// -----------------------------------------------------------------------

void SvxExternBrowserTabPage::EnableControls()
{
	if ( &aOnCB == pCheckBox )
	{
		BOOL bEnable = pCheckBox->IsChecked() || ( aExceptionLB.GetEntryCount() > 0 );
		aIEOptionsBtn.Enable( bEnable );
	}
	else
	{
		aFileED.Enable( pCheckBox->IsChecked() );
		aFileBtn.Enable( pCheckBox->IsChecked() );
	}
}

// -----------------------------------------------------------------------

void SvxExternBrowserTabPage::ActivatePage( const SfxItemSet& )
{
	BOOL bNoHint = TRUE /*!!!(BOOL)(USHORT)SFX_INIMANAGER()->Get( SFX_KEY_EXTBRW_NO_HINT ).ToInt32()*/;
	aNoHintCB.Check( bNoHint );
}

// -----------------------------------------------------------------------

int SvxExternBrowserTabPage::DeactivatePage( SfxItemSet* pSet )
{
/*!!! (PB) obsolete
	const SfxPoolItem* pItem;

	if ( !bNoWarning && SFX_ITEM_SET == GetItemSet().GetItemState( SID_OPT_EXTBRW_ON, FALSE, &pItem ) )
	{
		DBG_ASSERT( pItem->ISA(SfxBoolItem), "SfxBoolItem erwartet" );
		BOOL bCheck = pCheckBox->IsChecked();
		SfxIniManager* pIniMgr = SFX_APP()->GetIniManager();
		bNoWarning = (BOOL)(USHORT)pIniMgr->Get( SFX_GROUP_EXTBRW, INIKEY_NO_WARNING );

		if ( !bNoWarning && bCheck && bCheck != ( (SfxBoolItem*)pItem )->GetValue() )
		{
			ExternBrowserQueryBox_Impl aQBox( this );
			aQBox.SetText( GetText() );
			short nRet = aQBox.Execute();

			if ( aQBox.IsWarningDisabled() )
				pIniMgr->Set( "1", SFX_GROUP_EXTBRW, INIKEY_NO_WARNING );

			if ( RET_CANCEL == nRet )
			{
				pCheckBox->Check( FALSE );
				CheckHdl_Impl( pCheckBox );
				return KEEP_PAGE;
			}
			else
				bNoWarning = TRUE;
		}
	}
*/
	if ( pSet )
		FillItemSet( *pSet );
	return LEAVE_PAGE;
}

// -----------------------------------------------------------------------

SvxExternBrowserTabPage::SvxExternBrowserTabPage( Window* pParent, const SfxItemSet& rSet ) :

	SfxTabPage( pParent, SVX_RES( RID_SVXPAGE_OPT_EXTERN_BROWSER ), rSet ),

	aOnCB				( this, ResId( CB_EXTBRW_ON ) ),
	aFileCB				( this, ResId( CB_EXTBRW_FILE ) ),
	aFileED				( this, ResId( ED_EXTBRW_FILE ) ),
	aFileBtn			( this, ResId( PB_EXTBRW_FILE ) ),
	aIEOptionsBtn		( this, ResId( PB_EXTBRW_IEOPTIONS ) ),
	aExceptionFT		( this, ResId( FT_EXTBRW_EXCEPTION ) ),
	aExceptionED		( this, ResId( ED_EXTBRW_EXCEPTION ) ),
	aExceptionLB		( this, ResId( LB_EXTBRW_EXCEPTION ) ),
	aAddBtn				( this, ResId( PB_EXTBRW_ADD ) ),
	aDeleteBtn			( this, ResId( PB_EXTBRW_DELETE ) ),
	aNoHintCB			( this, ResId( CB_EXTBRW_NOHINT ) ),
	aExternBrowserText  ( 		ResId( STR_EXTBRW_FILE ) ),

	bNoWarning			( FALSE ),
	bOldNoHintValue		( FALSE ),
	pOnExceptionList    ( NULL ),
	pOffExceptionList   ( NULL )

{
	FreeResource();
	SetExchangeSupport(); // damit DeactivatePage() gerufen wird

	aExceptionText = aExceptionFT.GetText();
	Link aLink = LINK( this, SvxExternBrowserTabPage, CheckHdl_Impl );
	aOnCB.SetClickHdl( aLink );
	aFileCB.SetClickHdl( aLink );
	aExceptionED.SetModifyHdl( LINK( this, SvxExternBrowserTabPage, ModifyHdl_Impl ) );
	aExceptionLB.SetSelectHdl( LINK( this, SvxExternBrowserTabPage, SelectHdl_Impl ) );
	aLink = LINK( this, SvxExternBrowserTabPage, ClickHdl_Impl );
	aFileBtn.SetClickHdl( aLink );
	aIEOptionsBtn.SetClickHdl( aLink );
	aAddBtn.SetClickHdl( aLink );
	aDeleteBtn.SetClickHdl( aLink );

	if ( FALSE /*!!!HAS_IE()*/ )
	{
		aFileCB.Hide();
		aFileED.Hide();
		aFileBtn.Hide();
		pCheckBox = &aOnCB;
	}
	else
	{
		aOnCB.Hide();
		aIEOptionsBtn.Hide();
		pCheckBox = &aFileCB;
	}

	ModifyHdl_Impl( &aExceptionED );
	SelectHdl_Impl( &aExceptionLB );
	bOldNoHintValue = FALSE /*!!!(BOOL)(USHORT)SFX_INIMANAGER()->Get( SFX_KEY_EXTBRW_NO_HINT ).ToInt32()*/;
}

// -----------------------------------------------------------------------

SvxExternBrowserTabPage::~SvxExternBrowserTabPage()
{
}

// -----------------------------------------------------------------------

SfxTabPage* SvxExternBrowserTabPage::Create( Window* pParent, const SfxItemSet& rSet )
{
	return ( new SvxExternBrowserTabPage( pParent, rSet ) );
}

// -----------------------------------------------------------------------

BOOL SvxExternBrowserTabPage::FillItemSet( SfxItemSet& rSet )
{
	// ggf. neuen Eintrag einf"ugen
	ClickHdl_Impl( NULL );
	BOOL bModified = FALSE, bTemp = FALSE;

	// Vergleichen mit alter Liste
	const SfxItemSet& rOldSet = GetItemSet();
	const SfxPoolItem* pItem;

	if ( SFX_ITEM_SET == rOldSet.GetItemState( SID_OPT_EXTBRW_ON_EXCEPTION, FALSE, &pItem ) )
	{
		DBG_ASSERT( pItem->ISA(SfxStringListItem), "SfxStringListItem erwartet" );
		List* pList = ( (SfxStringListItem*)pItem )->GetList();

		if ( pList )
		{
			ULONG nOldCount = pList->Count();

			if ( nOldCount != pOnExceptionList->Count() )
				bTemp = TRUE;

			for ( USHORT i = 0; i < nOldCount && !bTemp; ++i )
			{
				const String* pNew = pOnExceptionList->GetObject(i);
				const String* pOld = (String*)pList->GetObject(i);

				if ( *pNew != *pOld )
					bTemp = TRUE;
			}
		}
	}

	if ( bTemp )
	{
		List aList;
		for ( USHORT i = 0; i < pOnExceptionList->Count(); ++i )
			aList.Insert( pOnExceptionList->GetObject(i), LIST_APPEND );
		rSet.Put( SfxStringListItem( SID_OPT_EXTBRW_ON_EXCEPTION, &aList ) );
		bModified = TRUE;
		bTemp = FALSE;
	}
	else
		rSet.ClearItem( SID_OPT_EXTBRW_ON_EXCEPTION );

	if ( SFX_ITEM_SET == rOldSet.GetItemState( SID_OPT_EXTBRW_OFF_EXCEPTION, FALSE, &pItem ) )
	{
		DBG_ASSERT( pItem->ISA(SfxStringListItem), "SfxStringListItem erwartet" );
		List* pList = ( (SfxStringListItem*)pItem )->GetList();

		if ( pList )
		{
			ULONG nOldCount = pList->Count();

			if ( nOldCount != pOffExceptionList->Count() )
				bTemp = TRUE;

			for ( USHORT i = 0; i < nOldCount && !bTemp; ++i )
			{
				const String* pNew = pOffExceptionList->GetObject(i);
				const String* pOld = (String*)pList->GetObject(i);

				if ( *pNew != *pOld )
					bTemp = TRUE;
			}
		}
	}

	if ( bTemp )
	{
		List aList;
		for ( USHORT i = 0; i < pOffExceptionList->Count(); ++i )
			aList.Insert( pOffExceptionList->GetObject(i), LIST_APPEND );
		rSet.Put( SfxStringListItem( SID_OPT_EXTBRW_OFF_EXCEPTION, &aList ) );
		bModified = TRUE;
	}
	else
		rSet.ClearItem( SID_OPT_EXTBRW_OFF_EXCEPTION );

	if ( SFX_ITEM_SET == rOldSet.GetItemState( SID_OPT_EXTBRW_ON, FALSE, &pItem ) )
	{
		DBG_ASSERT( pItem->ISA(SfxBoolItem), "SfxBoolItem erwartet" );

		if ( pCheckBox->IsChecked() != ( (SfxBoolItem*)pItem )->GetValue() )
		{
			rSet.Put( SfxBoolItem( SID_OPT_EXTBRW_ON, pCheckBox->IsChecked() ) );
			bModified = TRUE;
		}
		else
			rSet.ClearItem( SID_OPT_EXTBRW_ON );
	}
/*!!! (pb) obsolete
	SfxIniManager* pIniMgr = SFX_INIMANAGER();
	if ( aFileED.IsReallyVisible() && aFileED.IsEnabled() )
	{
		XubString aExtBrwFile = pIniMgr->Get( SFX_KEY_EXTBRW_FILE );
		XubString aNewFile = aFileED.GetText();
		if ( aNewFile != aExtBrwFile )
		{
			pIniMgr->Set( aNewFile, SFX_KEY_EXTBRW_FILE );
			bModified = TRUE;
		}
	}
	pIniMgr->Set( aNoHintCB.IsChecked() ? String('1') : String('0'), SFX_KEY_EXTBRW_NO_HINT );
*/
	return bModified;
}

// -----------------------------------------------------------------------

void SvxExternBrowserTabPage::Reset( const SfxItemSet& rSet )
{
	const SfxPoolItem* pItem;
	USHORT i;

	if ( SFX_ITEM_SET == rSet.GetItemState(SID_OPT_EXTBRW_ON_EXCEPTION, FALSE, &pItem) )
	{
		DBG_ASSERT( pItem->ISA(SfxStringListItem), "StringListItem erwartet" );
		List* pList = ( (SfxStringListItem*)pItem )->GetList();

		for ( i = 0; pOnExceptionList && i < pOnExceptionList->Count(); ++i )
			delete pOnExceptionList->GetObject(i);
		delete pOnExceptionList;
		pOnExceptionList = new SvStrings;
		ULONG nCount = pList ? pList->Count() : 0;

		for ( i = 0; i < nCount; i++ )
		{
#if OSL_DEBUG_LEVEL > 1
			const String* pStr = (String*)pList->GetObject(i);
#endif
			pOnExceptionList->Insert( new String( *(String*)pList->GetObject(i) ), i );
		}
	}

	if ( SFX_ITEM_SET == rSet.GetItemState(SID_OPT_EXTBRW_OFF_EXCEPTION, FALSE, &pItem) )
	{
		DBG_ASSERT( pItem->ISA(SfxStringListItem), "StringListItem erwartet" );
		List* pList = ( (SfxStringListItem*)pItem )->GetList();

		for ( i = 0; pOffExceptionList && i < pOffExceptionList->Count(); ++i )
			delete pOffExceptionList->GetObject(i);
		delete pOffExceptionList;
		pOffExceptionList = new SvStrings;
		ULONG nCount = pList ? pList->Count() : 0;

		for ( i = 0; i < nCount; i++ )
		{
#if OSL_DEBUG_LEVEL > 1
			const String* pStr = (String*)pList->GetObject(i);
#endif
			pOffExceptionList->Insert( new String( *(String*)pList->GetObject(i) ), i );
		}
	}

	String aExtBrwFile /*!!!= SFX_INIMANAGER()->Get( SFX_KEY_EXTBRW_FILE )*/;
	aFileED.SetText( aExtBrwFile );
	BOOL bOn = FALSE;

	if ( SFX_ITEM_SET == rSet.GetItemState(SID_OPT_EXTBRW_ON, FALSE, &pItem) )
	{
		DBG_ASSERT( pItem->ISA(SfxBoolItem), "BoolItem erwartet" );
		bOn = ( (SfxBoolItem*)pItem )->GetValue();
	}

	pCheckBox->Check( bOn );
	EnableControls();
	String aNewText = aExceptionText;
	aNewText.SearchAndReplaceAscii( "%1", bOn ? String::CreateFromAscii(STAROFFICE_BROWSER) : String::CreateFromAscii(IE_BROWSER) );
	aExceptionFT.SetText( aNewText );
	SvStrings* pExcptList = bOn ? pOnExceptionList : pOffExceptionList;

	for ( i = 0; i < pExcptList->Count(); ++i )
		aExceptionLB.InsertEntry( *pExcptList->GetObject(i) );

	aNoHintCB.Check( bOldNoHintValue );
	CheckHdl_Impl( NULL );
}


