/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: itemsettools.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 00:14:51 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _SDR_PROPERTIES_ITEMSETTOOLS_HXX
#include <svx/sdr/properties/itemsettools.hxx>
#endif

#ifndef _TOOLS_DEBUG_HXX
#include <tools/debug.hxx>
#endif

#ifndef _SFXITEMSET_HXX
#include <svtools/itemset.hxx>
#endif

#ifndef _SFX_WHITER_HXX
#include <svtools/whiter.hxx>
#endif

#include <vector>

#ifndef _SVDOGRP_HXX
#include <svdogrp.hxx>
#endif

#ifndef _SVDITER_HXX
#include <svditer.hxx>
#endif

//////////////////////////////////////////////////////////////////////////////
// class to remember broadcast start positions

namespace sdr
{
	namespace properties
	{
		// helper vector to remember rectangles
		typedef ::std::vector< Rectangle > RectangleVector;

		ItemChangeBroadcaster::ItemChangeBroadcaster(const SdrObject& rObj)
		{
			if(rObj.ISA(SdrObjGroup))
			{
				SdrObjListIter aIter((const SdrObjGroup&)rObj, IM_DEEPNOGROUPS);
				mpData = new RectangleVector;
				DBG_ASSERT(mpData, "ItemChangeBroadcaster: No memory (!)");
				((RectangleVector*)mpData)->reserve(aIter.Count());

				while(aIter.IsMore())
				{
					SdrObject* pObj = aIter.Next();

					if(pObj)
					{
						((RectangleVector*)mpData)->push_back(pObj->GetLastBoundRect());
					}
				}

				mnCount = ((RectangleVector*)mpData)->size();
			}
			else
			{
				mpData = new Rectangle(rObj.GetLastBoundRect());
				mnCount = 1L;
			}
		}

		ItemChangeBroadcaster::~ItemChangeBroadcaster()
		{
			if(mnCount > 1)
			{
				delete ((RectangleVector*)mpData);
			}
			else
			{
				delete ((Rectangle*)mpData);
			}
		}

		sal_uInt32 ItemChangeBroadcaster::GetRectangleCount() const
		{
			return mnCount;
		}

		const Rectangle& ItemChangeBroadcaster::GetRectangle(sal_uInt32 nIndex) const
		{
			if(mnCount > 1)
			{
				return (*((RectangleVector*)mpData))[nIndex];
			}
			else
			{
				return *((Rectangle*)mpData);
			}
		}
	} // end of namespace properties
} // end of namespace sdr

//////////////////////////////////////////////////////////////////////////////

namespace sdr
{
	namespace properties
	{
		void ScaleItemSet(SfxItemSet& rSet, const Fraction& rScale)
		{
			sal_Int32 nMul(rScale.GetNumerator());
			sal_Int32 nDiv(rScale.GetDenominator());

			if(!rScale.IsValid() || !nDiv)
			{
				return;
			}

			SfxWhichIter aIter(rSet);
			sal_uInt16 nWhich(aIter.FirstWhich());
			const SfxPoolItem *pItem = NULL;

			while(nWhich)
			{
				if(SFX_ITEM_SET == rSet.GetItemState(nWhich, FALSE, &pItem))
				{
					if(pItem->HasMetrics())
					{
						SfxPoolItem* pNewItem = pItem->Clone();
						pNewItem->ScaleMetrics(nMul, nDiv);
						rSet.Put(*pNewItem);
					}
				}
				nWhich = aIter.NextWhich();
			}
		}
	} // end of namespace properties
} // end of namespace sdr

//////////////////////////////////////////////////////////////////////////////
// eof
