/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: split.cxx,v $
 *
 *  $Revision: 1.11 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 11:02:46 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifdef SW_DLLIMPLEMENTATION
#undef SW_DLLIMPLEMENTATION
#endif


#pragma hdrstop

#ifndef _SFXDISPATCH_HXX //autogen
#include <sfx2/dispatch.hxx>
#endif
#ifndef _SFXINTITEM_HXX //autogen
#include <svtools/intitem.hxx>
#endif
#ifndef _SFXENUMITEM_HXX //autogen
#include <svtools/eitem.hxx>
#endif


#include "cmdid.h"
#include "split.hxx"
#include "wrtsh.hxx"

#include "split.hrc"
#include "table.hrc"



void SwSplitTableDlg::Apply()
{
}

SwSplitTableDlg::SwSplitTableDlg( Window *pParent, SwWrtShell& rShell )
	: SvxStandardDialog(pParent, SW_RES(DLG_SPLIT)),
	aCountLbl(this, SW_RES(FT_COUNT)),
	aCountEdit(this, SW_RES(ED_COUNT)),
    aCountFL(this, SW_RES(FL_COUNT)),
	aHorzBox(this, SW_RES(RB_HORZ)),
    aPropCB(this, SW_RES(CB_PROP)),
	aVertBox(this, SW_RES(RB_VERT)),
    aDirFL(this, SW_RES(FL_DIR)),
	aOKBtn(this, SW_RES(BT_OK)),
	aCancelBtn(this, SW_RES(BT_CANCEL)),
	aHelpBtn( this, SW_RES( BT_HELP ) ),
	rSh( rShell )
{
    aVertBox.SetModeRadioImage(Image(ResId(BMP_SPLIT_VERT)), BMP_COLOR_HIGHCONTRAST);
    aHorzBox.SetModeRadioImage(Image(ResId(BMP_SPLIT_HORZ)), BMP_COLOR_HIGHCONTRAST);
    FreeResource();
    aHorzBox.SetClickHdl( LINK( this, SwSplitTableDlg, ClickHdl ));
    aPropCB.SetClickHdl( LINK( this, SwSplitTableDlg, ClickHdl ));
    aVertBox.SetClickHdl( LINK( this, SwSplitTableDlg, ClickHdl ));

	long nMax = rSh.GetAnyCurRect( RECT_FRM ).Width();
	if( nMax < 2 * MINLAY )
		aVertBox.Enable(FALSE);

    //exchange the meaning of horizontal and vertical for vertical text
    if(rSh.IsTableVertical())
    {
        Image aTmpImg(aHorzBox.GetModeRadioImage());
        String sTmp(aHorzBox.GetText());
        aHorzBox.SetText(aVertBox.GetText());
        aHorzBox.SetModeRadioImage(aVertBox.GetModeRadioImage());
        aVertBox.SetText(sTmp);    
        aVertBox.SetModeRadioImage(aTmpImg);    
    }            
}

IMPL_LINK( SwSplitTableDlg, ClickHdl, Button *, pButton )
{
	long nMax = 99;
    BOOL bIsVert = pButton == &aVertBox;
    if( bIsVert )
	{
        nMax = rSh.GetAnyCurRect( RECT_FRM ).Width();
		nMax /= MINLAY;
	}
    aPropCB.Enable(!bIsVert);
    aCountEdit.SetMax( nMax );

	return 0;
}

