#*************************************************************************
#
#   OpenOffice.org - a multi-platform office productivity suite
#
#   $RCSfile: makefile.mk,v $
#
#   $Revision: 1.13.72.1 $
#
#   last change: $Author: hr $ $Date: 2006/08/10 15:00:22 $
#
#   The Contents of this file are made available subject to
#   the terms of GNU Lesser General Public License Version 2.1.
#
#
#     GNU Lesser General Public License Version 2.1
#     =============================================
#     Copyright 2005 by Sun Microsystems, Inc.
#     901 San Antonio Road, Palo Alto, CA 94303, USA
#
#     This library is free software; you can redistribute it and/or
#     modify it under the terms of the GNU Lesser General Public
#     License version 2.1, as published by the Free Software Foundation.
#
#     This library is distributed in the hope that it will be useful,
#     but WITHOUT ANY WARRANTY; without even the implied warranty of
#     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#     Lesser General Public License for more details.
#
#     You should have received a copy of the GNU Lesser General Public
#     License along with this library; if not, write to the Free Software
#     Foundation, Inc., 59 Temple Place, Suite 330, Boston,
#     MA  02111-1307  USA
#
#*************************************************************************

PRJ=..

PRJNAME=SV
TARGET=svdem
LIBTARGET=NO
TARGETTYPE=GUI

ENABLE_EXCEPTIONS=TRUE

# --- Settings -----------------------------------------------------

.INCLUDE :	svpre.mk
.INCLUDE :	settings.mk
.INCLUDE :	sv.mk

# --- Files --------------------------------------------------------

OBJFILES=		$(OBJ)$/svdem.obj
APP1NOSAL=		TRUE
APP1TARGET= 	$(TARGET)
APP1OBJS=		$(OBJFILES)

APP1STDLIBS=	$(CPPULIB)			\
				$(CPPUHELPERLIB)	\
				$(COMPHELPERLIB)	\
				$(VCLLIB)			\
				$(TOOLSLIB) 		\
				$(SALLIB)			\
				$(VOSLIB)			\
				$(SOTLIB)			\
				$(SVLIB)

.IF "$(GUI)"=="WIN" || "$(GUI)"=="OS2"
APP1DEF=		$(MISC)$/$(TARGET).def
.ENDIF

# --- Targets ------------------------------------------------------

APP2TARGET= outdevgrind
APP2OBJS=	\
	$(OBJ)$/outdevgrind.obj

.IF "$(GUI)"!="UNX"
	APP2OBJS += $(OBJ)$/salmain.obj
.ELSE
	APP2OBJS += $(SLO)$/salmain.obj
.ENDIF

APP2NOSAL=		TRUE
APP2STDLIBS=$(TOOLSLIB) 		\
			$(COMPHELPERLIB)	\
			$(CPPULIB)			\
			$(CPPUHELPERLIB)	\
			$(UCBHELPERLIB)		\
			$(SALLIB)			\
			$(VCLLIB)

.IF "$(GUI)"!="UNX"
APP2DEF=	$(MISC)$/$(TARGET).def
.ENDIF

# --- Targets ------------------------------------------------------

ALL : \
	ALLTAR \
	$(BIN)$/applicat.rdb

.INCLUDE :	target.mk

$(BIN)$/applicat.rdb : makefile.mk $(UNOUCRRDB)
	rm -f $@
	$(GNUCOPY) $(UNOUCRRDB) $@
 	+cd $(BIN) && \
 		regcomp -register -r applicat.rdb \
 			-c i18nsearch.uno$(DLLPOST) \
 			-c i18npool.uno$(DLLPOST)

# ------------------------------------------------------------------
# Windows
# ------------------------------------------------------------------

.IF "$(GUI)" == "WIN"

$(MISC)$/$(TARGET).def: makefile
	echo  NAME			$(TARGET)							>$@
	echo  DESCRIPTION	'StarView - Testprogramm'          >>$@
	echo  EXETYPE		WINDOWS 						   >>$@
	echo  STUB			'winSTUB.EXE'                      >>$@
	echo  PROTMODE										   >>$@
	echo  CODE			PRELOAD MOVEABLE DISCARDABLE	   >>$@
	echo  DATA			PRELOAD MOVEABLE MULTIPLE		   >>$@
	echo  HEAPSIZE		8192							   >>$@
	echo  STACKSIZE 	32768							   >>$@

.ENDIF

