/*
 * Framework.java
 *
 * Created on 1. M?rz 2003, 15:00
 */
package com.sun.star.wizards.tutorial.creator.frame;

import java.awt.Component;
import java.awt.Rectangle;

import java.util.Vector;

import com.sun.star.awt.XExtendedToolkit;
import com.sun.star.frame.XModel;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.wizards.tutorial.creator.frame.objectFinder.ActionFrame;
import com.sun.star.wizards.tutorial.creator.frame.objectFinder.XFramework;
import com.sun.star.wizards.tutorial.executer.util.MacroCreator;

/**
 * Framework coordinates all frames and dialogs of TutorialCreator.
 *
 * @author $author$
 * @version $Revision: 1.3 $
 */
public class Framework implements XFramework {
    private StepFrame m_stepFrame;
    private ConnectFrame m_connect;
    private ActionFrame m_actionFrame;

    /**
     * Creates a new Framework object.
     */
    public Framework() {
        openConnectDialog(null);
    }

    /**
     * Creates a new Framework object.
     *
     * @param xMSF
     */
    public Framework(XMultiServiceFactory xMSF) {
        try {
            openConnectDialog(xMSF);
            init();
            showStepFrame(new Rectangle(300, 300, 320, 170));
        } catch (java.lang.Exception ex) {
            ex.printStackTrace();
        }
    }

    /**
     * Initilization of action frame and step frame
     */
    public void init() {
        m_actionFrame = new ActionFrame((XFramework) this);
        m_stepFrame = new StepFrame((XFramework) this, new StepModel());
    }

    /**
     * Get connection dialog.
     *
     * @return ConnectFrame
     */
    public ConnectFrame getConnectDialog() {
        return m_connect;
    }

    /**
     * Get step frame.
     *
     * @return StepFrame
     */
    public StepFrame getStepFrame() {
        return m_stepFrame;
    }

    /**
     * Get action frame.
     *
     * @return ActionFrame.
     */
    public ActionFrame getActionFrame() {
        return m_actionFrame;
    }

    /**
     * Open connection dialog
     *
     * @param xMSF
     */
    public void openConnectDialog(XMultiServiceFactory xMSF) {
        if (xMSF == null) {
            m_connect = new ConnectFrame(this);
        } else {
            try {
                m_connect = new ConnectFrame(xMSF);
            } catch (java.lang.Exception ex) {
            }
        }
    }

    /**
     * Get ExtendedToolkit.
     *
     * @return XExtendedToolkit
     */
    public XExtendedToolkit getXExtendedToolkit() {
        return m_connect.getXExtendedToolkit();
    }

    /**
     * Get XMultiServiceFactory.
     *
     * @return XMultiServiceFactory
     */
    public XMultiServiceFactory getXMultiServiceFactory() {
        return m_connect.getXMultiServiceFactory();
    }

    /**
     * Get document model.
     *
     * @return XModel
     */
    public XModel getXModel() {
        return m_connect.getXModel();
    }

    /**
     * Show action frame in place of the given rectangle coordinates.
     *
     * @param reg coordinates
     */
    public void showActionsFrame(Rectangle reg) {
        m_actionFrame.setLocation(reg.x, reg.y);
        m_actionFrame.setVisible(true);
    }

    /**
     * Show step frame in place of the given rectangle coordinates.
     *
     * @param reg coordinates
     */
    public void showStepFrame(Rectangle reg) {
        m_stepFrame.setLocation(reg.x, reg.y);
        m_stepFrame.setVisible(true);
        m_stepFrame.setButtonsProperties();
    }

    /**
     * Show tutorial creator frame in place of the given rectangle coordinates.
     *
     * @param reg rectangle
     * @param name String
     */
    public void showTutorialCreator(Rectangle reg, String name) {
        TutorialCreator creator = new TutorialCreator(this, name);
        creator.setLocation(reg.x, reg.y);
    }

    /**
     * Add new step into current action step
     *
     * @param data Vector
     */
    public void addActionstoStep(Vector data) {
        m_stepFrame.addAction(data);
    }

    /**
     * Get connected document title
     *
     * @return connected document title
     */
    public String getConnectedDocumentTitle() {
        return m_connect.getConnectedDocumentTitle();
    }

    /**
     * Get connected document type
     *
     * @return connected document type
     */
    public String getConnectedDocumentTyp() {
        return m_connect.getConnectedDocumentTyp();
    }

    /**
     * Creates a new macro with the given name and content. If such macro already exists,
     * it will be overwritten.
     *
     * @param libName DOCUMENT ME!
     * @param name
     * @param content
     * @param overwrite DOCUMENT ME!
     *
     * @return result
     */
    public String createDocumentMacro(String libName, String name, String content, boolean overwrite) {
        return MacroCreator.createDocumentMacro(getXModel(), libName, name, content, overwrite);
    }

    /**
     * Creates a new macro with the given name and content. If such macro already exists,
     * it will be overwritten.
     *
     * @param parentComponent
     * @param libName DOCUMENT ME!
     * @param name
     * @param content
     * @param overwrite DOCUMENT ME!
     *
     * @return result
     */
    public String createDocumentMacro(Component parentComponent, String libName, String name, String content, boolean overwrite) {
        return MacroCreator.createDocumentMacro(parentComponent, getXModel(), libName, name, content, overwrite);
    }

    /**
     * Creates a new macro with the given name and content. If such macro already exists,
     * it will be overwritten.
     *
     * @param libName DOCUMENT ME!
     * @param name
     * @param content
     *
     * @return result
     */
    public String createMacro(String libName, String name, String content) {
        return MacroCreator.createMacro(getXMultiServiceFactory(), libName, name, content);
    }

    /**
     * Creates a new macro with the given name and content. If such macro already exists,
     * it will be overwritten.
     *
     * @param parentComponent
     * @param libName DOCUMENT ME!
     * @param name
     * @param content
     *
     * @return result
     */
    public String createMacro(Component parentComponent, String libName, String name, String content) {
        return MacroCreator.createMacro(parentComponent, getXMultiServiceFactory(), libName, name, content);
    }
}
