/*
 * ExecuteMethod.java
 *
 * Created on 28. Juli 2003, 16:02
 */
package com.sun.star.wizards.tutorial.executer;

import java.util.Vector;

import com.sun.star.wizards.tutorial.executer.officeHelper.*;

/**
 * DOCUMENT ME!
 *
 * @author mc114771
 */
public class ExecuteMethod {
    private static ExecuteMethod m_execute;

    /**
     * Static initializer for this class. Creates the only instance for that.
     */
    static {
        new ExecuteMethod();
    }

    /**
     * Creates a new AccessibilityTools object.
     */
    private ExecuteMethod() {
        m_execute = this;
    }

    /**
     * Search for the methode name the specific interfaces.If found the methode then
     * execute the methode with params.
     *
     * @param classIntance
     * @param methodName method Name
     * @param path object path
     * @param params for the method
     */
    public static synchronized void instanceMethodExecute(Object classIntance, String methodName, String[] path, Vector params) {
        if (!m_execute.xMoveMouseCompact((XMoveMouseCompact) classIntance, methodName, path, params)) {
            if (!m_execute.xMouse((XMouse) classIntance, methodName, path, params)) {
                if (!m_execute.xTextCompact((XTextCompact) classIntance, methodName, path, params)) {
                    if (!m_execute.xItem((XItemSelection) classIntance, methodName, path, params)) {
                        if (classIntance instanceof DesktopDialog || classIntance instanceof Presentation_Drawing) {
                            m_execute.xTabList((XTabList) classIntance, methodName, path, params);
                        } else if (classIntance instanceof Spreadsheet) {
                            if (!m_execute.xTabList((XTabList) classIntance, methodName, path, params)) {
                                m_execute.xCellTextCompact((XCellTextCompact) classIntance, methodName, path, params);
                            }
                        }
                    }
                }
            }
        }
    }

    /**
     * Search the methode name in XItem interface.If found the methode then execute the
     * methode with params.
     *
     * @param xmm
     * @param methodName method Name
     * @param path object path
     * @param params for the method
     *
     * @return result
     */
    private boolean xItem(XItemSelection xmm, String methodName, String[] path, Vector params) {
        if (methodName.equals("selectItem_Index")) {
            xmm.selectItem_Index(path, getIntValue(params.get(0)));

            return true;
        } else if (methodName.equals("selectItem_Name")) {
            xmm.selectItem_Name(path, (String) params.get(0));

            return true;
        }

        return false;
    }

    /**
     * Search the methode name in XTabList interface.If found the methode then execute
     * the methode with params.
     *
     * @param xmm
     * @param methodName method Name
     * @param path object path
     * @param params for the method
     *
     * @return result
     */
    private boolean xTabList(XTabList xmm, String methodName, String[] path, Vector params) {
        if (methodName.equals("setTab")) {
            xmm.setTab(path, getIntValue(params.get(0)), getIntValue(params.get(1)));

            return true;
        }

        return false;
    }

    /**
     * Search the methode name in XMoveMouseCompact interface.If found the methode then
     * execute the methode with params.
     *
     * @param xmm
     * @param methodName method Name
     * @param path object path
     * @param params for the method
     *
     * @return result
     */
    private boolean xMoveMouseCompact(XMoveMouseCompact xmm, String methodName, String[] path, Vector params) {
        if (methodName.equals("moveMousetoObject")) {
            xmm.moveMousetoObject(path);

            return true;
        } else if (methodName.equals("moveMousetoObject_Click") && (params.size() == 0)) {
            xmm.moveMousetoObject_Click(path);

            return true;
        } else if (methodName.equals("moveMousetoObject_Click") && (params.size() == 2)) {
            xmm.moveMousetoObject_Click(path, (String) params.get(0), getIntValue(params.get(1)));

            return true;
        } else if (methodName.equals("moveMousetoObject_Time")) {
            xmm.moveMousetoObject_Time(path, getIntValue(params.get(0)));

            return true;
        } else if (methodName.equals("moveMousetoObject_Click_Time") && (params.size() == 1)) {
            xmm.moveMousetoObject_Click_Time(path, getIntValue(params.get(0)));

            return true;
        } else if (methodName.equals("moveMousetoObject_Click_Time") && (params.size() == 3)) {
            xmm.moveMousetoObject_Click_Time(path, (String) params.get(0), getIntValue(params.get(1)), getIntValue(params.get(2)));

            return true;
        }

        return false;
    }

    /**
     * Search the methode name in XMouse interface.If found the methode then execute the
     * methode with params.
     *
     * @param xm
     * @param methodName method Name
     * @param path object path
     * @param params for the method
     *
     * @return result
     */
    private boolean xMouse(XMouse xm, String methodName, String[] path, Vector params) {
        if (methodName.equals("sleep")) {
            xm.sleep(getIntValue(params.get(0)));

            return true;
        } else if (methodName.equals("mouseClick") && (params.size() == 0)) {
            xm.mouseClick();

            return true;
        } else if (methodName.equals("mouseClick") && (params.size() == 1)) {
            if ((params.get(0)) instanceof String) {
                xm.mouseClick((String) params.get(0));

                return true;
            } else {
                xm.mouseClick(getIntValue(params.get(0)));

                return true;
            }
        } else if (methodName.equals("mouseClick") && (params.size() == 2)) {
            xm.mouseClick((String) params.get(0), getIntValue(params.get(1)));

            return true;
        } else if (methodName.equals("mouseScroll")) {
            xm.mouseScroll((String) params.get(0), getIntValue(params.get(1)));

            return true;
        }

        return false;
    }

    /**
     * Search the methode name in XTextCompact interface.If found the methode then
     * execute the methode with params.
     *
     * @param xtc
     * @param methodName method Name
     * @param path object path
     * @param params for the method
     *
     * @return result
     */
    private boolean xTextCompact(XTextCompact xtc, String methodName, String[] path, Vector params) {
        if (methodName.equals("insertText")) {
            xtc.insertText(path, getIntValue(params.get(0)), (String) params.get(1));

            return true;
        } else if (methodName.equals("moveMousetoObject_insertText")) {
            xtc.moveMousetoObject_insertText(path, getIntValue(params.get(0)), (String) params.get(1));

            return true;
        } else if (methodName.equals("deleteText")) {
            xtc.deleteText(path, getIntValue(params.get(0)), getIntValue(params.get(1)));

            return true;
        } else if (methodName.equals("moveMousetoObject_deleteText")) {
            xtc.moveMousetoObject_deleteText(path, getIntValue(params.get(0)), getIntValue(params.get(1)));

            return true;
        } else if (methodName.equals("replaceText") && (params.size() == 2)) {
            xtc.replaceText(path, (String) params.get(0), (String) params.get(1));

            return true;
        } else if (methodName.equals("replaceText") && (params.size() == 3)) {
            xtc.replaceText(path, (String) params.get(0), getIntValue(params.get(1)), getIntValue(params.get(2)));

            return true;
        } else if (methodName.equals("moveMousetoObject_replaceText") && (params.size() == 2)) {
            xtc.moveMousetoObject_replaceText(path, (String) params.get(0), (String) params.get(1));

            return true;
        } else if (methodName.equals("moveMousetoObject_replaceText") && (params.size() == 3)) {
            xtc.moveMousetoObject_replaceText(path, (String) params.get(0), getIntValue(params.get(1)), getIntValue(params.get(2)));

            return true;
        } else if (methodName.equals("setText")) {
            xtc.setText(path, (String) params.get(0));

            return true;
        } else if (methodName.equals("moveMousetoObject_setText")) {
            xtc.moveMousetoObject_setText(path, (String) params.get(0));

            return true;
        } else if (methodName.equals("selectText") && (params.size() == 1)) {
            xtc.selectText(path, (String) params.get(0));

            return true;
        } else if (methodName.equals("selectText") && (params.size() == 2)) {
            xtc.selectText(path, getIntValue(params.get(0)), getIntValue(params.get(1)));

            return true;
        } else if (methodName.equals("moveMousetoObject_selectText") && (params.size() == 1)) {
            xtc.moveMousetoObject_selectText(path, (String) params.get(0));

            return true;
        } else if (methodName.equals("moveMousetoObject_selectText") && (params.size() == 2)) {
            xtc.moveMousetoObject_selectText(path, getIntValue(params.get(0)), getIntValue(params.get(1)));

            return true;
        }

        return false;
    }

    /**
     * Search the methode name in XCellTextCompact interface.If found the methode then
     * execute the methode with params.
     *
     * @param xtc
     * @param methodName method Name
     * @param path object path
     * @param params for the method
     *
     * @return result
     */
    private boolean xCellTextCompact(XCellTextCompact xtc, String methodName, String[] path, Vector params) {
        if (methodName.equals("insertTexttoCell")) {
            xtc.insertTexttoCell(path, getIntValue(params.get(0)), (String) params.get(1));

            return true;
        } else if (methodName.equals("moveMousetoCell_insertText")) {
            xtc.moveMousetoCell_insertText(path, getIntValue(params.get(0)), (String) params.get(1));

            return true;
        } else if (methodName.equals("deleteCellText")) {
            xtc.deleteCellText(path, getIntValue(params.get(0)), getIntValue(params.get(1)));

            return true;
        } else if (methodName.equals("moveMousetoCell_deleteText")) {
            xtc.moveMousetoCell_deleteText(path, getIntValue(params.get(0)), getIntValue(params.get(1)));

            return true;
        } else if (methodName.equals("replaceCellText") && (params.size() == 2)) {
            xtc.replaceCellText(path, (String) params.get(0), (String) params.get(1));

            return true;
        } else if (methodName.equals("replaceCellText") && (params.size() == 3)) {
            xtc.replaceCellText(path, (String) params.get(0), getIntValue(params.get(1)), getIntValue(params.get(2)));

            return true;
        } else if (methodName.equals("moveMousetoCell_replaceText") && (params.size() == 2)) {
            xtc.moveMousetoCell_replaceText(path, (String) params.get(0), (String) params.get(1));

            return true;
        } else if (methodName.equals("moveMousetoCell_replaceText") && (params.size() == 3)) {
            xtc.moveMousetoCell_replaceText(path, (String) params.get(0), getIntValue(params.get(1)), getIntValue(params.get(2)));

            return true;
        } else if (methodName.equals("setCellText")) {
            xtc.setCellText(path, (String) params.get(0));

            return true;
        } else if (methodName.equals("moveMousetoCell_setText")) {
            xtc.moveMousetoCell_setText(path, (String) params.get(0));

            return true;
        }

        return false;
    }

    /**
     * Get the object's value, if the object is an instance of Integer, Short, Byte or
     * String, otherwise -1.
     *
     * @param obj - awaiting one of the following: Integer, Short, Byte or String
     *
     * @return Int value of Object. Returned -1 in error case.
     */
    public static int getIntValue(Object obj) {
        int i = -1;

        if (obj instanceof Integer) {
            i = ((Integer) obj).intValue();
        } else if (obj instanceof Short) {
            i = ((Short) obj).intValue();
        } else if (obj instanceof Byte) {
            i = ((Byte) obj).intValue();
        } else if (obj instanceof String) {
            try {
                i = Integer.parseInt((String) obj);
            } catch (java.lang.NumberFormatException ex) {
            }
        }

        return i;
    }
}
