/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: dynload.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 16:10:56 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#include <xmlscript/dynload.hxx>


using namespace ::com::sun::star;
using namespace ::com::sun::star::uno;

namespace
{

//==================================================================================================
struct XML_script_impl : public ::xmlscript::XML_script
{
    // xmldlg_imexp.hxx
    virtual void SAL_CALL exportDialogModel(
        Reference< xml::sax::XExtendedDocumentHandler > const & xOut,
        Reference< container::XNameContainer > const & xDialogModel )
        SAL_THROW( (Exception) );
    virtual Reference< xml::sax::XDocumentHandler > SAL_CALL importDialogModel(
        Reference< container::XNameContainer > const & xDialogModel,
        Reference< XComponentContext > const & xContext )
        SAL_THROW( (Exception) );
    virtual Reference< io::XInputStreamProvider > SAL_CALL exportDialogModel(
        Reference< container::XNameContainer > const & xDialogModel,
        Reference< XComponentContext > const & xContext )
        SAL_THROW( (Exception) );
    virtual void SAL_CALL importDialogModel(
        Reference< io::XInputStream > xInput,
        Reference< container::XNameContainer > const & xDialogModel,
        Reference< XComponentContext > const & xContext )
        SAL_THROW( (Exception) );
    // xmlmod_imexp.hxx
    virtual void SAL_CALL exportScriptModule(
        Reference< xml::sax::XExtendedDocumentHandler > const & xOut,
        const ::xmlscript::ModuleDescriptor& rMod )
		SAL_THROW( (Exception) );
    virtual Reference< xml::sax::XDocumentHandler > SAL_CALL importScriptModule(
        ::xmlscript::ModuleDescriptor& rMod )
        SAL_THROW( (Exception) );
    // xmllib_imexp.hxx
    virtual void SAL_CALL exportLibraryContainer(
        Reference< xml::sax::XExtendedDocumentHandler > const & xOut,
        const ::xmlscript::LibDescriptorArray* pLibArray )
		SAL_THROW( (Exception) );
    virtual Reference< xml::sax::XDocumentHandler > SAL_CALL importLibraryContainer(
        ::xmlscript::LibDescriptorArray* pLibArray )
		SAL_THROW( (Exception) );
    virtual void SAL_CALL exportLibrary(
        Reference< xml::sax::XExtendedDocumentHandler > const & xOut,
        const ::xmlscript::LibDescriptor& rLib )
		SAL_THROW( (Exception) );
    virtual Reference< xml::sax::XDocumentHandler > SAL_CALL importLibrary(
        ::xmlscript::LibDescriptor& rLib )
		SAL_THROW( (Exception) );
};

//__________________________________________________________________________________________________
void XML_script_impl::exportDialogModel(
    Reference< xml::sax::XExtendedDocumentHandler > const & xOut,
    Reference< container::XNameContainer > const & xDialogModel )
    SAL_THROW( (Exception) )
{
    ::xmlscript::exportDialogModel( xOut, xDialogModel );
}
//__________________________________________________________________________________________________
Reference< xml::sax::XDocumentHandler > XML_script_impl::importDialogModel(
    Reference< container::XNameContainer > const & xDialogModel,
    Reference< XComponentContext > const & xContext )
    SAL_THROW( (Exception) )
{
    return ::xmlscript::importDialogModel( xDialogModel, xContext );
}
//__________________________________________________________________________________________________
Reference< io::XInputStreamProvider > XML_script_impl::exportDialogModel(
    Reference< container::XNameContainer > const & xDialogModel,
    Reference< XComponentContext > const & xContext )
    SAL_THROW( (Exception) )
{
    return ::xmlscript::exportDialogModel( xDialogModel, xContext );
}
//__________________________________________________________________________________________________
void XML_script_impl::importDialogModel(
    Reference< io::XInputStream > xInput,
    Reference< container::XNameContainer > const & xDialogModel,
    Reference< XComponentContext > const & xContext )
    SAL_THROW( (Exception) )
{
    ::xmlscript::importDialogModel( xInput, xDialogModel, xContext );
}

// xmlmod_imexp.hxx
//__________________________________________________________________________________________________
void XML_script_impl::exportScriptModule(
    Reference< xml::sax::XExtendedDocumentHandler > const & xOut,
    const ::xmlscript::ModuleDescriptor& rMod )
    SAL_THROW( (Exception) )
{
    ::xmlscript::exportScriptModule( xOut, rMod );
}
//__________________________________________________________________________________________________
Reference< xml::sax::XDocumentHandler > XML_script_impl::importScriptModule(
    ::xmlscript::ModuleDescriptor& rMod )
    SAL_THROW( (Exception) )
{
    return ::xmlscript::importScriptModule( rMod );
}

// xmllib_imexp.hxx
//__________________________________________________________________________________________________
void XML_script_impl::exportLibraryContainer(
    Reference< xml::sax::XExtendedDocumentHandler > const & xOut,
    const ::xmlscript::LibDescriptorArray* pLibArray )
    SAL_THROW( (Exception) )
{
    ::xmlscript::exportLibraryContainer( xOut, pLibArray );
}
//__________________________________________________________________________________________________
Reference< xml::sax::XDocumentHandler > XML_script_impl::importLibraryContainer(
    ::xmlscript::LibDescriptorArray* pLibArray )
    SAL_THROW( (Exception) )
{
    return ::xmlscript::importLibraryContainer( pLibArray );
}
//__________________________________________________________________________________________________
void XML_script_impl::exportLibrary(
    Reference< xml::sax::XExtendedDocumentHandler > const & xOut,
    const ::xmlscript::LibDescriptor& rLib )
    SAL_THROW( (Exception) )
{
    ::xmlscript::exportLibrary( xOut, rLib );
}
//__________________________________________________________________________________________________
Reference< xml::sax::XDocumentHandler > XML_script_impl::importLibrary(
    ::xmlscript::LibDescriptor& rLib )
    SAL_THROW( (Exception) )
{
    return ::xmlscript::importLibrary( rLib );
}

}

//==================================================================================================
extern "C" ::xmlscript::XML_script * xmlscript_get()
{
    static XML_script_impl s_impl;
    return &s_impl;
}

