/*
 *  Copyright (C) 2005 Kouji TAKAO <kouji@netlab.jp>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __GPASS_WINDOW_H__
#define __GPASS_WINDOW_H__

#include <gtk/gtktreeview.h>

#include "view.h"
#include "gpass/entry.h"

G_BEGIN_DECLS

typedef struct GPassWindow GPassWindow;
typedef struct GPassWindowClass GPassWindowClass;

#define GPASS_TYPE_WINDOW (gpass_window_get_type())
#define GPASS_WINDOW(obj) \
    (G_TYPE_CHECK_INSTANCE_CAST((obj), GPASS_TYPE_WINDOW, GPassWindow))
#define GPASS_WINDOW_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_CAST((klass), GPASS_TYPE_WINDOW, GPassWindowClass))
#define GPASS_IS_WINDOW(obj) \
    (G_TYPE_CHECK_INSTANCE_TYPE((obj), GPASS_TYPE_WINDOW))
#define GPASS_IS_WINDOW_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_TYPE((klass), GPASS_TYPE_WINDOW))
#define GPASS_WINDOW_GET_CLASS(obj) \
    (G_TYPE_INSTANCE_GET_CLASS((obj), GPASS_TYPE_WINDOW, \
                               GPassWindowClass))

struct GPassWindow {
    GPassView parent;
    
    GPassEntry *current;
    GPassEntry *copied;
    guint lock_timeout;
    guint status_timeout;
    GPassView *attribute_editor;
};

struct GPassWindowClass {
    GPassViewClass parent;
};

GType gpass_window_get_type(void);

void gpass_window_save(GPassWindow *self);
void gpass_window_status_say(GPassWindow *self, const gchar *fmt, ...);
void gpass_window_undo_redo_sensitive(GPassWindow *self);
void gpass_window_edit_items_sensitive(GPassWindow *self);
void gpass_window_before_command(GPassWindow *self);
void gpass_window_after_command(GPassWindow *self);

G_END_DECLS

#endif /* #ifndef __GPASS_WINDOW_H__ */
