/***************************************************************************
                          krecord.h  -  description
                             -------------------
    begin                : Tue Mar 30 2004
    copyright            : (C) 2004-2005 by Christophe Thommeret
    email                : hftom@free.fr
    last modified        : $Date: 2005/04/12 11:15:19 $ by $Author: hftom $
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KRECORD_H
#define KRECORD_H

#include <qdialog.h>
#include <qpixmap.h>

#include <kpushbutton.h>
#include <klistview.h>

#include "channeldesc.h"
#include "ktimereditor.h"



class KRecord : public QDialog
{
	Q_OBJECT

public:

	KRecord( QStringList chanList, QPtrList<RecTimer> *t, QWidget *parent, QSize size, int format );
	~KRecord();

	QStringList channelsList;

protected slots:

	virtual void accept();
	void newTimer();
	void editTimer();
	void deleteTimer();
	void refresh();

private:

	QListViewItem* where( RecTimer *rt, bool add=false );

	KPushButton *newBtn, *editBtn, *deleteBtn, *okBtn;
	KListView *list;
	QPtrList<RecTimer> *timers;
	int prefFormat;
	QPixmap isRecording, yesRepeat;

signals:

	void updateTimer(RecTimer*, int);

};

#endif
