/*
 * This file is part of the KFTPGrabber project
 *
 * Copyright (C) 2003-2005 by the KFTPGrabber developers
 * Copyright (C) 2003-2005 Jernej Kos <kostko@jweb-network.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * is provided AS IS, WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, and
 * NON-INFRINGEMENT.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Steet, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 *
 * In addition, as a special exception, the copyright holders give
 * permission to link the code of portions of this program with the
 * OpenSSL library under certain conditions as described in each
 * individual source file, and distribute linked combinations
 * including the two.
 *
 * You must obey the GNU General Public License in all respects
 * for all of the code used other than OpenSSL.  If you modify
 * file(s) with this exception, you may extend this exception to your
 * version of the file(s), but you are not obligated to do so.  If you
 * do not wish to do so, delete this exception statement from your
 * version.  If you delete this exception statement from all source
 * files in the program, then also delete it here.
 */

#include <qdom.h>
#include <qlabel.h>
#include <qtoolbox.h>
#include <qregexp.h>
#include <qtimer.h>

#include <kdebug.h>

#include "kftpservermanagement.h"

#include "listview.h"
#include "sidebar.h"

namespace KFTPWidgets {

namespace ServerManagement {

///////////////////////////////////////////////////////////////////////////////
///////////////////     Sidebar     ///////////////////
///////////////////////////////////////////////////////////////////////////////

Sidebar::Sidebar(QWidget* parent, const char *name)
  : QVBox(parent, name)
{
  init();
}

void Sidebar::init()
{
//   m_status = new QLabel(this, "status Label");
  m_toolBox = new QToolBox(this, "QToolBox");

//   m_status->setFrameShape( QLabel::Box );

  slotPopulateSidebar();
}

Sidebar::~Sidebar()
{
}

void Sidebar::slotPopulateSidebar()
{
  QDomDocument doc = FTPServerManagement->m_document;
  QDomNodeList list = doc.elementsByTagName("server");

//   kdDebug() << list.count() << endl;
  for( unsigned int i = 0; i < list.count(); ++i ) {
    ListView* listView = new ListView(FTPServerManagement, m_toolBox);
    FTPServerManagement->guiPopulateServerManagementTree(listView, list.item(i));

    m_toolBox->addItem(listView, list.item(i).toElement().attribute("name"));

//     kdDebug() << list.item(i).toElement().attribute("name") << endl;
    connect(listView, SIGNAL(setStatus(const QString&)),this,SLOT(slotSetStatus(const QString&)));
  }
}

void Sidebar::slotSetStatus(const QString&)
{
//   m_status->setText(status);
}

}

}

#include "sidebar.moc"
