/*  Window monitor / desktop
 *  Copyright (C) 2005 UCHINO Satoshi.  All Rights Reserved.
 *
 *  This is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This software is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
 *  USA.
 */

#ifndef CONFFILE_H
#define CONFFILE_H

#include <vector>
#include <map>
#include <set>
#include <string>
#include <boost/shared_ptr.hpp>

using namespace std;

class ConfigFile {
  static char default_xdg_data_home[];
  static char default_xdg_config_home[];
  static char default_xdg_data_dirs[];
  static char default_xdg_config_dirs[];

  static void splitLocale(const string& locale, string& lang, string& country, string& modifier);

 public:
  struct Item {
    string locale;
    bool hasLang;
    bool hasCountry;
    bool hasModifier;
    string body;
  };
  typedef map<string, Item> ItemMap;
  typedef boost::shared_ptr<ItemMap> SpItemMap;
  typedef map<string, SpItemMap> ItemMapMap;
  typedef boost::shared_ptr<ItemMapMap> SpItemMapMap;

  static vector<string>* getXdgDataDirs();
  static vector<string>* getXdgConfigDirs();

  static SpItemMap readSection(const string& filename, 
			       const string& section,
			       const string& locale,
			       const set<string>& keySet);
  static SpItemMapMap readSectionSet(const string& filename, 
				     const set<string>& sectionSet,
				     const string& locale,
				     const set<string>& keySet);
};

#endif /*CONFFILE_H*/
