/*  Window monitor / server data request handler
 *  Copyright (C) 2005 UCHINO Satoshi.  All Rights Reserved.
 *
 *  This is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This software is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
 *  USA.
 */

#ifdef __cplusplus
extern "C" {
#endif
void processServerDataReqMsg(rfbServerDataReqMsg *msg);
void launch(unsigned long id);
void sendWindowIcon(WnckWindow *window);
void deleteWindowIcon(WnckWindow *window);
#ifdef __cplusplus
}

#include "clientmgr.h"
#include "iconmgr.h"
#include "launcher.h"
#include "rfbproto.h"

class ServerData {
  ClientMgr* clientMgr;
  IconMgr* iconMgr;
  Launcher* launcher;
  TmpFileMgr* tmpFileMgr;

  bool createTmpIconFileKey(string &key, WnckWindow *window, int iconSize);

 public:
  ServerData();
  ~ServerData();
  void processServerDataMenuPref(unsigned long cl, rfbServerDataMenuPrefReq *menuPrefReq);
  void processServerDataIconPref(unsigned long cl, rfbServerDataIconPrefReq *iconpref);
  void clientGone(unsigned long cl);
  bool launch(unsigned long id);
  static bool sendWindowIconCallback(unsigned long clientPtr, const ClientMgr::IconPref& iconPref, void *_this, void *param);
  bool sendWindowIcon(unsigned long clientPtr, const ClientMgr::IconPref& iconPref, WnckWindow *window);
  bool sendWindowIcon(WnckWindow *window);
  bool deleteWindowIcon(WnckWindow *window);
  bool sendAllWindowIcons(unsigned long clientPtr);
};
#endif
