/*  Window monitor / tmpfile manager
 *  Copyright (C) 2005 UCHINO Satoshi.  All Rights Reserved.
 *
 *  This is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This software is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
 *  USA.
 */

#ifndef TMPFILEMGR_H
#define TMPFILEMGR_H

#include <string>
#include <map>

using namespace std;

class TmpFileMgr {
  typedef map<string, string> TmpFileDB;
  TmpFileDB tmpFileDB;	// name -> realpath
  static const char tmpFileTemplate[];

 public:
  TmpFileMgr();
  ~TmpFileMgr();

  // lookup a temporary file from name
  // name     : key
  // realpath : pathname of the temporary file if found
  // return value : file descriptor of the temporary file or -1 on error
  int lookupTmpFile(const string& name, string &realpath);

  // create a temporary file from name
  // name     : key
  // realpath : pathname of the temporary file
  // return value : file descriptor of the temporary file or -1 on error
  int createTmpFile(const string& name, string &realpath);
};

#endif /*TMPFILEMGR_H*/
