/*
 *  Copyright (C) 2004 UCHINO Satoshi.  All Rights Reserved.
 *  Copyright (C) 2002 Alan Hourihane.  All Rights Reserved.
 *
 *  This is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This software is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
 *  USA.
 *
 *  Author: Alan Hourihane <alanh@fairlite.demon.co.uk>
 */
/*
 *  Modified for MetaVNC by UCHINO Satoshi <utinos@users.sourceforge.net>
 *  The xf4vnc original extensions are replaced with the RealVNC 4.0
 *  extensions (VncExtInit.cc: Copyright (C) 2002-2004 RealVNC Ltd.)
 *  to support the vncconfig command.
 */

#ifndef _VNCSTR_H
#define _VNCSTR_H

#include <X11/extensions/vnc.h>

#ifdef REALVNC4_EXT

#define VNC_EXTENSION_NAME		"VNC-EXTENSION"  /* RealVNC4's ext */

#define X_VncExtSetParam 0
#define X_VncExtGetParam 1
#define X_VncExtGetParamDesc 2
#define X_VncExtListParams 3
#define X_VncExtSetServerCutText 4
#define X_VncExtGetClientCutText 5
#define X_VncExtSelectInput 6
#define X_VncExtConnect 7

typedef struct {
  CARD8 reqType;       /* always VncExtReqCode */
  CARD8 vncExtReqType; /* always VncExtSetParam */
  CARD16 length B16;
  CARD8 paramLen;
  CARD8 pad0;
  CARD16 pad1 B16;
} xVncExtSetParamReq;
#define sz_xVncExtSetParamReq 8

typedef struct {
 BYTE type; /* X_Reply */
 BYTE success;
 CARD16 sequenceNumber B16;
 CARD32 length B32;
 CARD32 pad0 B32;
 CARD32 pad1 B32;
 CARD32 pad2 B32;
 CARD32 pad3 B32;
 CARD32 pad4 B32;
 CARD32 pad5 B32;
} xVncExtSetParamReply;
#define sz_xVncExtSetParamReply 32

typedef struct {
  CARD8 reqType;       /* always VncExtReqCode */
  CARD8 vncExtReqType; /* always VncExtGetParam */
  CARD16 length B16;
  CARD8 paramLen;
  CARD8 pad0;
  CARD16 pad1 B16;
} xVncExtGetParamReq;
#define sz_xVncExtGetParamReq 8

typedef struct {
 BYTE type; /* X_Reply */
 BYTE success;
 CARD16 sequenceNumber B16;
 CARD32 length B32;
 CARD16 valueLen B16;
 CARD16 pad0 B16;
 CARD32 pad1 B32;
 CARD32 pad2 B32;
 CARD32 pad3 B32;
 CARD32 pad4 B32;
 CARD32 pad5 B32;
} xVncExtGetParamReply;
#define sz_xVncExtGetParamReply 32

typedef struct {
  CARD8 reqType;       /* always VncExtReqCode */
  CARD8 vncExtReqType; /* always VncExtSetServerCutText */
  CARD16 length B16;
  CARD32 textLen B32;
} xVncExtSetServerCutTextReq;
#define sz_xVncExtSetServerCutTextReq 8


typedef struct {
  CARD8 reqType;       /* always VncExtReqCode */
  CARD8 vncExtReqType; /* always VncExtGetClientCutText */
  CARD16 length B16;
} xVncExtGetClientCutTextReq;
#define sz_xVncExtGetClientCutTextReq 4

typedef struct {
 BYTE type; /* X_Reply */
 BYTE pad0;
 CARD16 sequenceNumber B16;
 CARD32 length B32;
 CARD32 textLen B32;
 CARD32 pad1 B32;
 CARD32 pad2 B32;
 CARD32 pad3 B32;
 CARD32 pad4 B32;
 CARD32 pad5 B32;
} xVncExtGetClientCutTextReply;
#define sz_xVncExtGetClientCutTextReply 32


typedef struct {
  CARD8 reqType;       /* always VncExtReqCode */
  CARD8 vncExtReqType; /* always VncExtSelectInput */
  CARD16 length B16;
  CARD32 window B32;
  CARD32 mask B32;
} xVncExtSelectInputReq;
#define sz_xVncExtSelectInputReq 12


typedef struct {
  CARD8 reqType;       /* always VncExtReqCode */
  CARD8 vncExtReqType; /* always VncExtConnect */
  CARD16 length B16;
  CARD8 strLen;
  CARD8 pad0;
  CARD16 pad1 B16;
} xVncExtConnectReq;
#define sz_xVncExtConnectReq 8

typedef struct {
  BYTE type;    /* always eventBase + VncExtClientCutTextNotify */
  BYTE pad0;
  CARD16 sequenceNumber B16;
  CARD32 window B32;
  CARD32 time B32;
  CARD32 pad1 B32;
  CARD32 pad2 B32;
  CARD32 pad3 B32;
  CARD32 pad4 B32;
  CARD32 pad5 B32;
} xVncExtClientCutTextNotifyEvent;
#define sz_xVncExtClientCutTextNotifyEvent 32

typedef struct {
  BYTE type;    /* always eventBase + VncExtSelectionChangeNotify */
  BYTE pad0;
  CARD16 sequenceNumber B16;
  CARD32 window B32;
  CARD32 selection B32;
  CARD32 pad1 B32;
  CARD32 pad2 B32;
  CARD32 pad3 B32;
  CARD32 pad4 B32;
  CARD32 pad5 B32;
} xVncExtSelectionChangeNotifyEvent;
#define sz_xVncExtSelectionChangeNotifyEvent 32

#else /*REALVNC4_EXT*/

#define VNC_EXTENSION_NAME		"VNC"   /* xf4vnc's extension */

#define VNC_MAJOR_VERSION		2
#define VNC_MINOR_VERSION		0

#define X_VncQueryVersion		0
#define X_VncSelectNotify		1
#define X_VncConnection			2
#define X_VncListConnections		3
#define X_VncChromiumStart		4
#define X_VncChromiumMonitor		5

#endif /*REALVNC4_EXT*/

typedef struct {
    CARD8       reqType;
    CARD8       vncReqType;
    CARD16      length B16;
    CARD16      majorVersion B16;
    CARD16      minorVersion B16;
} xVncQueryVersionReq;
#define sz_xVncQueryVersionReq 	8

typedef struct {
    CARD8   type;
    CARD8   pad0;
    CARD16  sequenceNumber B16;
    CARD32  length	 B32;
    CARD16  majorVersion B16;
    CARD16  minorVersion B16;
    CARD32  pad1	 B32;
    CARD32  pad2	 B32;
    CARD32  pad3	 B32;
    CARD32  pad4	 B32;
    CARD32  pad5	 B32;
 } xVncQueryVersionReply;
#define sz_xVncQueryVersionReply  	32

typedef struct {
    CARD8       reqType;
    CARD8       vncReqType;
    CARD16      length B16;
    BOOL	onoff;
    CARD8       pad0;
    CARD16      pad1 B16;
} xVncSelectNotifyReq;
#define sz_xVncSelectNotifyReq 	8

typedef struct {
    CARD8   type;
    CARD8   pad0;
    CARD16  sequenceNumber B16;
    CARD32  length	 B32;
    CARD32  pad1	 B32;
    CARD32  pad2	 B32;
    CARD32  pad3	 B32;
    CARD32  pad4	 B32;
    CARD32  pad5	 B32;
    CARD32  pad6	 B32;
 } xVncSelectNotifyReply;
#define sz_xVncSelectNotifyReply  	32

typedef struct {
    CARD8       reqType;
    CARD8       vncReqType;
    CARD16      length B16;
    CARD16      sock B16;
    CARD16      accept B16;
} xVncConnectionReq;
#define sz_xVncConnectionReq 	8

typedef struct {
    CARD8   type;
    CARD8   pad0;
    CARD16  sequenceNumber B16;
    CARD32  length	 B32;
    CARD16  sock B16;
    CARD16  accept B16;
    CARD32  pad1	 B32;
    CARD32  pad2	 B32;
    CARD32  pad3	 B32;
    CARD32  pad4	 B32;
    CARD32  pad5	 B32;
 } xVncConnectionReply;
#define sz_xVncConnectionReply  	32

typedef struct {
    CARD8       reqType;
    CARD8       vncReqType;
    CARD16      length B16;
    CARD16      pad0 B16;
    CARD16      pad1 B16;
} xVncListConnectionsReq;
#define sz_xVncListConnectionsReq 	8

typedef struct {
    CARD8   type;
    CARD8   pad0;
    CARD16  sequenceNumber B16;
    CARD32  length	 B32;
    CARD32  count	 B32;
    CARD32  pad2	 B32;
    CARD32  pad3	 B32;
    CARD32  pad4	 B32;
    CARD32  pad5	 B32;
    CARD32  pad6	 B32;
 } xVncListConnectionsReply;
#define sz_xVncListConnectionsReply  	32

typedef struct {
    CARD32	ipaddress;
    CARD32	pad1;
} xVncConnectionListInfo;
#define sz_xVncConnectionListInfo	8

typedef struct {
    CARD8       reqType;
    CARD8       vncReqType;
    CARD16      length B16;
    CARD32      port B32;
    CARD32      ipaddress B32;
} xVncChromiumStartReq;
#define sz_xVncChromiumStartReq 	12

typedef struct {
    CARD8   type;
    CARD8   pad0;
    CARD16  sequenceNumber B16;
    CARD32  length	 B32;
    CARD32  pad1	 B32;
    CARD32  pad2	 B32;
    CARD32  pad3	 B32;
    CARD32  pad4	 B32;
    CARD32  pad5	 B32;
    CARD32  pad6	 B32;
 } xVncChromiumStartReply;
#define sz_xVncChromiumStartReply  	32

typedef struct {
    CARD8       reqType;
    CARD8       vncReqType;
    CARD16      length B16;
    CARD32      windowid B32;
    CARD32	cr_windowid B32;
} xVncChromiumMonitorReq;
#define sz_xVncChromiumMonitorReq 	12

typedef struct {
    CARD8   type;
    CARD8   pad0;
    CARD16  sequenceNumber B16;
    CARD32  length	 B32;
    CARD32  pad1	 B32;
    CARD32  pad2	 B32;
    CARD32  pad3	 B32;
    CARD32  pad4	 B32;
    CARD32  pad5	 B32;
    CARD32  pad6	 B32;
 } xVncChromiumMonitorReply;
#define sz_xVncChromiumMonitorReply  	32

typedef struct _xVncConnectedEvent {
    BYTE	type;
    BYTE	detail;
    CARD16	sequenceNumber B16;
    CARD32	connected B32;
    CARD32	ipaddress B32;
    CARD32	pad1	 B32;
    CARD32	pad2	 B32;
    CARD32	pad3	 B32;
    CARD32	pad4	 B32;
    CARD32	pad5	 B32;
} xVncConnectedEvent;
#define sz_xVncConnectedEvent 32

typedef struct _xVncDisconnectedEvent {
    BYTE	type;
    BYTE	detail;
    CARD16	sequenceNumber B16;
    CARD32	connected B32;
    CARD32	pad0     B32;
    CARD32	pad1	 B32;
    CARD32	pad2	 B32;
    CARD32	pad3	 B32;
    CARD32	pad4	 B32;
    CARD32	pad5	 B32;
} xVncDisconnectedEvent;
#define sz_xVncDisconnectedEvent 32

#endif /* _VNCSTR_H */
