/***************************************************************************
 *   Copyright (C) 2003 by Mark Kretschmann                                *
 *   markey@web.de                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/


#ifndef CONFIGPARSER_H
#define CONFIGPARSER_H

using namespace std;


class ConfigParser
{
    public:
        ConfigParser();
        ~ConfigParser();

        int readIntEntry( const string &key, int defaultVal );
        unsigned int readUintEntry( const string &key, unsigned int defaultVal );
        string readStringEntry( const string &key, string defaultVal );

        void writeEntry( const string &key, int value );
        void writeEntry( const string &key, unsigned int value );
        void writeEntry( const string &key, string value );

        void readConfig( const string &fileName );
        void writeConfig();

// ATTRIBUTES ---------

    private:
        string getValue( const string &key );
        void replaceValue( const string &key, const string &value );
        void findValue( uint &valPos, uint &valLen, const string &key );

// ATTRIBUTES ---------
    string m_fileName;
    ofstream *m_pOutput;
    string m_configStr;
};


#endif
