/*
 * ibt.h - NILFS B-tree operations.
 *
 * Copyright (C) 2005 Nippon Telegraph and Telephone Corporation.
 *
 * This file is part of NILFS.
 *
 * NILFS is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * NILFS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with NILFS; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * ibt.h,v 1.1 2005/09/15 09:48:01 koji Exp
 *
 * Written by Koji Sato <koji@osrg.net>
 */

#ifndef _NILFS_IBT_H
#define _NILFS_IBT_H

#include "btree.h"

struct nilfs_ibt_info {
	nilfs_btree_key_t i_min_key;
	nilfs_btree_key_t i_last_key;
};

int nilfs_ibt_init(struct nilfs_btree *, dbn_t, void *);

#endif	/* _NILFS_IBT_H */

/* Local Variables:	*/
/* eval: (c-set-style "linux")	*/
/* End:			*/
