/*
 * radix-tree-64.h - 64bit version of radix-tree.h
 *
 * Copyright (C) 2005 Nippon Telegraph and Telephone Corporation.
 *
 * This file is part of NILFS.
 *
 * radix-tree-64.h,v 1.8 2006/01/17 04:24:26 kihara Exp
 *
 * Modified for NILFS by Seiji Kihara <kihara@osrg.net>
 *
 * Modifications:
 *  (a) change the key types from unsigned long to __u64,
 *	to handle 64bit keys on 32(<64)bits-architecure machines
 *  (b) change the extern function names from radix_tree_xxx to
 *      radix_tree_64_xxx
 *  (c) add new functions for NILFS
 *      - radix_tree_64_destroy()
 *      - radix_tree_64_force_empty() and __find_first_index()
 */
/*
 * Copyright (C) 2001 Momchil Velikov
 * Portions Copyright (C) 2001 Christoph Hellwig
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef _NILFS_RADIX_TREE_64_H
#define _NILFS_RADIX_TREE_64_H

#include <linux/preempt.h>
#include <linux/types.h>
#include "kern_feature.h"

struct radix_tree_64_root {
	unsigned int		height;
	gfp_t			gfp_mask;
	struct radix_tree_64_node	*rnode;
};

#define RADIX_TREE_64_INIT(mask)	{					\
	.height = 0,							\
	.gfp_mask = (mask),						\
	.rnode = NULL,							\
}

#define RADIX_TREE_64(name, mask) \
	struct radix_tree_64_root name = RADIX_TREE_64_INIT(mask)

#define INIT_RADIX_TREE_64(root, mask)					\
do {									\
	(root)->height = 0;						\
	(root)->gfp_mask = (mask);					\
	(root)->rnode = NULL;						\
} while (0)

int radix_tree_64_insert(struct radix_tree_64_root *, __u64, void *);
void *radix_tree_64_lookup(struct radix_tree_64_root *, __u64);
void **radix_tree_64_lookup_slot(struct radix_tree_64_root *, __u64);
void *radix_tree_64_delete(struct radix_tree_64_root *, __u64);
unsigned int
radix_tree_64_gang_lookup(struct radix_tree_64_root *root, void **results,
			  __u64 first_index, unsigned int max_items);
int radix_tree_64_preload(gfp_t gfp_mask);
void radix_tree_64_init(void);
void radix_tree_64_destroy(void);
void *radix_tree_64_tag_set(struct radix_tree_64_root *root,
			    __u64 index, int tag);
void *radix_tree_64_tag_clear(struct radix_tree_64_root *root,
			      __u64 index, int tag);
int radix_tree_64_tag_get(struct radix_tree_64_root *root,
			  __u64 index, int tag);
unsigned int
radix_tree_64_gang_lookup_tag(struct radix_tree_64_root *root, void **results,
			      __u64 first_index, unsigned int max_items,
			      int tag);
int radix_tree_64_tagged(struct radix_tree_64_root *root, int tag);
void radix_tree_64_force_empty(struct radix_tree_64_root *root);

static inline void radix_tree_64_preload_end(void)
{
	preempt_enable();
}

#endif /* _NILFS_RADIX_TREE_64_H */
