#!/bin/sh
#
# auto.nilfs.dev - automount map for NILFS
#
# Copyright (C) 2006 Nippon Telegraph and Telephone Corporation.
# This file is part of NILFS and is licensed under the GPL.
#
# auto.nilfs.dev.sh,v 1.4 2006/02/20 06:18:44 moriai Exp
#
# Written by Satoshi Moriai <moriai@osrg.net>
#
# usage:
#    1)	copy this file to /etc/auto.nilfs.<devname>, where <devname> is
#	the device name of a nilfs volume.
#    2)	umount the nilfs volume and comment out the corresponding line
#	in /etc/fstab.
#    3)	invoke automount as follows.
#	    # automount <mount-point> program /etc/auto.nilfs.<devname>
#	or, modify /etc/auto.master and restart automount.
#    4)	chdir <mount-point>/<date>, and you can access the snapshot
#	dated at <date>.
#

device=`expr "$0" : '.*\.\([^.]*\)'` || exit 1
device="/dev/$device"

case "$1" in
cur)	# mount the current image read/write
	MNTLINE="-fstype=nilfs			:$device"
	;;

*)	# mount the snapshot image read-only
	cp=`/sbin/seekcp $device "$1"` || exit 1
	MNTLINE="-fstype=nilfs,ro,cp=$cp	:$device"
	;;
esac

echo "$MNTLINE"
exit 0
