/*
 * This file is autogenerated with bcop:
 * The Compiz option code generator
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <compiz-core.h>

#include "wallpaper_options.h"

static int WallpaperOptionsDisplayPrivateIndex;

static CompMetadata wallpaperOptionsMetadata;

static CompPluginVTable *wallpaperPluginVTable = NULL;
CompPluginVTable wallpaperOptionsVTable;

#define WALLPAPER_OPTIONS_DISPLAY(d) PLUGIN_DISPLAY(d, WallpaperOptions, o)
#define WALLPAPER_OPTIONS_SCREEN(s) PLUGIN_SCREEN(s, WallpaperOptions, o)

typedef struct _WallpaperOptionsDisplay
{
    int screenPrivateIndex;

} WallpaperOptionsDisplay;

typedef struct _WallpaperOptionsScreen
{
    CompOption opt[WallpaperScreenOptionNum];
    wallpaperScreenOptionChangeNotifyProc notify[WallpaperScreenOptionNum];
    unsigned int bg_image_pos;
    unsigned int bg_fill_type;
} WallpaperOptionsScreen;

CompListValue * wallpaperGetBgImage (CompScreen *s)
{
    WALLPAPER_OPTIONS_SCREEN(s);
    return &os->opt[WallpaperScreenOptionBgImage].value.list;
}

CompOption * wallpaperGetBgImageOption (CompScreen *s)
{
    WALLPAPER_OPTIONS_SCREEN(s);
    return &os->opt[WallpaperScreenOptionBgImage];
}

void wallpaperSetBgImageNotify (CompScreen *s, wallpaperScreenOptionChangeNotifyProc notify)
{
    WALLPAPER_OPTIONS_SCREEN(s);
    os->notify[WallpaperScreenOptionBgImage] = notify;
}

CompListValue * wallpaperGetBgImagePos (CompScreen *s)
{
    WALLPAPER_OPTIONS_SCREEN(s);
    return &os->opt[WallpaperScreenOptionBgImagePos].value.list;
}

unsigned int wallpaperGetBgImagePosMask (CompScreen *s)
{
    WALLPAPER_OPTIONS_SCREEN(s);
    return os->bg_image_pos;
}

CompOption * wallpaperGetBgImagePosOption (CompScreen *s)
{
    WALLPAPER_OPTIONS_SCREEN(s);
    return &os->opt[WallpaperScreenOptionBgImagePos];
}

void wallpaperSetBgImagePosNotify (CompScreen *s, wallpaperScreenOptionChangeNotifyProc notify)
{
    WALLPAPER_OPTIONS_SCREEN(s);
    os->notify[WallpaperScreenOptionBgImagePos] = notify;
}

CompListValue * wallpaperGetBgFillType (CompScreen *s)
{
    WALLPAPER_OPTIONS_SCREEN(s);
    return &os->opt[WallpaperScreenOptionBgFillType].value.list;
}

unsigned int wallpaperGetBgFillTypeMask (CompScreen *s)
{
    WALLPAPER_OPTIONS_SCREEN(s);
    return os->bg_fill_type;
}

CompOption * wallpaperGetBgFillTypeOption (CompScreen *s)
{
    WALLPAPER_OPTIONS_SCREEN(s);
    return &os->opt[WallpaperScreenOptionBgFillType];
}

void wallpaperSetBgFillTypeNotify (CompScreen *s, wallpaperScreenOptionChangeNotifyProc notify)
{
    WALLPAPER_OPTIONS_SCREEN(s);
    os->notify[WallpaperScreenOptionBgFillType] = notify;
}

CompListValue * wallpaperGetBgColor1 (CompScreen *s)
{
    WALLPAPER_OPTIONS_SCREEN(s);
    return &os->opt[WallpaperScreenOptionBgColor1].value.list;
}

CompOption * wallpaperGetBgColor1Option (CompScreen *s)
{
    WALLPAPER_OPTIONS_SCREEN(s);
    return &os->opt[WallpaperScreenOptionBgColor1];
}

void wallpaperSetBgColor1Notify (CompScreen *s, wallpaperScreenOptionChangeNotifyProc notify)
{
    WALLPAPER_OPTIONS_SCREEN(s);
    os->notify[WallpaperScreenOptionBgColor1] = notify;
}

CompListValue * wallpaperGetBgColor2 (CompScreen *s)
{
    WALLPAPER_OPTIONS_SCREEN(s);
    return &os->opt[WallpaperScreenOptionBgColor2].value.list;
}

CompOption * wallpaperGetBgColor2Option (CompScreen *s)
{
    WALLPAPER_OPTIONS_SCREEN(s);
    return &os->opt[WallpaperScreenOptionBgColor2];
}

void wallpaperSetBgColor2Notify (CompScreen *s, wallpaperScreenOptionChangeNotifyProc notify)
{
    WALLPAPER_OPTIONS_SCREEN(s);
    os->notify[WallpaperScreenOptionBgColor2] = notify;
}

CompOption * wallpaperGetScreenOption (CompScreen *s, WallpaperScreenOptions num)
{
    WALLPAPER_OPTIONS_SCREEN(s);
    return &os->opt[num];
}

static const CompMetadataOptionInfo wallpaperOptionsScreenOptionInfo[] = {
    { "bg_image", "list", "<type>string</type>", 0, 0 },
    { "bg_image_pos", "list", "<type>int</type>", 0, 0 },
    { "bg_fill_type", "list", "<type>int</type>", 0, 0 },
    { "bg_color1", "list", "<type>color</type>", 0, 0 },
    { "bg_color2", "list", "<type>color</type>", 0, 0 },
};

static Bool wallpaperOptionsSetScreenOption (CompPlugin *plugin, CompScreen *s, const char *name, CompOptionValue *value)
{
    WALLPAPER_OPTIONS_SCREEN(s);
    CompOption *o;
    int        index;

    o = compFindOption (os->opt, WallpaperScreenOptionNum, name, &index);

    if (!o)
        return FALSE;

    switch (index)
    {
     case WallpaperScreenOptionBgImage:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[WallpaperScreenOptionBgImage])
                (*os->notify[WallpaperScreenOptionBgImage]) (s, o, WallpaperScreenOptionBgImage);
            return TRUE;
        }
        break;
     case WallpaperScreenOptionBgImagePos:
        if (compSetScreenOption (s, o, value))
        {
            int i;
            os->bg_image_pos = 0;
            for (i = 0; i < o->value.list.nValue; i++)
                os->bg_image_pos |= (1 << o->value.list.value[i].i);
            if (os->notify[WallpaperScreenOptionBgImagePos])
                (*os->notify[WallpaperScreenOptionBgImagePos]) (s, o, WallpaperScreenOptionBgImagePos);
            return TRUE;
        }
        break;
     case WallpaperScreenOptionBgFillType:
        if (compSetScreenOption (s, o, value))
        {
            int i;
            os->bg_fill_type = 0;
            for (i = 0; i < o->value.list.nValue; i++)
                os->bg_fill_type |= (1 << o->value.list.value[i].i);
            if (os->notify[WallpaperScreenOptionBgFillType])
                (*os->notify[WallpaperScreenOptionBgFillType]) (s, o, WallpaperScreenOptionBgFillType);
            return TRUE;
        }
        break;
     case WallpaperScreenOptionBgColor1:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[WallpaperScreenOptionBgColor1])
                (*os->notify[WallpaperScreenOptionBgColor1]) (s, o, WallpaperScreenOptionBgColor1);
            return TRUE;
        }
        break;
     case WallpaperScreenOptionBgColor2:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[WallpaperScreenOptionBgColor2])
                (*os->notify[WallpaperScreenOptionBgColor2]) (s, o, WallpaperScreenOptionBgColor2);
            return TRUE;
        }
        break;
    default:
        break;
    }
    return FALSE;
}

static CompOption * wallpaperOptionsGetScreenOptions (CompPlugin *plugin, CompScreen *s, int *count)
{
    WALLPAPER_OPTIONS_SCREEN(s);
    *count = WallpaperScreenOptionNum;
    return os->opt;
}

static Bool wallpaperOptionsInitScreen (CompPlugin *p, CompScreen *s)
{
    WallpaperOptionsScreen *os;
    CompOption *o;
    int i;
    
    WALLPAPER_OPTIONS_DISPLAY (s->display);

    os = calloc (1, sizeof(WallpaperOptionsScreen));
    if (!os)
        return FALSE;

    s->base.privates[od->screenPrivateIndex].ptr = os;

    if (!compInitScreenOptionsFromMetadata (s, &wallpaperOptionsMetadata, wallpaperOptionsScreenOptionInfo, os->opt, WallpaperScreenOptionNum))
    {
        free (os);
        return FALSE;
    }
    o = &os->opt[WallpaperScreenOptionBgImagePos];
    os->bg_image_pos = 0;
    for (i = 0; i < o->value.list.nValue; i++)
        os->bg_image_pos |= (1 << o->value.list.value[i].i);

    o = &os->opt[WallpaperScreenOptionBgFillType];
    os->bg_fill_type = 0;
    for (i = 0; i < o->value.list.nValue; i++)
        os->bg_fill_type |= (1 << o->value.list.value[i].i);


    return TRUE;
}

static void wallpaperOptionsFiniScreen (CompPlugin *p, CompScreen *s)
{
    WALLPAPER_OPTIONS_SCREEN (s);


    compFiniScreenOptions (s, os->opt, WallpaperScreenOptionNum);

    free (os);
}

static Bool wallpaperOptionsInitDisplay (CompPlugin *p, CompDisplay *d)
{
    WallpaperOptionsDisplay *od;
   
    
    od = calloc (1, sizeof(WallpaperOptionsDisplay));
    if (!od)
        return FALSE;

    od->screenPrivateIndex = allocateScreenPrivateIndex(d);
    if (od->screenPrivateIndex < 0)
    {
        free(od);
        return FALSE;
    }

    d->base.privates[WallpaperOptionsDisplayPrivateIndex].ptr = od;

    
    return TRUE;
}

static void wallpaperOptionsFiniDisplay (CompPlugin *p, CompDisplay *d)
{
    WALLPAPER_OPTIONS_DISPLAY (d);

    freeScreenPrivateIndex(d, od->screenPrivateIndex);
    free (od);
}

static Bool wallpaperOptionsInit (CompPlugin *p)
{
    WallpaperOptionsDisplayPrivateIndex = allocateDisplayPrivateIndex();
    if (WallpaperOptionsDisplayPrivateIndex < 0)
        return FALSE;

    if (!compInitPluginMetadataFromInfo (&wallpaperOptionsMetadata, "wallpaper",0, 0, wallpaperOptionsScreenOptionInfo, WallpaperScreenOptionNum))
        return FALSE;

    compAddMetadataFromFile (&wallpaperOptionsMetadata, "wallpaper");
    if (wallpaperPluginVTable && wallpaperPluginVTable->init)
        return wallpaperPluginVTable->init (p);
    return TRUE;
}

static void wallpaperOptionsFini (CompPlugin *p)
{
    if (wallpaperPluginVTable && wallpaperPluginVTable->fini)
        wallpaperPluginVTable->fini (p);

    if (WallpaperOptionsDisplayPrivateIndex >= 0)
        freeDisplayPrivateIndex (WallpaperOptionsDisplayPrivateIndex);

    compFiniMetadata (&wallpaperOptionsMetadata);
}

static CompBool wallpaperOptionsInitObject (CompPlugin *p, CompObject *o)
{
    static InitPluginObjectProc dispTab[] = {
        (InitPluginObjectProc) 0,
        (InitPluginObjectProc) wallpaperOptionsInitDisplay,
        (InitPluginObjectProc) wallpaperOptionsInitScreen
    };

    RETURN_DISPATCH (o, dispTab, ARRAY_SIZE (dispTab), TRUE, (p, o));
}

static void wallpaperOptionsFiniObject (CompPlugin *p, CompObject *o)
{
    static FiniPluginObjectProc dispTab[] = {
        (FiniPluginObjectProc) 0,
        (FiniPluginObjectProc) wallpaperOptionsFiniDisplay,
        (FiniPluginObjectProc) wallpaperOptionsFiniScreen
    };

    DISPATCH (o, dispTab, ARRAY_SIZE (dispTab), (p, o));
}

static CompBool wallpaperOptionsInitObjectWrapper (CompPlugin *p, CompObject *o)
{
    CompBool rv = TRUE;
    rv = wallpaperOptionsInitObject (p, o);
    if (wallpaperPluginVTable->initObject)
        rv &= wallpaperPluginVTable->initObject (p, o);
    return rv;
}

static void wallpaperOptionsFiniObjectWrapper (CompPlugin *p, CompObject *o)
{
    if (wallpaperPluginVTable->finiObject)
        wallpaperPluginVTable->finiObject (p, o);
    wallpaperOptionsFiniObject (p, o);
}

static CompOption * wallpaperOptionsGetObjectOptions (CompPlugin *p, CompObject *o, int *count)
{
    static GetPluginObjectOptionsProc dispTab[] = {
        (GetPluginObjectOptionsProc) 0,
            (GetPluginObjectOptionsProc) 0,
        (GetPluginObjectOptionsProc) wallpaperOptionsGetScreenOptions
    };

    *count = 0;
    RETURN_DISPATCH (o, dispTab, ARRAY_SIZE (dispTab),
		     NULL, (p, o, count));
}

static CompBool wallpaperOptionsSetObjectOption (CompPlugin *p, CompObject *o, const char *name, CompOptionValue *value)
{
    static SetPluginObjectOptionProc dispTab[] = {
        (SetPluginObjectOptionProc) 0,
        (SetPluginObjectOptionProc) 0,
        (SetPluginObjectOptionProc) wallpaperOptionsSetScreenOption
    };

    RETURN_DISPATCH (o, dispTab, ARRAY_SIZE (dispTab), FALSE,
		     (p, o, name, value));
}

static CompMetadata *
wallpaperOptionsGetMetadata (CompPlugin *plugin)
{
    return &wallpaperOptionsMetadata;
}

CompPluginVTable *getCompPluginInfo20070830 (void)
{
    if (!wallpaperPluginVTable)
    {
        wallpaperPluginVTable = getCompPluginInfo ();
        memcpy(&wallpaperOptionsVTable, wallpaperPluginVTable, sizeof(CompPluginVTable));
        wallpaperOptionsVTable.getMetadata = wallpaperOptionsGetMetadata;
        wallpaperOptionsVTable.init = wallpaperOptionsInit;
        wallpaperOptionsVTable.fini = wallpaperOptionsFini;
        wallpaperOptionsVTable.initObject = wallpaperOptionsInitObjectWrapper;
        wallpaperOptionsVTable.finiObject = wallpaperOptionsFiniObjectWrapper;
        wallpaperOptionsVTable.getObjectOptions = wallpaperOptionsGetObjectOptions;
	wallpaperOptionsVTable.setObjectOption = wallpaperOptionsSetObjectOption;
	
    }
    return &wallpaperOptionsVTable;
}

