/*
 * This file is autogenerated with bcop:
 * The Compiz option code generator
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <compiz-core.h>

#include "mag_options.h"

static int MagOptionsDisplayPrivateIndex;

static CompMetadata magOptionsMetadata;

static CompPluginVTable *magPluginVTable = NULL;
CompPluginVTable magOptionsVTable;

#define MAG_OPTIONS_DISPLAY(d) PLUGIN_DISPLAY(d, MagOptions, o)
#define MAG_OPTIONS_SCREEN(s) PLUGIN_SCREEN(s, MagOptions, o)

typedef struct _MagOptionsDisplay
{
    int screenPrivateIndex;

    CompOption opt[MagDisplayOptionNum];
    magDisplayOptionChangeNotifyProc notify[MagDisplayOptionNum];
} MagOptionsDisplay;

typedef struct _MagOptionsScreen
{
    CompOption opt[MagScreenOptionNum];
    magScreenOptionChangeNotifyProc notify[MagScreenOptionNum];
} MagOptionsScreen;

CompAction * magGetInitiate (CompDisplay *d)
{
    MAG_OPTIONS_DISPLAY(d);
    return &od->opt[MagDisplayOptionInitiate].value.action;
}

void magSetInitiateInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    MAG_OPTIONS_DISPLAY(d);
    od->opt[MagDisplayOptionInitiate].value.action.initiate = init;
}

void magSetInitiateTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    MAG_OPTIONS_DISPLAY(d);
    od->opt[MagDisplayOptionInitiate].value.action.terminate = term;
}

CompOption * magGetInitiateOption (CompDisplay *d)
{
    MAG_OPTIONS_DISPLAY(d);
    return &od->opt[MagDisplayOptionInitiate];
}

void magSetInitiateNotify (CompDisplay *d, magDisplayOptionChangeNotifyProc notify)
{
    MAG_OPTIONS_DISPLAY(d);
    od->notify[MagDisplayOptionInitiate] = notify;
}

CompAction * magGetZoomInButton (CompDisplay *d)
{
    MAG_OPTIONS_DISPLAY(d);
    return &od->opt[MagDisplayOptionZoomInButton].value.action;
}

void magSetZoomInButtonInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    MAG_OPTIONS_DISPLAY(d);
    od->opt[MagDisplayOptionZoomInButton].value.action.initiate = init;
}

void magSetZoomInButtonTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    MAG_OPTIONS_DISPLAY(d);
    od->opt[MagDisplayOptionZoomInButton].value.action.terminate = term;
}

CompOption * magGetZoomInButtonOption (CompDisplay *d)
{
    MAG_OPTIONS_DISPLAY(d);
    return &od->opt[MagDisplayOptionZoomInButton];
}

void magSetZoomInButtonNotify (CompDisplay *d, magDisplayOptionChangeNotifyProc notify)
{
    MAG_OPTIONS_DISPLAY(d);
    od->notify[MagDisplayOptionZoomInButton] = notify;
}

CompAction * magGetZoomOutButton (CompDisplay *d)
{
    MAG_OPTIONS_DISPLAY(d);
    return &od->opt[MagDisplayOptionZoomOutButton].value.action;
}

void magSetZoomOutButtonInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    MAG_OPTIONS_DISPLAY(d);
    od->opt[MagDisplayOptionZoomOutButton].value.action.initiate = init;
}

void magSetZoomOutButtonTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    MAG_OPTIONS_DISPLAY(d);
    od->opt[MagDisplayOptionZoomOutButton].value.action.terminate = term;
}

CompOption * magGetZoomOutButtonOption (CompDisplay *d)
{
    MAG_OPTIONS_DISPLAY(d);
    return &od->opt[MagDisplayOptionZoomOutButton];
}

void magSetZoomOutButtonNotify (CompDisplay *d, magDisplayOptionChangeNotifyProc notify)
{
    MAG_OPTIONS_DISPLAY(d);
    od->notify[MagDisplayOptionZoomOutButton] = notify;
}

int magGetMode (CompScreen *s)
{
    MAG_OPTIONS_SCREEN(s);
    return os->opt[MagScreenOptionMode].value.i;
}

CompOption * magGetModeOption (CompScreen *s)
{
    MAG_OPTIONS_SCREEN(s);
    return &os->opt[MagScreenOptionMode];
}

void magSetModeNotify (CompScreen *s, magScreenOptionChangeNotifyProc notify)
{
    MAG_OPTIONS_SCREEN(s);
    os->notify[MagScreenOptionMode] = notify;
}

float magGetZoomFactor (CompScreen *s)
{
    MAG_OPTIONS_SCREEN(s);
    return os->opt[MagScreenOptionZoomFactor].value.f;
}

CompOption * magGetZoomFactorOption (CompScreen *s)
{
    MAG_OPTIONS_SCREEN(s);
    return &os->opt[MagScreenOptionZoomFactor];
}

void magSetZoomFactorNotify (CompScreen *s, magScreenOptionChangeNotifyProc notify)
{
    MAG_OPTIONS_SCREEN(s);
    os->notify[MagScreenOptionZoomFactor] = notify;
}

float magGetSpeed (CompScreen *s)
{
    MAG_OPTIONS_SCREEN(s);
    return os->opt[MagScreenOptionSpeed].value.f;
}

CompOption * magGetSpeedOption (CompScreen *s)
{
    MAG_OPTIONS_SCREEN(s);
    return &os->opt[MagScreenOptionSpeed];
}

void magSetSpeedNotify (CompScreen *s, magScreenOptionChangeNotifyProc notify)
{
    MAG_OPTIONS_SCREEN(s);
    os->notify[MagScreenOptionSpeed] = notify;
}

float magGetTimestep (CompScreen *s)
{
    MAG_OPTIONS_SCREEN(s);
    return os->opt[MagScreenOptionTimestep].value.f;
}

CompOption * magGetTimestepOption (CompScreen *s)
{
    MAG_OPTIONS_SCREEN(s);
    return &os->opt[MagScreenOptionTimestep];
}

void magSetTimestepNotify (CompScreen *s, magScreenOptionChangeNotifyProc notify)
{
    MAG_OPTIONS_SCREEN(s);
    os->notify[MagScreenOptionTimestep] = notify;
}

Bool magGetKeepScreen (CompScreen *s)
{
    MAG_OPTIONS_SCREEN(s);
    return os->opt[MagScreenOptionKeepScreen].value.b;
}

CompOption * magGetKeepScreenOption (CompScreen *s)
{
    MAG_OPTIONS_SCREEN(s);
    return &os->opt[MagScreenOptionKeepScreen];
}

void magSetKeepScreenNotify (CompScreen *s, magScreenOptionChangeNotifyProc notify)
{
    MAG_OPTIONS_SCREEN(s);
    os->notify[MagScreenOptionKeepScreen] = notify;
}

int magGetBoxWidth (CompScreen *s)
{
    MAG_OPTIONS_SCREEN(s);
    return os->opt[MagScreenOptionBoxWidth].value.i;
}

CompOption * magGetBoxWidthOption (CompScreen *s)
{
    MAG_OPTIONS_SCREEN(s);
    return &os->opt[MagScreenOptionBoxWidth];
}

void magSetBoxWidthNotify (CompScreen *s, magScreenOptionChangeNotifyProc notify)
{
    MAG_OPTIONS_SCREEN(s);
    os->notify[MagScreenOptionBoxWidth] = notify;
}

int magGetBoxHeight (CompScreen *s)
{
    MAG_OPTIONS_SCREEN(s);
    return os->opt[MagScreenOptionBoxHeight].value.i;
}

CompOption * magGetBoxHeightOption (CompScreen *s)
{
    MAG_OPTIONS_SCREEN(s);
    return &os->opt[MagScreenOptionBoxHeight];
}

void magSetBoxHeightNotify (CompScreen *s, magScreenOptionChangeNotifyProc notify)
{
    MAG_OPTIONS_SCREEN(s);
    os->notify[MagScreenOptionBoxHeight] = notify;
}

int magGetBorder (CompScreen *s)
{
    MAG_OPTIONS_SCREEN(s);
    return os->opt[MagScreenOptionBorder].value.i;
}

CompOption * magGetBorderOption (CompScreen *s)
{
    MAG_OPTIONS_SCREEN(s);
    return &os->opt[MagScreenOptionBorder];
}

void magSetBorderNotify (CompScreen *s, magScreenOptionChangeNotifyProc notify)
{
    MAG_OPTIONS_SCREEN(s);
    os->notify[MagScreenOptionBorder] = notify;
}

unsigned short * magGetBoxColor (CompScreen *s)
{
    MAG_OPTIONS_SCREEN(s);
    return os->opt[MagScreenOptionBoxColor].value.c;
}

unsigned short magGetBoxColorRed (CompScreen *s)
{
    MAG_OPTIONS_SCREEN(s);
    return os->opt[MagScreenOptionBoxColor].value.c[0];
}

unsigned short magGetBoxColorGreen (CompScreen *s)
{
    MAG_OPTIONS_SCREEN(s);
    return os->opt[MagScreenOptionBoxColor].value.c[1];
}

unsigned short magGetBoxColorBlue (CompScreen *s)
{
    MAG_OPTIONS_SCREEN(s);
    return os->opt[MagScreenOptionBoxColor].value.c[2];
}

unsigned short magGetBoxColorAlpha (CompScreen *s)
{
    MAG_OPTIONS_SCREEN(s);
    return os->opt[MagScreenOptionBoxColor].value.c[3];
}

CompOption * magGetBoxColorOption (CompScreen *s)
{
    MAG_OPTIONS_SCREEN(s);
    return &os->opt[MagScreenOptionBoxColor];
}

void magSetBoxColorNotify (CompScreen *s, magScreenOptionChangeNotifyProc notify)
{
    MAG_OPTIONS_SCREEN(s);
    os->notify[MagScreenOptionBoxColor] = notify;
}

char * magGetOverlay (CompScreen *s)
{
    MAG_OPTIONS_SCREEN(s);
    return os->opt[MagScreenOptionOverlay].value.s;
}

CompOption * magGetOverlayOption (CompScreen *s)
{
    MAG_OPTIONS_SCREEN(s);
    return &os->opt[MagScreenOptionOverlay];
}

void magSetOverlayNotify (CompScreen *s, magScreenOptionChangeNotifyProc notify)
{
    MAG_OPTIONS_SCREEN(s);
    os->notify[MagScreenOptionOverlay] = notify;
}

char * magGetMask (CompScreen *s)
{
    MAG_OPTIONS_SCREEN(s);
    return os->opt[MagScreenOptionMask].value.s;
}

CompOption * magGetMaskOption (CompScreen *s)
{
    MAG_OPTIONS_SCREEN(s);
    return &os->opt[MagScreenOptionMask];
}

void magSetMaskNotify (CompScreen *s, magScreenOptionChangeNotifyProc notify)
{
    MAG_OPTIONS_SCREEN(s);
    os->notify[MagScreenOptionMask] = notify;
}

int magGetXOffset (CompScreen *s)
{
    MAG_OPTIONS_SCREEN(s);
    return os->opt[MagScreenOptionXOffset].value.i;
}

CompOption * magGetXOffsetOption (CompScreen *s)
{
    MAG_OPTIONS_SCREEN(s);
    return &os->opt[MagScreenOptionXOffset];
}

void magSetXOffsetNotify (CompScreen *s, magScreenOptionChangeNotifyProc notify)
{
    MAG_OPTIONS_SCREEN(s);
    os->notify[MagScreenOptionXOffset] = notify;
}

int magGetYOffset (CompScreen *s)
{
    MAG_OPTIONS_SCREEN(s);
    return os->opt[MagScreenOptionYOffset].value.i;
}

CompOption * magGetYOffsetOption (CompScreen *s)
{
    MAG_OPTIONS_SCREEN(s);
    return &os->opt[MagScreenOptionYOffset];
}

void magSetYOffsetNotify (CompScreen *s, magScreenOptionChangeNotifyProc notify)
{
    MAG_OPTIONS_SCREEN(s);
    os->notify[MagScreenOptionYOffset] = notify;
}

int magGetRadius (CompScreen *s)
{
    MAG_OPTIONS_SCREEN(s);
    return os->opt[MagScreenOptionRadius].value.i;
}

CompOption * magGetRadiusOption (CompScreen *s)
{
    MAG_OPTIONS_SCREEN(s);
    return &os->opt[MagScreenOptionRadius];
}

void magSetRadiusNotify (CompScreen *s, magScreenOptionChangeNotifyProc notify)
{
    MAG_OPTIONS_SCREEN(s);
    os->notify[MagScreenOptionRadius] = notify;
}

CompOption * magGetDisplayOption (CompDisplay *d, MagDisplayOptions num)
{
    MAG_OPTIONS_DISPLAY(d);
    return &od->opt[num];
}

CompOption * magGetScreenOption (CompScreen *s, MagScreenOptions num)
{
    MAG_OPTIONS_SCREEN(s);
    return &os->opt[num];
}

static const CompMetadataOptionInfo magOptionsDisplayOptionInfo[] = {
    { "initiate", "key", 0, 0, 0 },
    { "zoom_in_button", "button", 0, 0, 0 },
    { "zoom_out_button", "button", 0, 0, 0 },
};

static Bool magOptionsSetDisplayOption (CompPlugin *plugin, CompDisplay *d, const char *name, CompOptionValue *value)
{
    MAG_OPTIONS_DISPLAY(d);
    CompOption *o;
    int        index;

    o = compFindOption (od->opt, MagDisplayOptionNum, name, &index);

    if (!o)
        return FALSE;

    switch (index)
    {
     case MagDisplayOptionInitiate:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[MagDisplayOptionInitiate])
                (*od->notify[MagDisplayOptionInitiate]) (d, o, MagDisplayOptionInitiate);
            return TRUE;
        }
        break;
     case MagDisplayOptionZoomInButton:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[MagDisplayOptionZoomInButton])
                (*od->notify[MagDisplayOptionZoomInButton]) (d, o, MagDisplayOptionZoomInButton);
            return TRUE;
        }
        break;
     case MagDisplayOptionZoomOutButton:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[MagDisplayOptionZoomOutButton])
                (*od->notify[MagDisplayOptionZoomOutButton]) (d, o, MagDisplayOptionZoomOutButton);
            return TRUE;
        }
        break;
    default:
        break;
    }
    return FALSE;
}

static CompOption * magOptionsGetDisplayOptions (CompPlugin *plugin, CompDisplay *d, int *count)
{
    MAG_OPTIONS_DISPLAY(d);
    *count = MagDisplayOptionNum;
    return od->opt;
}

static const CompMetadataOptionInfo magOptionsScreenOptionInfo[] = {
    { "mode", "int", "<min>0</min><max>2</max>", 0, 0 },
    { "zoom_factor", "float", "<min>1.1</min><max>32.0</max>", 0, 0 },
    { "speed", "float", "<min>0.1</min><max>50</max>", 0, 0 },
    { "timestep", "float", "<min>0.1</min><max>50</max>", 0, 0 },
    { "keep_screen", "bool", 0, 0, 0 },
    { "box_width", "int", "<min>20</min><max>1000</max>", 0, 0 },
    { "box_height", "int", "<min>20</min><max>1000</max>", 0, 0 },
    { "border", "int", "<min>0</min><max>20</max>", 0, 0 },
    { "box_color", "color", 0, 0, 0 },
    { "overlay", "string", 0, 0, 0 },
    { "mask", "string", 0, 0, 0 },
    { "x_offset", "int", "<min>0</min><max>1000</max>", 0, 0 },
    { "y_offset", "int", "<min>0</min><max>1000</max>", 0, 0 },
    { "radius", "int", "<min>10</min><max>1000</max>", 0, 0 },
};

static Bool magOptionsSetScreenOption (CompPlugin *plugin, CompScreen *s, const char *name, CompOptionValue *value)
{
    MAG_OPTIONS_SCREEN(s);
    CompOption *o;
    int        index;

    o = compFindOption (os->opt, MagScreenOptionNum, name, &index);

    if (!o)
        return FALSE;

    switch (index)
    {
     case MagScreenOptionMode:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[MagScreenOptionMode])
                (*os->notify[MagScreenOptionMode]) (s, o, MagScreenOptionMode);
            return TRUE;
        }
        break;
     case MagScreenOptionZoomFactor:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[MagScreenOptionZoomFactor])
                (*os->notify[MagScreenOptionZoomFactor]) (s, o, MagScreenOptionZoomFactor);
            return TRUE;
        }
        break;
     case MagScreenOptionSpeed:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[MagScreenOptionSpeed])
                (*os->notify[MagScreenOptionSpeed]) (s, o, MagScreenOptionSpeed);
            return TRUE;
        }
        break;
     case MagScreenOptionTimestep:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[MagScreenOptionTimestep])
                (*os->notify[MagScreenOptionTimestep]) (s, o, MagScreenOptionTimestep);
            return TRUE;
        }
        break;
     case MagScreenOptionKeepScreen:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[MagScreenOptionKeepScreen])
                (*os->notify[MagScreenOptionKeepScreen]) (s, o, MagScreenOptionKeepScreen);
            return TRUE;
        }
        break;
     case MagScreenOptionBoxWidth:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[MagScreenOptionBoxWidth])
                (*os->notify[MagScreenOptionBoxWidth]) (s, o, MagScreenOptionBoxWidth);
            return TRUE;
        }
        break;
     case MagScreenOptionBoxHeight:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[MagScreenOptionBoxHeight])
                (*os->notify[MagScreenOptionBoxHeight]) (s, o, MagScreenOptionBoxHeight);
            return TRUE;
        }
        break;
     case MagScreenOptionBorder:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[MagScreenOptionBorder])
                (*os->notify[MagScreenOptionBorder]) (s, o, MagScreenOptionBorder);
            return TRUE;
        }
        break;
     case MagScreenOptionBoxColor:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[MagScreenOptionBoxColor])
                (*os->notify[MagScreenOptionBoxColor]) (s, o, MagScreenOptionBoxColor);
            return TRUE;
        }
        break;
     case MagScreenOptionOverlay:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[MagScreenOptionOverlay])
                (*os->notify[MagScreenOptionOverlay]) (s, o, MagScreenOptionOverlay);
            return TRUE;
        }
        break;
     case MagScreenOptionMask:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[MagScreenOptionMask])
                (*os->notify[MagScreenOptionMask]) (s, o, MagScreenOptionMask);
            return TRUE;
        }
        break;
     case MagScreenOptionXOffset:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[MagScreenOptionXOffset])
                (*os->notify[MagScreenOptionXOffset]) (s, o, MagScreenOptionXOffset);
            return TRUE;
        }
        break;
     case MagScreenOptionYOffset:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[MagScreenOptionYOffset])
                (*os->notify[MagScreenOptionYOffset]) (s, o, MagScreenOptionYOffset);
            return TRUE;
        }
        break;
     case MagScreenOptionRadius:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[MagScreenOptionRadius])
                (*os->notify[MagScreenOptionRadius]) (s, o, MagScreenOptionRadius);
            return TRUE;
        }
        break;
    default:
        break;
    }
    return FALSE;
}

static CompOption * magOptionsGetScreenOptions (CompPlugin *plugin, CompScreen *s, int *count)
{
    MAG_OPTIONS_SCREEN(s);
    *count = MagScreenOptionNum;
    return os->opt;
}

static Bool magOptionsInitScreen (CompPlugin *p, CompScreen *s)
{
    MagOptionsScreen *os;
    
    MAG_OPTIONS_DISPLAY (s->display);

    os = calloc (1, sizeof(MagOptionsScreen));
    if (!os)
        return FALSE;

    s->base.privates[od->screenPrivateIndex].ptr = os;

    if (!compInitScreenOptionsFromMetadata (s, &magOptionsMetadata, magOptionsScreenOptionInfo, os->opt, MagScreenOptionNum))
    {
        free (os);
        return FALSE;
    }

    return TRUE;
}

static void magOptionsFiniScreen (CompPlugin *p, CompScreen *s)
{
    MAG_OPTIONS_SCREEN (s);


    compFiniScreenOptions (s, os->opt, MagScreenOptionNum);

    free (os);
}

static Bool magOptionsInitDisplay (CompPlugin *p, CompDisplay *d)
{
    MagOptionsDisplay *od;
   
    
    od = calloc (1, sizeof(MagOptionsDisplay));
    if (!od)
        return FALSE;

    od->screenPrivateIndex = allocateScreenPrivateIndex(d);
    if (od->screenPrivateIndex < 0)
    {
        free(od);
        return FALSE;
    }

    d->base.privates[MagOptionsDisplayPrivateIndex].ptr = od;

    if (!compInitDisplayOptionsFromMetadata (d, &magOptionsMetadata, magOptionsDisplayOptionInfo, od->opt, MagDisplayOptionNum))
    {
        free (od);
        return FALSE;
    }

    return TRUE;
}

static void magOptionsFiniDisplay (CompPlugin *p, CompDisplay *d)
{
    MAG_OPTIONS_DISPLAY (d);

    freeScreenPrivateIndex(d, od->screenPrivateIndex);

    compFiniDisplayOptions (d, od->opt, MagDisplayOptionNum);

    free (od);
}

static Bool magOptionsInit (CompPlugin *p)
{
    MagOptionsDisplayPrivateIndex = allocateDisplayPrivateIndex();
    if (MagOptionsDisplayPrivateIndex < 0)
        return FALSE;

    if (!compInitPluginMetadataFromInfo (&magOptionsMetadata, "mag",magOptionsDisplayOptionInfo, MagDisplayOptionNum, magOptionsScreenOptionInfo, MagScreenOptionNum))
        return FALSE;

    compAddMetadataFromFile (&magOptionsMetadata, "mag");
    if (magPluginVTable && magPluginVTable->init)
        return magPluginVTable->init (p);
    return TRUE;
}

static void magOptionsFini (CompPlugin *p)
{
    if (magPluginVTable && magPluginVTable->fini)
        magPluginVTable->fini (p);

    if (MagOptionsDisplayPrivateIndex >= 0)
        freeDisplayPrivateIndex (MagOptionsDisplayPrivateIndex);

    compFiniMetadata (&magOptionsMetadata);
}

static CompBool magOptionsInitObject (CompPlugin *p, CompObject *o)
{
    static InitPluginObjectProc dispTab[] = {
        (InitPluginObjectProc) 0,
        (InitPluginObjectProc) magOptionsInitDisplay,
        (InitPluginObjectProc) magOptionsInitScreen
    };

    RETURN_DISPATCH (o, dispTab, ARRAY_SIZE (dispTab), TRUE, (p, o));
}

static void magOptionsFiniObject (CompPlugin *p, CompObject *o)
{
    static FiniPluginObjectProc dispTab[] = {
        (FiniPluginObjectProc) 0,
        (FiniPluginObjectProc) magOptionsFiniDisplay,
        (FiniPluginObjectProc) magOptionsFiniScreen
    };

    DISPATCH (o, dispTab, ARRAY_SIZE (dispTab), (p, o));
}

static CompBool magOptionsInitObjectWrapper (CompPlugin *p, CompObject *o)
{
    CompBool rv = TRUE;
    rv = magOptionsInitObject (p, o);
    if (magPluginVTable->initObject)
        rv &= magPluginVTable->initObject (p, o);
    return rv;
}

static void magOptionsFiniObjectWrapper (CompPlugin *p, CompObject *o)
{
    if (magPluginVTable->finiObject)
        magPluginVTable->finiObject (p, o);
    magOptionsFiniObject (p, o);
}

static CompOption * magOptionsGetObjectOptions (CompPlugin *p, CompObject *o, int *count)
{
    static GetPluginObjectOptionsProc dispTab[] = {
        (GetPluginObjectOptionsProc) 0,
            (GetPluginObjectOptionsProc) magOptionsGetDisplayOptions,
        (GetPluginObjectOptionsProc) magOptionsGetScreenOptions
    };

    *count = 0;
    RETURN_DISPATCH (o, dispTab, ARRAY_SIZE (dispTab),
		     NULL, (p, o, count));
}

static CompBool magOptionsSetObjectOption (CompPlugin *p, CompObject *o, const char *name, CompOptionValue *value)
{
    static SetPluginObjectOptionProc dispTab[] = {
        (SetPluginObjectOptionProc) 0,
        (SetPluginObjectOptionProc) magOptionsSetDisplayOption,
        (SetPluginObjectOptionProc) magOptionsSetScreenOption
    };

    RETURN_DISPATCH (o, dispTab, ARRAY_SIZE (dispTab), FALSE,
		     (p, o, name, value));
}

static CompMetadata *
magOptionsGetMetadata (CompPlugin *plugin)
{
    return &magOptionsMetadata;
}

CompPluginVTable *getCompPluginInfo20070830 (void)
{
    if (!magPluginVTable)
    {
        magPluginVTable = getCompPluginInfo ();
        memcpy(&magOptionsVTable, magPluginVTable, sizeof(CompPluginVTable));
        magOptionsVTable.getMetadata = magOptionsGetMetadata;
        magOptionsVTable.init = magOptionsInit;
        magOptionsVTable.fini = magOptionsFini;
        magOptionsVTable.initObject = magOptionsInitObjectWrapper;
        magOptionsVTable.finiObject = magOptionsFiniObjectWrapper;
        magOptionsVTable.getObjectOptions = magOptionsGetObjectOptions;
	magOptionsVTable.setObjectOption = magOptionsSetObjectOption;
	
    }
    return &magOptionsVTable;
}

