/*
 * This file is autogenerated with bcop:
 * The Compiz option code generator
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <compiz-core.h>

#include "resizeinfo_options.h"

static int ResizeinfoOptionsDisplayPrivateIndex;

static CompMetadata resizeinfoOptionsMetadata;

static CompPluginVTable *resizeinfoPluginVTable = NULL;
CompPluginVTable resizeinfoOptionsVTable;

#define RESIZEINFO_OPTIONS_DISPLAY(d) PLUGIN_DISPLAY(d, ResizeinfoOptions, o)
#define RESIZEINFO_OPTIONS_SCREEN(s) PLUGIN_SCREEN(s, ResizeinfoOptions, o)

typedef struct _ResizeinfoOptionsDisplay
{
    int screenPrivateIndex;

    CompOption opt[ResizeinfoDisplayOptionNum];
    resizeinfoDisplayOptionChangeNotifyProc notify[ResizeinfoDisplayOptionNum];
} ResizeinfoOptionsDisplay;

typedef struct _ResizeinfoOptionsScreen
{
} ResizeinfoOptionsScreen;

int resizeinfoGetFadeTime (CompDisplay *d)
{
    RESIZEINFO_OPTIONS_DISPLAY(d);
    return od->opt[ResizeinfoDisplayOptionFadeTime].value.i;
}

CompOption * resizeinfoGetFadeTimeOption (CompDisplay *d)
{
    RESIZEINFO_OPTIONS_DISPLAY(d);
    return &od->opt[ResizeinfoDisplayOptionFadeTime];
}

void resizeinfoSetFadeTimeNotify (CompDisplay *d, resizeinfoDisplayOptionChangeNotifyProc notify)
{
    RESIZEINFO_OPTIONS_DISPLAY(d);
    od->notify[ResizeinfoDisplayOptionFadeTime] = notify;
}

Bool resizeinfoGetAlwaysShow (CompDisplay *d)
{
    RESIZEINFO_OPTIONS_DISPLAY(d);
    return od->opt[ResizeinfoDisplayOptionAlwaysShow].value.b;
}

CompOption * resizeinfoGetAlwaysShowOption (CompDisplay *d)
{
    RESIZEINFO_OPTIONS_DISPLAY(d);
    return &od->opt[ResizeinfoDisplayOptionAlwaysShow];
}

void resizeinfoSetAlwaysShowNotify (CompDisplay *d, resizeinfoDisplayOptionChangeNotifyProc notify)
{
    RESIZEINFO_OPTIONS_DISPLAY(d);
    od->notify[ResizeinfoDisplayOptionAlwaysShow] = notify;
}

unsigned short * resizeinfoGetTextColor (CompDisplay *d)
{
    RESIZEINFO_OPTIONS_DISPLAY(d);
    return od->opt[ResizeinfoDisplayOptionTextColor].value.c;
}

unsigned short resizeinfoGetTextColorRed (CompDisplay *d)
{
    RESIZEINFO_OPTIONS_DISPLAY(d);
    return od->opt[ResizeinfoDisplayOptionTextColor].value.c[0];
}

unsigned short resizeinfoGetTextColorGreen (CompDisplay *d)
{
    RESIZEINFO_OPTIONS_DISPLAY(d);
    return od->opt[ResizeinfoDisplayOptionTextColor].value.c[1];
}

unsigned short resizeinfoGetTextColorBlue (CompDisplay *d)
{
    RESIZEINFO_OPTIONS_DISPLAY(d);
    return od->opt[ResizeinfoDisplayOptionTextColor].value.c[2];
}

unsigned short resizeinfoGetTextColorAlpha (CompDisplay *d)
{
    RESIZEINFO_OPTIONS_DISPLAY(d);
    return od->opt[ResizeinfoDisplayOptionTextColor].value.c[3];
}

CompOption * resizeinfoGetTextColorOption (CompDisplay *d)
{
    RESIZEINFO_OPTIONS_DISPLAY(d);
    return &od->opt[ResizeinfoDisplayOptionTextColor];
}

void resizeinfoSetTextColorNotify (CompDisplay *d, resizeinfoDisplayOptionChangeNotifyProc notify)
{
    RESIZEINFO_OPTIONS_DISPLAY(d);
    od->notify[ResizeinfoDisplayOptionTextColor] = notify;
}

unsigned short * resizeinfoGetGradient1 (CompDisplay *d)
{
    RESIZEINFO_OPTIONS_DISPLAY(d);
    return od->opt[ResizeinfoDisplayOptionGradient1].value.c;
}

unsigned short resizeinfoGetGradient1Red (CompDisplay *d)
{
    RESIZEINFO_OPTIONS_DISPLAY(d);
    return od->opt[ResizeinfoDisplayOptionGradient1].value.c[0];
}

unsigned short resizeinfoGetGradient1Green (CompDisplay *d)
{
    RESIZEINFO_OPTIONS_DISPLAY(d);
    return od->opt[ResizeinfoDisplayOptionGradient1].value.c[1];
}

unsigned short resizeinfoGetGradient1Blue (CompDisplay *d)
{
    RESIZEINFO_OPTIONS_DISPLAY(d);
    return od->opt[ResizeinfoDisplayOptionGradient1].value.c[2];
}

unsigned short resizeinfoGetGradient1Alpha (CompDisplay *d)
{
    RESIZEINFO_OPTIONS_DISPLAY(d);
    return od->opt[ResizeinfoDisplayOptionGradient1].value.c[3];
}

CompOption * resizeinfoGetGradient1Option (CompDisplay *d)
{
    RESIZEINFO_OPTIONS_DISPLAY(d);
    return &od->opt[ResizeinfoDisplayOptionGradient1];
}

void resizeinfoSetGradient1Notify (CompDisplay *d, resizeinfoDisplayOptionChangeNotifyProc notify)
{
    RESIZEINFO_OPTIONS_DISPLAY(d);
    od->notify[ResizeinfoDisplayOptionGradient1] = notify;
}

unsigned short * resizeinfoGetGradient2 (CompDisplay *d)
{
    RESIZEINFO_OPTIONS_DISPLAY(d);
    return od->opt[ResizeinfoDisplayOptionGradient2].value.c;
}

unsigned short resizeinfoGetGradient2Red (CompDisplay *d)
{
    RESIZEINFO_OPTIONS_DISPLAY(d);
    return od->opt[ResizeinfoDisplayOptionGradient2].value.c[0];
}

unsigned short resizeinfoGetGradient2Green (CompDisplay *d)
{
    RESIZEINFO_OPTIONS_DISPLAY(d);
    return od->opt[ResizeinfoDisplayOptionGradient2].value.c[1];
}

unsigned short resizeinfoGetGradient2Blue (CompDisplay *d)
{
    RESIZEINFO_OPTIONS_DISPLAY(d);
    return od->opt[ResizeinfoDisplayOptionGradient2].value.c[2];
}

unsigned short resizeinfoGetGradient2Alpha (CompDisplay *d)
{
    RESIZEINFO_OPTIONS_DISPLAY(d);
    return od->opt[ResizeinfoDisplayOptionGradient2].value.c[3];
}

CompOption * resizeinfoGetGradient2Option (CompDisplay *d)
{
    RESIZEINFO_OPTIONS_DISPLAY(d);
    return &od->opt[ResizeinfoDisplayOptionGradient2];
}

void resizeinfoSetGradient2Notify (CompDisplay *d, resizeinfoDisplayOptionChangeNotifyProc notify)
{
    RESIZEINFO_OPTIONS_DISPLAY(d);
    od->notify[ResizeinfoDisplayOptionGradient2] = notify;
}

unsigned short * resizeinfoGetGradient3 (CompDisplay *d)
{
    RESIZEINFO_OPTIONS_DISPLAY(d);
    return od->opt[ResizeinfoDisplayOptionGradient3].value.c;
}

unsigned short resizeinfoGetGradient3Red (CompDisplay *d)
{
    RESIZEINFO_OPTIONS_DISPLAY(d);
    return od->opt[ResizeinfoDisplayOptionGradient3].value.c[0];
}

unsigned short resizeinfoGetGradient3Green (CompDisplay *d)
{
    RESIZEINFO_OPTIONS_DISPLAY(d);
    return od->opt[ResizeinfoDisplayOptionGradient3].value.c[1];
}

unsigned short resizeinfoGetGradient3Blue (CompDisplay *d)
{
    RESIZEINFO_OPTIONS_DISPLAY(d);
    return od->opt[ResizeinfoDisplayOptionGradient3].value.c[2];
}

unsigned short resizeinfoGetGradient3Alpha (CompDisplay *d)
{
    RESIZEINFO_OPTIONS_DISPLAY(d);
    return od->opt[ResizeinfoDisplayOptionGradient3].value.c[3];
}

CompOption * resizeinfoGetGradient3Option (CompDisplay *d)
{
    RESIZEINFO_OPTIONS_DISPLAY(d);
    return &od->opt[ResizeinfoDisplayOptionGradient3];
}

void resizeinfoSetGradient3Notify (CompDisplay *d, resizeinfoDisplayOptionChangeNotifyProc notify)
{
    RESIZEINFO_OPTIONS_DISPLAY(d);
    od->notify[ResizeinfoDisplayOptionGradient3] = notify;
}

CompOption * resizeinfoGetDisplayOption (CompDisplay *d, ResizeinfoDisplayOptions num)
{
    RESIZEINFO_OPTIONS_DISPLAY(d);
    return &od->opt[num];
}

static const CompMetadataOptionInfo resizeinfoOptionsDisplayOptionInfo[] = {
    { "fade_time", "int", "<min>10</min><max>5000</max>", 0, 0 },
    { "always_show", "bool", 0, 0, 0 },
    { "text_color", "color", 0, 0, 0 },
    { "gradient_1", "color", 0, 0, 0 },
    { "gradient_2", "color", 0, 0, 0 },
    { "gradient_3", "color", 0, 0, 0 },
};

static Bool resizeinfoOptionsSetDisplayOption (CompPlugin *plugin, CompDisplay *d, const char *name, CompOptionValue *value)
{
    RESIZEINFO_OPTIONS_DISPLAY(d);
    CompOption *o;
    int        index;

    o = compFindOption (od->opt, ResizeinfoDisplayOptionNum, name, &index);

    if (!o)
        return FALSE;

    switch (index)
    {
     case ResizeinfoDisplayOptionFadeTime:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[ResizeinfoDisplayOptionFadeTime])
                (*od->notify[ResizeinfoDisplayOptionFadeTime]) (d, o, ResizeinfoDisplayOptionFadeTime);
            return TRUE;
        }
        break;
     case ResizeinfoDisplayOptionAlwaysShow:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[ResizeinfoDisplayOptionAlwaysShow])
                (*od->notify[ResizeinfoDisplayOptionAlwaysShow]) (d, o, ResizeinfoDisplayOptionAlwaysShow);
            return TRUE;
        }
        break;
     case ResizeinfoDisplayOptionTextColor:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[ResizeinfoDisplayOptionTextColor])
                (*od->notify[ResizeinfoDisplayOptionTextColor]) (d, o, ResizeinfoDisplayOptionTextColor);
            return TRUE;
        }
        break;
     case ResizeinfoDisplayOptionGradient1:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[ResizeinfoDisplayOptionGradient1])
                (*od->notify[ResizeinfoDisplayOptionGradient1]) (d, o, ResizeinfoDisplayOptionGradient1);
            return TRUE;
        }
        break;
     case ResizeinfoDisplayOptionGradient2:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[ResizeinfoDisplayOptionGradient2])
                (*od->notify[ResizeinfoDisplayOptionGradient2]) (d, o, ResizeinfoDisplayOptionGradient2);
            return TRUE;
        }
        break;
     case ResizeinfoDisplayOptionGradient3:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[ResizeinfoDisplayOptionGradient3])
                (*od->notify[ResizeinfoDisplayOptionGradient3]) (d, o, ResizeinfoDisplayOptionGradient3);
            return TRUE;
        }
        break;
    default:
        break;
    }
    return FALSE;
}

static CompOption * resizeinfoOptionsGetDisplayOptions (CompPlugin *plugin, CompDisplay *d, int *count)
{
    RESIZEINFO_OPTIONS_DISPLAY(d);
    *count = ResizeinfoDisplayOptionNum;
    return od->opt;
}

static Bool resizeinfoOptionsInitScreen (CompPlugin *p, CompScreen *s)
{
    ResizeinfoOptionsScreen *os;
    
    RESIZEINFO_OPTIONS_DISPLAY (s->display);

    os = calloc (1, sizeof(ResizeinfoOptionsScreen));
    if (!os)
        return FALSE;

    s->base.privates[od->screenPrivateIndex].ptr = os;

    
    return TRUE;
}

static void resizeinfoOptionsFiniScreen (CompPlugin *p, CompScreen *s)
{
    RESIZEINFO_OPTIONS_SCREEN (s);

    free (os);
}

static Bool resizeinfoOptionsInitDisplay (CompPlugin *p, CompDisplay *d)
{
    ResizeinfoOptionsDisplay *od;
   
    
    od = calloc (1, sizeof(ResizeinfoOptionsDisplay));
    if (!od)
        return FALSE;

    od->screenPrivateIndex = allocateScreenPrivateIndex(d);
    if (od->screenPrivateIndex < 0)
    {
        free(od);
        return FALSE;
    }

    d->base.privates[ResizeinfoOptionsDisplayPrivateIndex].ptr = od;

    if (!compInitDisplayOptionsFromMetadata (d, &resizeinfoOptionsMetadata, resizeinfoOptionsDisplayOptionInfo, od->opt, ResizeinfoDisplayOptionNum))
    {
        free (od);
        return FALSE;
    }

    return TRUE;
}

static void resizeinfoOptionsFiniDisplay (CompPlugin *p, CompDisplay *d)
{
    RESIZEINFO_OPTIONS_DISPLAY (d);

    freeScreenPrivateIndex(d, od->screenPrivateIndex);

    compFiniDisplayOptions (d, od->opt, ResizeinfoDisplayOptionNum);

    free (od);
}

static Bool resizeinfoOptionsInit (CompPlugin *p)
{
    ResizeinfoOptionsDisplayPrivateIndex = allocateDisplayPrivateIndex();
    if (ResizeinfoOptionsDisplayPrivateIndex < 0)
        return FALSE;

    if (!compInitPluginMetadataFromInfo (&resizeinfoOptionsMetadata, "resizeinfo",resizeinfoOptionsDisplayOptionInfo, ResizeinfoDisplayOptionNum, 0, 0))
        return FALSE;

    compAddMetadataFromFile (&resizeinfoOptionsMetadata, "resizeinfo");
    if (resizeinfoPluginVTable && resizeinfoPluginVTable->init)
        return resizeinfoPluginVTable->init (p);
    return TRUE;
}

static void resizeinfoOptionsFini (CompPlugin *p)
{
    if (resizeinfoPluginVTable && resizeinfoPluginVTable->fini)
        resizeinfoPluginVTable->fini (p);

    if (ResizeinfoOptionsDisplayPrivateIndex >= 0)
        freeDisplayPrivateIndex (ResizeinfoOptionsDisplayPrivateIndex);

    compFiniMetadata (&resizeinfoOptionsMetadata);
}

static CompBool resizeinfoOptionsInitObject (CompPlugin *p, CompObject *o)
{
    static InitPluginObjectProc dispTab[] = {
        (InitPluginObjectProc) 0,
        (InitPluginObjectProc) resizeinfoOptionsInitDisplay,
        (InitPluginObjectProc) resizeinfoOptionsInitScreen
    };

    RETURN_DISPATCH (o, dispTab, ARRAY_SIZE (dispTab), TRUE, (p, o));
}

static void resizeinfoOptionsFiniObject (CompPlugin *p, CompObject *o)
{
    static FiniPluginObjectProc dispTab[] = {
        (FiniPluginObjectProc) 0,
        (FiniPluginObjectProc) resizeinfoOptionsFiniDisplay,
        (FiniPluginObjectProc) resizeinfoOptionsFiniScreen
    };

    DISPATCH (o, dispTab, ARRAY_SIZE (dispTab), (p, o));
}

static CompBool resizeinfoOptionsInitObjectWrapper (CompPlugin *p, CompObject *o)
{
    CompBool rv = TRUE;
    rv = resizeinfoOptionsInitObject (p, o);
    if (resizeinfoPluginVTable->initObject)
        rv &= resizeinfoPluginVTable->initObject (p, o);
    return rv;
}

static void resizeinfoOptionsFiniObjectWrapper (CompPlugin *p, CompObject *o)
{
    if (resizeinfoPluginVTable->finiObject)
        resizeinfoPluginVTable->finiObject (p, o);
    resizeinfoOptionsFiniObject (p, o);
}

static CompOption * resizeinfoOptionsGetObjectOptions (CompPlugin *p, CompObject *o, int *count)
{
    static GetPluginObjectOptionsProc dispTab[] = {
        (GetPluginObjectOptionsProc) 0,
            (GetPluginObjectOptionsProc) resizeinfoOptionsGetDisplayOptions,
    };

    *count = 0;
    RETURN_DISPATCH (o, dispTab, ARRAY_SIZE (dispTab),
		     NULL, (p, o, count));
}

static CompBool resizeinfoOptionsSetObjectOption (CompPlugin *p, CompObject *o, const char *name, CompOptionValue *value)
{
    static SetPluginObjectOptionProc dispTab[] = {
        (SetPluginObjectOptionProc) 0,
        (SetPluginObjectOptionProc) resizeinfoOptionsSetDisplayOption,
    };

    RETURN_DISPATCH (o, dispTab, ARRAY_SIZE (dispTab), FALSE,
		     (p, o, name, value));
}

static CompMetadata *
resizeinfoOptionsGetMetadata (CompPlugin *plugin)
{
    return &resizeinfoOptionsMetadata;
}

CompPluginVTable *getCompPluginInfo20070830 (void)
{
    if (!resizeinfoPluginVTable)
    {
        resizeinfoPluginVTable = getCompPluginInfo ();
        memcpy(&resizeinfoOptionsVTable, resizeinfoPluginVTable, sizeof(CompPluginVTable));
        resizeinfoOptionsVTable.getMetadata = resizeinfoOptionsGetMetadata;
        resizeinfoOptionsVTable.init = resizeinfoOptionsInit;
        resizeinfoOptionsVTable.fini = resizeinfoOptionsFini;
        resizeinfoOptionsVTable.initObject = resizeinfoOptionsInitObjectWrapper;
        resizeinfoOptionsVTable.finiObject = resizeinfoOptionsFiniObjectWrapper;
        resizeinfoOptionsVTable.getObjectOptions = resizeinfoOptionsGetObjectOptions;
	resizeinfoOptionsVTable.setObjectOption = resizeinfoOptionsSetObjectOption;
	
    }
    return &resizeinfoOptionsVTable;
}

