#!/usr/bin/python

import cobbler.api as capi
import os
import sys

bootapi = capi.BootAPI()
settings = bootapi.settings()
manage_dhcp = str(settings.manage_dhcp).lower()
manage_dns = str(settings.manage_dns).lower()
restart_dhcp = str(settings.restart_dhcp).lower()
restart_dns = str(settings.restart_dns).lower()
omapi_enabled = settings.omapi_enabled
omapi_port = settings.omapi_port

# load up our DHCP and DNS modules
bootapi.get_sync()
# bootapi.dhcp and bootapi.dns are now module references

# special handling as we don't want to restart it twice
has_restarted_dnsmasq = False

rc = 0
if manage_dhcp != "0":
    if bootapi.dhcp.what() == "isc":
        if not omapi_enabled and restart_dhcp:
            rc = os.system("/sbin/service dhcpd restart")
    elif bootapi.dhcp.what() == "dnsmasq":
        if restart_dhcp:
            rc = os.system("/sbin/service dnsmasq restart")
            has_restarted_dnsmasq = True
    else:
        print "- error: unknown DHCP engine: %s" % bootapi.dhcp.what()
        rc = 411

if manage_dns != "0" and restart_dns != "0":
    if bootapi.dns.what() == "bind":
        rc = os.system("/sbin/service named restart")
    elif bootapi.dns.what() == "dnsmasq" and not has_restarted_dnsmasq:
        rc = os.ssytem("/sbin/service dnsmasq restart")

sys.exit(rc)

