/*
 * Copyright (c) 2008-2009 Internet Initiative Japan Inc. All rights reserved.
 *
 * The terms and conditions of the accompanying program
 * shall be provided separately by Internet Initiative Japan Inc.
 * Any use, reproduction or distribution of the program are permitted
 * provided that you agree to be bound to such terms and conditions.
 *
 * $Id: dkimsignpolicy.h 686 2009-03-02 04:58:41Z takahiko $
 */

#ifndef __DKIM_SIGNPOLICY_H__
#define __DKIM_SIGNPOLICY_H__

#include "dkimenum.h"
#include "dkimpolicy.h"

struct DkimSignPolicy {
    DkimPolicy_MEMBER;
    long long signature_ttl;    // 現在時刻にこの値を足して sig-x-tag を生成する
    dkim_digestalg_t digestalg; // ダイジェストアルゴリズム
    dkim_pubkeyalg_t pubkeyalg; // 公開鍵アルゴリズム
    dkim_canonalg_t canon_method_header;    // ヘッダ部の canonicalization アルゴリズム
    dkim_canonalg_t canon_method_body;  // body 部の canonicalization アルゴリズム
};

#endif /* __DKIM_SIGNPOLICY_H__ */
