open Printf
open Newt

let () =
  let r =
    init_and_finish (
      fun () ->
	cls ();

	centered_window 20 20 "Listbox";

	let lb = listbox 0 0 7 [SCROLL;BORDER] in
	List.iter (
	  fun c ->
	    let str = sprintf "Item %c" c in
	    ignore (listbox_append_entry lb str c);
	) [ 'a'; 'b'; 'c'; 'd'; 'e'; 'f'; 'g'; 'h' ];

	let b1 = button 5 10 "  OK  " in

	let form = form None None [] in
	form_add_components form [component_of_listbox lb; b1];

	ignore (run_form form);
	pop_window ();

	(* What item, if any, was selected? *)
	match listbox_get_current lb with
	| Some c -> String.make 1 c
	| None -> "no item selected"
    ) in

  prerr_endline ("result: " ^ r);

  Gc.compact ()
