(* Demonstration program showing enabling and disabling fields. *)

open Printf
open Newt

let () =
  let r =
    init_and_finish (
      fun () ->
	cls ();

	centered_window 30 14 "Enable and disable";

	let disable = radio_button 1 1 "Disable" true None in
	let enable = radio_button 1 2 "Enable" false (Some disable) in

	let label1 = label 10 3 "E1:" in
	let entry1 = entry 15 3 None 10 [] in
	let label2 = label 10 4 "E2:" in
	let entry2 = entry 15 4 None 10 [] in
	let label3 = label 10 5 "E3:" in
	let entry3 = entry 15 5 None 10 [] in

	let enable_entries () =
	  component_takes_focus entry1 true;
	  component_takes_focus entry2 true;
	  component_takes_focus entry3 true
	in
	let disable_entries () =
	  component_takes_focus entry1 false;
	  component_takes_focus entry2 false;
	  component_takes_focus entry3 false
	in

	disable_entries ();
	component_add_callback disable disable_entries;
	component_add_callback enable enable_entries;

	let ok = button 8 8 "  OK  " in
	let form = form None None [] in
	form_add_components form [disable; enable;
				  label1; entry1;
				  label2; entry2;
				  label3; entry3;
				  ok];

	ignore (run_form form);
	pop_window ();

	"Unknown"
    ) in

  prerr_endline ("result: " ^ r);

  Gc.compact ()
