

#ifndef __SCROLLAREABORDER_H
#define __SCROLLAREABORDER_H

#include <QObject>
#include <QPalette>
#include <QtGui/QWidget>

class ScrollAreaBorder : public QWidget
{
  Q_OBJECT

  public:
    enum Orientation
    {
      Top,
      Bottom,
      Left,
      Right
    };

  private:
    Orientation o;
    QColor borderColor;
    QColor highlightColor;
    int alpha;
    int highlightAlpha;
    bool shadow;

  public:
    ScrollAreaBorder( Orientation orient,
                      const QColor &col,
                      const QColor &highlightCol,
                      const int contrast,
                      const bool drawShadow,
                      QWidget *parent = 0 );
    ~ScrollAreaBorder();

    Orientation orientation(){return o;}

  protected:
    void paintEvent(QPaintEvent *);


};

#endif // __SCROLLAREABORDER_H
