/****************************************************************************
    Qt-BSch3V schematic capture
    Copyright (C) 2002-2006 H.Okada

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*****************************************************************************/

#include "setlayerdlg.h"

setlayerdlg::setlayerdlg(QWidget *parent) : QDialog(parent)
{
	ui.setupUi(this);
	setVisibleLayer(0xff);
	setActiveLayer(0);
	setDarkenNonActive(true);
}

void setlayerdlg::setVisibleLayer(unsigned n)
{
	ui.checkView0->setChecked(n&0x01);
	ui.checkView1->setChecked(n&0x02);
	ui.checkView2->setChecked(n&0x04);
	ui.checkView3->setChecked(n&0x08);
	ui.checkView4->setChecked(n&0x10);
	ui.checkView5->setChecked(n&0x20);
	ui.checkView6->setChecked(n&0x40);
	ui.checkView7->setChecked(n&0x80);
}
void setlayerdlg::setActiveLayer(int n)
{
	n&=7;
	ui.radioActive0->setChecked(n==0);
	ui.radioActive1->setChecked(n==1);
	ui.radioActive2->setChecked(n==2);
	ui.radioActive3->setChecked(n==3);
	ui.radioActive4->setChecked(n==4);
	ui.radioActive5->setChecked(n==5);
	ui.radioActive6->setChecked(n==6);
	ui.radioActive7->setChecked(n==7);
}

void setlayerdlg::setDarkenNonActive(bool darken)
{
	ui.checkDarkenNonActive->setChecked(darken);
}

unsigned setlayerdlg::visibleLayer()
{
	unsigned n=0;
	if(ui.checkView0->isChecked()) n |= 0x01;
	if(ui.checkView1->isChecked()) n |= 0x02;
	if(ui.checkView2->isChecked()) n |= 0x04;
	if(ui.checkView3->isChecked()) n |= 0x08;
	if(ui.checkView4->isChecked()) n |= 0x10;
	if(ui.checkView5->isChecked()) n |= 0x20;
	if(ui.checkView6->isChecked()) n |= 0x40;
	if(ui.checkView7->isChecked()) n |= 0x80;
	return n;
	
}
int setlayerdlg::activeLayer()
{
	if(ui.radioActive0->isChecked()) return 0;
	if(ui.radioActive1->isChecked()) return 1;
	if(ui.radioActive2->isChecked()) return 2;
	if(ui.radioActive3->isChecked()) return 3;
	if(ui.radioActive4->isChecked()) return 4;
	if(ui.radioActive5->isChecked()) return 5;
	if(ui.radioActive6->isChecked()) return 6;
	return 7;	
}
bool setlayerdlg::darkenNonActive()
{
	return ui.checkDarkenNonActive->isChecked();
}
