/****************************************************************************
    Qt-LCoV Library Editor for Qt-BSch3V
    Copyright (C) 2002-2005 H.Okada

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*****************************************************************************/

#ifndef COMPONENTVIEW_H
#define COMPONENTVIEW_H

#include <qwidget.h>
#include <qapplication.h>

#include <q3scrollview.h>
#include <qcursor.h>
//Added by qt3to4:
#include <QMouseEvent>
#include <QResizeEvent>

#include <string>
#include <list>
#include <qpainter.h>
#include <qpixmap.h>
#include <qcolor.h>


using namespace std;


#include "coord.h"
#include "complib.h"
#include "compeditdoc.h"

#define COL_EDITPTN (QColor(128,255,255))
#define COL_XOR (QColor(255,0,0))
#define COL_PART (QColor(0,0,255))

class QCursor;


class SComponentView: public Q3ScrollView
{
    Q_OBJECT
	
	enum{
		PAGE_MARGIN = 50,
		MIN_ZOOMNUM = 0,
		MAX_ZOOMNUM = 3
	};

	enum{
		DRAGOP_NOT	= 0,
		DRAGOP_PTN  = 1,
		DRAGOP_PIN	= 2
	};

public:
	enum{
		TOOL_SELECT = 1,
		TOOL_PIN	= 2,
		TOOL_LINE	= 3,
		TOOL_CIRCLE	= 4,
		TOOL_POLYGON = 5,
		TOOL_ARC	= 6,
		TOOL_TEXT	= 7
	};


public:
	SComponentView(QWidget* parent);	//󥹥ȥ饯
	~SComponentView();	//ǥȥ饯
	
	QSize setContentsSize();	//ӥ塼ΥƥĤΥ
	
public:
	SCompEditDoc m_doc;
	SCompIndex* m_pCompIndex;

protected:	
	int m_zoomNum;
	int m_magMul;			//ɽΨʬ
	int m_magDiv;			//ɽΨʬ
	int m_block;

	QSize m_pageSize;	//ߤɽΨǤΥڡ
	QSize m_clientSize;	//饤ȥꥢΥ
	QPoint m_windowOrg; //κɸ
	int m_margin;

	int m_tool;			//ߤΥġ
	int m_placeState;		//Υơֹ
	SPoint m_arrayTempPoint[64];

	int m_dragOpStatus;		//֥ȤΥɥå

	bool m_startSelect;

	QPoint m_pointLButtonDown;	//ܥ󤬲줿ȤΥޥɸ
	QPoint m_pointCurrentPos;		//ߤΥޥɸ
	QPoint m_pointLButtonUp;		//ܥ󤬲줿ȤΥޥɸ
	QSize m_prevOffset;		//ɥåˤǤ˰ưꤷ
	int m_pinPosLtrbStart;		//ԥΥɥåϤΰ (LTRB)
	int m_pinPosOffsetStart;	//ԥΥɥåϤΰ (OFFSET)


	QPixmap m_viewBuffer;		//ե꡼Хåե

	QSize	m_offScrnBuffSize;	//ե꡼ХåեΥ
	QPoint 	m_offScrnBuffOrg;	//ե꡼Хåեκɸ

	SPin* m_pCursorPin;			//դ֥

	bool m_editNodeMode;		//ΡԽ⡼ɤΤȤ true

	int m_movingGrip;				//åװư°
	
	QCursor* m_pCurStd;
	QCursor* m_pCurMov;




// 
public:
	int tool(){return m_tool;}		// 򤵤Ƥġ֤
	void setTool(int tool);			// ġ򤹤
	
	bool onKeyEscape();			// ESCAPEϥɥ

	bool canDelete();				//  DELETE Ǥ֤ʤ true ֤
	bool doDelete();				// DELETEμº
	
	bool canCreateBitPtn();		// ӥåȥѥǽʤȤ true
	bool doCreateBitPtn();			// ӥåȥѥμº

	bool canCopy();				// COPYǤ֤ʤ true ֤
	bool doCopy();				// COPYμº

	bool canUndo();				// UNDOǤ֤ʤ true ֤
	bool doUndo();				// UNDOμº

	bool canMirrorRotate();		// ߥ顼ޤϲžǽʤȤ true ֤
	bool doMirror();				// ߥ顼μº
	bool doRotate();				// žμº

	void  setEditNodeMode(bool editnode); //ΡԽ⡼ؤ
	bool  editNodeMode(){return m_editNodeMode;} //ΡԽ⡼ɤɤ֤




	bool canPaste();				// PASTEǽʤȤ true ֤
	bool doPaste();				// PASTEμº
	bool doPastePin(SReadCE3& rce3);	// doPaste()ƤФԥΥڡȽ
	bool doPastePtn(SReadCE3& rce3);	// doPaste()ƤФѥΥڡȽ



	bool canProperty();			// PROPERTYޥɤ¹ԲǽʤȤ true ֤
	bool editProperty();			// PROPERTYޥɤμº
	bool editPinProperty(SPin* pPin); 		// editProperty()ƤФԥPROPERTYޥ
	bool editPtnProperty(SPtnObj* pPtn);	// editProperty()ƤФѥPROPERTYޥ
	
	
	bool save();	//m_docŸʾ m_pCompIndex᤹;

	bool releaseTemp();	//tempǡݻǡ򡢰Ÿǡ᤹

	void setDirty(){m_doc.m_tempDirtyFlag = true;}	//DIRTYե饰ONˤ롣

	void RefreshView();
	
//// С饤
//	protected:
//	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);


protected:
	void drawToBuff(bool force);	//Хåեؤν񤭹


	void drawPin(QPainter* p,SPin* pPin,int block,unsigned dwMode);
	void drawPins(QPainter* p,SCompEditElmList& list,unsigned dwMode);
	void drawPtns(QPainter* p,SCompEditElmList& list,unsigned dwMode);
	void drawPtn(QPainter* p,SPtnObj* pPtn,int cx,int cy,const QColor& color ,int magDiv,int magMul);
	void drawCompFrame(QPainter* p);
	void drawGrid(QPainter* p);
	void drawGrip(QPainter* p);
	void drawTempDataFrame(QPainter*p, const QRect& rc);

	int doSelect(SPoint sptEdit,QPoint lpt);

	void setZoomValue(int n);
	//ɸѴ ɸԽɸѴ
	void LPtoCompEditP(QPoint& point);
	void LPtoCompEditP(QRect& rc);
	void CompEditPtoLP(QPoint& point);
	void CompEditPtoLP(QRect& rc);

	//ԥ֡¸ԥ󤬤ʤm_pCursorPinTempData֤롣
	bool placePin();

	void drawPlaceLine(QPainter* p);
	void drawPlaceCircle(QPainter* p);
	void drawPlaceArc(QPainter* p);

	bool editNodeActive();

	int isOnGrip(const QPoint& logicalPoint);


	// 줿åƴؿ
protected:
public:
	void setCompIndex(SCompIndex* pCompIndex);
	void saveCompInfo();
	QSize setPageSize();
	void OnViewZoomin();
	void OnViewZoomout();
//	afx_msg void OnUpdateViewZoomin(CCmdUI *pCmdUI);
//	afx_msg void OnUpdateViewZoomout(CCmdUI *pCmdUI);
//	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
//	afx_msg void OnLButtonDblClk(UINT nFlags, CPoint point);
//	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
//	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);

	
protected:
	void contentsMousePressEvent(QMouseEvent*);
	void contentsMouseReleaseEvent(QMouseEvent *);
	void contentsMouseMoveEvent(QMouseEvent *me);
	void contentsMouseDoubleClickEvent ( QMouseEvent * );
	void viewportResizeEvent(QResizeEvent * );
	void resizeBuffer(int w,int h);
	//void resizeEvent ( QResizeEvent * );
	//void viewportPaintEvent (QPaintEvent *);

//	void contentsWheelEvent ( QWheelEvent *e );
	
	void setWindowOrg();

	//
	void drawContents(QPainter*p,int clipx,int clipy, int clipw, int cliph );
	//drawContentsˤȤʤХåեκ
	//Ϥ̵ꥢκɸϥƥĺɸ
//	void updateViewBuffer(int clipx,int clipy, int clipw, int cliph );
//	void updateViewBuffer(bool bForceUpdate = false);//int clipx,int clipy, int clipw, int cliph );
	//Хåեκ
	//Ϥ̵ꥢκɸϥƥĺɸ
//	void drawBuffer(int x,int y,int clipx,int clipy, int clipw, int cliph );


};

#endif
