/****************************************************************************
    Qt-BSch3V schematic capture
    Copyright (C) 2002-2005 H.Okada

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*****************************************************************************/

#ifndef _SMALLFONT_H
#define _SMALLFONT_H

#include "coord.h"
///////////////////////////////////////////////////////////////////
// XBSchΥ⡼եȥ饹
// ãŤΥեȤƱΤΤȤ
// Υ饹XBSchεư˥ХѿǣĤơλ˴롣
// ̾ﱿѤˤDrawText᥽åɤȤʤᡢХؿȤƺ뤳Ȥͤ
// եѤ˽ɬפʤᡢBSchƱͤ˥饹Ȥ롣
// ̾ʸϡQtǤXORȤ褦ʤΤ(?)Υ饹ϳ
//   BSchǤϡXOR¸뤿ˡ̾ʸ⤳Υ饹̤



class SSmallFont
{
private:
	const char*		m_pString;		//ʸؤΥݥ
	int				m_nStrLen;		//ʸĹ
	unsigned char* 	m_pBmpBit;		//ŸѥХåեؤΥݥ󥿡󥹥ȥ饯4096Хȳ
	QFont			m_font;
	int				m_fontSize;
	
	int 				m_scale;
	int				m_scaleMul;
	int				m_upperPos;
	int				m_vOffset;
	bool				m_updateFont;
	
	
private:
	

public:
	SSmallFont();		//󥹥ȥ饯
	~SSmallFont();		//ǥȥ饯
	void SetFont(const QFont& font); //˻ȤեȤꤹ롣

	SSize  DrawText(		//ɥåȥեȤ
		QPainter* pPainter,		//
		int x,
		int y,					//ϰ
		const char* str,		//ʸ
		const QColor& color,	//Ͽ
		unsigned  nMode,//=DRAW_ON,//⡼
		bool bVert,//=false,		//ľե饰
		int nPointPos,	//ꤷϰ֤ 0:ʸ 1:ʸθ 2:ʸ
										//					 0:ʸβ 4:ʸξ   8:ʸ
		
		int  nDiv,//=1,
		int  nMul,//=1 			//nMul/nDiv˳̾ɽ
		bool bUseUpperLine=true
				  );		
};

//////////////////////////////////////////////////////////////////////
//եȴϢ Хѿؿ
extern SSmallFont g_SmallFont;

SSize DrawString(
		QPainter* p,					//
		int x,int y,					//ϰ
		const char* pstr,				//ʸ
		const QColor& color,			//Ͽ
		QFont& rFont,
		int fontSize,
		unsigned nMode,					//⡼
		bool bVert,						//ľե饰
		int  nPointPos,					//ꤷϰ֤ 0:ʸ 1:ʸθ 2:ʸ
										//					 0:ʸβ 4:ʸξ   8:ʸ
		int  nDiv,						
		int  nMul);

#endif
