/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@miraks.com    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
#ifndef SKGINTERFACEPLUGIN_H
#define SKGINTERFACEPLUGIN_H
/** @file
* This file is Skrooge plugin interface definition.
*
* @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include <QStringList>
#include <kparts/plugin.h>

#include "skgdocument.h"
#include "skgtabwidget.h"
#include "skgerror.h"

class SKGMainPanel;
class KConfigSkeleton;
class QDockWidget;

/**
 * This file is Skrooge plugin interface definition.
 */
class KDE_EXPORT SKGInterfacePlugin : public KParts::Plugin
{
        Q_OBJECT ;
public:

        /**
         * Default constructor
         * @param parent the parent of the plugin
         */
        SKGInterfacePlugin(QObject * parent = 0);

        /**
         * Default destructor
         */
        virtual ~SKGInterfacePlugin();

        /**
         * Called to initialise the plugin
         * @param iParent the SKGMainPanel main panel parent
         * @param iDocument the SKGDocumentBank main document
         * @param iArgument the arguments
         */
        virtual void setupActions(SKGMainPanel* iParent, SKGDocument* iDocument, const QStringList& iArgument) =0;

        /**
         * Must be modified to close properly the plugin.
         */
        virtual void close();

        /**
         * Must be modified to refresh widgets after a modification.
         */
        virtual void refresh();

        /**
         * The context widget of the plugin.
         * @return The context widget of the plugin
         */
        virtual SKGTabWidget* getWidget();

        /**
         * The dock widget of the plugin.
         * @return The dock widget of the plugin
         */
        virtual QDockWidget* getDockWidget();

        /**
         * The preference widget of the plugin.
         * @return The preference widget of the plugin
         */
        virtual QWidget* getPreferenceWidget();

        /**
         * The preference skeleton of the plugin.
         * @return The preference skeleton of the plugin
         */
        virtual KConfigSkeleton* getPreferenceSkeleton();

        /**
         * This function is called when preferences have been modified. Must be used to save some parameters into the document.
         * A transaction is already opened
         * @return an object managing the error.
         *   @see SKGError
         */
        virtual SKGError savePreferences() const;

        /**
         * The title of the plugin.
         * @return The title of the plugin
         */
        virtual QString title() const =0;

        /**
         * The icon of the plugin.
         * @return The icon of the plugin
         */
        virtual QString icon() const =0;

        /**
         * The statusTip of the plugin.
         * @return The toolTip of the plugin
         */
        virtual QString statusTip () const =0;

        /**
         * The toolTip of the plugin.
         * @return The toolTip of the plugin
         */
        virtual QString toolTip () const =0;

        /**
         * The tips list of the plugin.
         * @return The tips list of the plugin
         */
        virtual QStringList tips() const;

        /**
         * Must be implemented to set the position of the plugin.
         * @return integer value between 0 and 999 (default = 999)
         */
        virtual int getOrder() const;

        /**
         * Must be implemented to know if a plugin must be display in context chooser.
         * @return true of false (default = false)
         */
        virtual bool isInContext() const;

        /**
         * Must be implemented to know if a plugin is closable or not.
         * @return true of false (default = false)
         */
        virtual bool isTabClosable() const;

        /**
         * Must be implemented to know if this plugin is enabled
         * @return true of false (default = true)
         */
        virtual bool isEnabled() const;

private:
        Q_DISABLE_COPY(SKGInterfacePlugin);

};

Q_DECLARE_INTERFACE(SKGInterfacePlugin, "skrooge.com.SKGInterfacePlugin/1.0");


#endif // SKGINTERFACEPLUGIN_H
