/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@miraks.com    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
#ifndef SKGOPERATIONPLUGINWIDGET_H
#define SKGOPERATIONPLUGINWIDGET_H
/** @file
* This file is Skrooge plugin for bank management.
*
* @author Stephane MANKOWSKI / Guillaume DE BURE
*/
#include "ui_skgoperationpluginwidget_base.h"
#include "skgtabwidget.h"
#include "skgoperationobject.h"
#include "skgsuboperationobject.h"

#include <QDomDocument>

class SKGDocumentBank;
class SKGObjectModel;
class KAction;

/**
 * This file is Skrooge plugin for operation management
 */
class SKGOperationPluginWidget : public SKGTabWidget
{
        Q_OBJECT

public:
        /**
         * Default Constructor
         */
        SKGOperationPluginWidget(SKGMainPanel* iParent, SKGDocumentBank* iDocument, KAction* iFastEditionAction);

        /**
         * Default Destructor
         */
        virtual ~SKGOperationPluginWidget();

        /**
         * Get the current selection
         * @return selected objects
         */
        virtual SKGObjectBase::SKGListSKGObjectBase getSelectedObjects();

        /**
         * Get the number of seleted object
         * @return number of selected objects
         */
        virtual int getNbSelectedObjects();

        /**
         * Get the current state
         * MUST BE OVERWRITTEN
         * @return a string containing all information needed to set the same state.
         * Could be an XML stream
         */
        virtual QString getState();

        /**
         * Set the current state
         * MUST BE OVERWRITTEN
         * @param iState must be interpreted to set the state of the widget
         */
        virtual void setState(const QString& iState);

        /**
         * Get the widget must be printed
         * @return a widget
         */
        virtual QWidget* getWidgetForPrint();

        /**
         * Open an operation in an operations page
         * @param iOperation the operation to open
         * @param iParent the parent widget
         */
        static void openOperation(const SKGOperationObject& iOperation, SKGMainPanel* iParent);

public slots:
        /**
        * Refresh the content.
         */
        virtual void refresh();

private slots:
        void onOperationCreatorModified();
        void onAddOperationClicked();
        void onUpdateOperationClicked();
        void onFilterChanged();
        void onFilterRegExpChanged();
        void onResetInternalFilter();
        void onSelectionChanged();
        void onFocusChanged();
        void onFastEdition();
        void onDoubleClick();
        void onSplitOperationClicked();
        void onQuantityChanged();
        void onSubopCellChanged(int row,int column);
        void onRemoveSubOperation();

private:
        Q_DISABLE_COPY(SKGOperationPluginWidget);

        SKGError confirmMissingObjectsCreation(bool &iConfirmation);
        SKGError getSelectedOperation(SKGOperationObject& operation);

        void displaySplitted();
        void displayStandard();
        void displaySubOperations();
        double getRemainingQuantity();
        void addSubOperationLine(int row, QString category, QString comment, double quantity, int id=0);
        SKGError updateSelection(const SKGObjectBase::SKGListSKGObjectBase& iSelection);


        Ui::skgoperationplugin_base ui;
        SKGObjectModel* objectModel;
        QString operationWhereClause;
        QDomDocument lastState;

        KAction* fastEditionAction;
        QString lastFastEditionWhereClause;
        int lastFastEditionOperationFound;
        bool showClosedAccounts;

        QWidget* splittedPage;
        QWidget* standardPage;
};

#endif // SKGOPERATIONPLUGINWIDGET_H
