/* ============================================================
 *
 * This file is a part of digiKam project
 * http://www.digikam.org
 *
 * Date        : 2007-04-16
 * Description : Schema update
 *
 * Copyright (C) 2007-2009 by Marcel Wiesweg <marcel dot wiesweg at gmx dot de>
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */

#ifndef SCHEMAUPDATER_H
#define SCHEMAUPDATER_H

// Qt includes

#include <QString>

// Local includes
#include "albumdb.h"
#include "databaseaccess.h"
#include "databasebackend.h"
#include "databaseparameters.h"

namespace Digikam
{

class DatabaseAccess;
class InitializationObserver;

class DIGIKAM_DATABASE_EXPORT SchemaUpdater
{
public:

    SchemaUpdater(AlbumDB *albumDB, DatabaseBackend *backend, DatabaseParameters parameters);

    static int schemaVersion();
    static int filterSettingsVersion();
    bool update();
    void setObserver(InitializationObserver *observer);
    const QString getLastErrorMessage();
    void setDatabaseAccess(DatabaseAccess *access);

private:

    bool startUpdates();
    bool makeUpdates();
    void defaultFilterSettings(QStringList& defaultImageFilter,
                               QStringList& defaultVideoFilter,
                               QStringList& defaultAudioFilter);
    bool createFilterSettings();
    bool updateFilterSettings();
    bool createDatabase();
    bool createTablesV5();
    bool createIndicesV5();
    bool createTriggersV5();
    bool copyV3toV4(const QString& digikam3DBPath, const QString& currentDBPath);
    bool updateV4toV5();
    bool updateV2toV4(const QString& sqlite2DBPath);
    bool createTablesV3();

private:

    void preAlpha010Update1();
    void preAlpha010Update2();
    void preAlpha010Update3();
    void beta010Update1();
    void beta010Update2();

private:

    bool                    m_setError;

    int                     m_currentVersion;

    DatabaseBackend*        m_Backend;
    AlbumDB*                m_AlbumDB;
    DatabaseParameters      m_Parameters;

    // legacy
    DatabaseAccess*         m_access;

    QString                 m_LastErrorMessage;
    InitializationObserver* m_observer;
};

}  // namespace Digikam

#endif // SCHEMAUPDATER_H
