/***************************************************************************
                            kde_StyleSheet.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_STYLESHEET
#define KDE_STYLESHEET

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 The <code> StyleSheet </code> interface is the abstract base
 interface for any type of style sheet. It represents a single style
 sheet associated with a structured document. In HTML, the
 StyleSheet interface represents either an external style sheet,
 included via the HTML <a
 href="http://www.w3.org/TR/REC-html40/struct/links.html#h-12.3">
 LINK </a> element, or an inline <a
 href="http://www.w3.org/TR/REC-html40/present/styles.html#h-14.2.3">
 STYLE </a> element. In XML, this interface represents an external
 style sheet, included via a <a
 href="http://www.w3.org/TR/xml-stylesheet"> style sheet processing
 instruction </a> .

 
 @short *
 The <code> StyleSheet </code> interface is the abstract base
 interface for any type of style sheet.
*/
#ifdef __cplusplus
extern   "C" {
#endif
kde_StyleSheet * kde_new_StyleSheet();
kde_StyleSheet * kde_new_StyleSheet1(kde_StyleSheet* other);
void kde_del_StyleSheet( kde_StyleSheet* p );

/** *
 This specifies the style sheet language for this style sheet.
 The style sheet language is specified as a content type (e.g.
 "text/css"). The content type is often specified in the <code>
 ownerNode </code> . A list of registered content types can be
 found at <a
 href="ftp://ftp.isi.edu/in-notes/iana/assignments/media-types/">
 Also see the <a
 href="http://www.w3.org/TR/REC-html40/struct/links.html#adef-type-A">
 type attribute definition </a> for the <code> LINK </code>
 element in HTML 4.0, and the type pseudo-attribute for the XML
 <a href="http://www.w3.org/TR/xml-stylesheet"> style sheet
 processing instruction </a> .

     
*/
kde_DOMString* kde_StyleSheet_type(kde_StyleSheet* instPointer);

/** *
 <code> false </code> if the style sheet is applied to the
 document. <code> true </code> if it is not. Modifying this
 attribute may cause a reresolution of style for the document.

     
*/
int kde_StyleSheet_disabled(kde_StyleSheet* instPointer);

/** *
 see @ref disabled
     
*/
void kde_StyleSheet_setDisabled(kde_StyleSheet* instPointer,int arg1);

/** *
 The node that associates this style sheet with the document.
 For HTML, this may be the corresponding <code> LINK </code> or
 <code> STYLE </code> element. For XML, it may be the linking
 processing instruction. For style sheets that are included by
 other style sheets, this attribute has a value of null.

     
*/

/** *
 For style sheet languages that support the concept of style
 sheet inclusion, this attribute represents the including style
 sheet, if one exists. If the style sheet is a top-level style
 sheet, or the style sheet language does not support inclusion,
 the value of the attribute is null.

     
*/
kde_StyleSheet* kde_StyleSheet_parentStyleSheet(kde_StyleSheet* instPointer);

/** *
 If the style sheet is a linked style sheet, the value of its
 attribute is its location. For inline style sheets, the value
 of this attribute is null. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/links.html#adef-href">
 href attribute definition </a> for the <code> LINK </code>
 element in HTML 4.0, and the href pseudo-attribute for the XML
 <a href="http://www.w3.org/TR/xml-stylesheet"> style sheet
 processing instruction </a> .

     
*/

/** *
 The advisory title. The title is often specified in the <code>
 ownerNode </code> . See the <a
 href="http://www.w3.org/TR/REC-html40/struct/global.html#adef-title">
 title attribute definition </a> for the <code> LINK </code>
 element in HTML 4.0, and the title pseudo-attribute for the XML
 <a href="http://www.w3.org/TR/xml-stylesheet"> style sheet
 processing instruction </a> .

     
*/

/** *
 The intended destination media for style information. The media
 is often specified in the <code> ownerNode </code> . See the <a
 href="http://www.w3.org/TR/REC-html40/present/styles.html#adef-media">
 media attribute definition </a> for the <code> LINK </code>
 element in HTML 4.0, and the media pseudo-attribute for the XML
 <a href="http://www.w3.org/TR/WD-xml-stylesheet"> style sheet
 processing instruction </a> .

     
*/
kde_MediaList kde_StyleSheet_media(kde_StyleSheet* instPointer);

/** *

     
*/
int kde_StyleSheet_isCSSStyleSheet(kde_StyleSheet* instPointer);
int kde_StyleSheet_isNull(kde_StyleSheet* instPointer);

#ifdef __cplusplus
}
#endif
#endif
