/***************************************************************************
                            CSSPrimitiveValue.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef CSSPRIMITIVEVALUE_H
#define CSSPRIMITIVEVALUE_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <kdeobjc/CSSValue.h>

/**

 The <code> CSSPrimitiveValue </code> interface represents a single
 <a href="http://www.w3.org/TR/REC-CSS2/syndata.-[html values]"> CSS
 value </a> . This interface may be used to determine the value of a
 specific style property currently set in a block or to set a
 specific style properties explicitly within the block. An instance
 of this interface can be obtained from the <code>
 getPropertyCSSValue </code> method of the <code>
 CSSStyleDeclaration </code> interface.

 
 @short 
 The <code> CSSPrimitiveValue </code> interface represents a single
 <a href="http://www.
*/

@class Counter;
@class RGBColor;
@class Rect;

@interface CSSPrimitiveValue : CSSValue
- init;
- copyWithZone: (NSZone *) zone;
- initWithCSSValue: (CSSValue*)other;
- (void) dealloc;

/** 
 The type of the value as defined by the constants specified
 above.

     
*/
- (unsigned short) primitiveType;

/** 
 A method to set the float value with a specified unit. If the
 property attached with this value can not accept the specified
 unit or the float value, the value will be unchanged and a
 <code> DOMException </code> will be raised.

  NO_MODIFICATION_ALLOWED_ERR: Raised if this property is
 readonly.

     
*/
- setFloatValue: (unsigned short)unitType floatValue: (float)floatValue;

/** 
 This method is used to get a float value in a specified unit.
 If this CSS value doesn't contain a float value or can't be
 converted into the specified unit, a <code> DOMException
 </code> is raised.

     
*/
- (float) getFloatValue: (unsigned short)unitType;

/** 
 A method to set the string value with a specified unit. If the
 property attached to this value can't accept the specified unit
 or the string value, the value will be unchanged and a <code>
 DOMException </code> will be raised.

  NO_MODIFICATION_ALLOWED_ERR: Raised if this property is
 readonly.

     
*/
- setStringValue: (unsigned short)stringType stringValue: (NSString *)stringValue;

/** 
 This method is used to get the string value in a specified
 unit. If the CSS value doesn't contain a string value, a <code>
 DOMException </code> is raised.

     
*/
- (NSString *) getStringValue;

/** 
 This method is used to get the Counter value. If this CSS value
 doesn't contain a counter value, a <code> DOMException </code>
 is raised. Modification to the corresponding style property can
 be achieved using the <code> Counter </code> interface.

     
*/
- (Counter*) getCounterValue;

/** 
 This method is used to get the Rect value. If this CSS value
 doesn't contain a rect value, a <code> DOMException </code> is
 raised. Modification to the corresponding style property can be
 achieved using the <code> Rect </code> interface.

     
*/
- (Rect*) getRectValue;

/** 
 This method is used to get the RGB color. If this CSS value
 doesn't contain a RGB color value, a <code> DOMException
 </code> is raised. Modification to the corresponding style
 property can be achieved using the <code> RGBColor </code>
 interface.

     
*/
- (RGBColor*) getRGBColorValue;
+ (int) CSS_UNKNOWN;
+ (int) CSS_NUMBER;
+ (int) CSS_PERCENTAGE;
+ (int) CSS_EMS;
+ (int) CSS_EXS;
+ (int) CSS_PX;
+ (int) CSS_CM;
+ (int) CSS_MM;
+ (int) CSS_IN;
+ (int) CSS_PT;
+ (int) CSS_PC;
+ (int) CSS_DEG;
+ (int) CSS_RAD;
+ (int) CSS_GRAD;
+ (int) CSS_MS;
+ (int) CSS_S;
+ (int) CSS_HZ;
+ (int) CSS_KHZ;
+ (int) CSS_DIMENSION;
+ (int) CSS_STRING;
+ (int) CSS_URI;
+ (int) CSS_IDENT;
+ (int) CSS_ATTR;
+ (int) CSS_COUNTER;
+ (int) CSS_RECT;
+ (int) CSS_RGBCOLOR;
@end

#endif
