/***************************************************************************
                            KKey.h -  description
                             -------------------
    begin                : Thu Mar 21 01:01:29 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Thu Mar 21 01:01:29 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KKEY_H
#define KKEY_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QtSupport.h>

/**

 A KKey object represents a single key with possible modifiers
 (Shift, Ctrl, Alt, Win).  It can represent both keys which are
 understood by Qt as well as those which are additionally supported
 by the underlying system (e.g. X11).
********************************************************************
 @short 
 A KKey object represents a single key with possible modifiers
 (Shift, Ctrl, Alt, Win).
*/

@class QKeyEvent;
@class QKeySequence;

@interface  KKey : NSObject <QtSupport>
{
@private
	void * _qt;
	BOOL  _allocatedInObjcWorld;
}
- init;
- initWithInt: (int)keyQt;
- initWithKeySequence: (QKeySequence*)arg1;
- initWithKeyEvent: (QKeyEvent*)arg1;
- copyWithZone: (NSZone *) zone;
- initWithText: (NSString *)arg1;

/** 

	 
*/
- initWithUnsigned: (unsigned int)key mod: (unsigned int)mod;
- (void) dealloc;
- clear;
- (BOOL) isInitWithInt: (int)keyQt;
- (BOOL) isInitWithKeySequence: (QKeySequence*)arg1;
- (BOOL) isInitWithKeyEvent: (QKeyEvent*)arg1;
- (BOOL) isInitWithKey: (KKey*)arg1;
- (BOOL) isInitWithText: (NSString *)arg1;

/** 

	 
*/
- (BOOL) isInit: (unsigned int)key mod: (unsigned int)mod;
- (BOOL) isNull;
//- (BOOL) isValidQt;
//- (BOOL) isValidNative;

/** 

	 
*/
- (unsigned int) sym;

/** 

	 
*/
- (unsigned int) modFlags;
- (int) compare: (KKey*)arg1;
- (int) keyCodeQt;
- (NSString *) toString;
- (NSString *) toStringInternal;
- simplify;
+ (KKey*) null;
+ (NSString *) modFlagLabel: (int)arg1;
+ (int) MOD_FLAG_COUNT;
+ (int) QtWIN;
+ (int) SHIFT;
+ (int) CTRL;
+ (int) ALT;
+ (int) WIN;
@end

#endif
