/***************************************************************************
                            KRecentDocument.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KRECENTDOCUMENT_H
#define KRECENTDOCUMENT_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QtSupport.h>

/**

 Manage the "Recent Document Menu" entries displayed by
 applications such as Kicker and Konqueror.

 These entries are automatically generated .desktop files pointing
 to the current application and document.  You should call the
 static @ref -add method whenever the user opens or saves a new
 document if you want it to show up in the menu.

 You don't have to worry about this if you are using any @ref
 KFileDialog derived class to open and save documents, as it
 already calls this class.  User defined limits on the maximum
 number of documents to save, etc... are all automatically handled.

 @author Daniel M. Duley <mosfet@kde.org> 
 
 @short 
 Manage the "Recent Document Menu" entries displayed by
 applications such as Kicker and Konqueror.
*/
@class KURL; 

@interface  KRecentDocument : NSObject <QtSupport>
{
@private
	void * _qt;
	BOOL  _allocatedInObjcWorld;
}

/** 

 Return a list of absolute paths to recent document .desktop files,
 sorted by date.

     
*/
+ (NSArray *) recentDocuments;

/** 
 Add a new item to the Recent Document menu.

*/
+ addURL: (KURL*)url;

/** 

 Add a new item to the Recent Document menu. Calls add( url ).

*/
+ add: (NSString *)documentStr isURL: (BOOL)isURL;
+ add: (NSString *)documentStr ;

/** 
 Clear the recent document menu of all entries.
     
*/
+ clear;

/** 
 Returns the maximum amount of recent document entries allowed.
     
*/
+ (int) maximumItems;

/** 
 Returns the path to the directory where recent document .desktop files
 are stored.
     
*/
+ (NSString *) recentDocumentDirectory;
@end

#endif
