/***************************************************************************
                            QDockWindow.h -  description
                             -------------------
    begin                : Wed Nov 21 12:08:37 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Wed Nov 21 12:08:37 2001, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef QDOCKWINDOW_H
#define QDOCKWINDOW_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QFrame.h>

@class QBoxLayout;
@class QDockArea;

@interface QDockWindow : QFrame 
- initWithInt: (int)p parent: (QWidget *)parent name: (NSString *)name f: (int)f;
- init;
- (void) dealloc;
- setWidget: (QWidget *)w;
- (QWidget*) widget;
- (int) place;
- (QDockArea*) area;
- setCloseMode: (int)m;
- (BOOL) isCloseEnabled;
- (int) closeMode;
- setResizeEnabled: (BOOL)b;
- setMovingEnabled: (BOOL)b;
- (BOOL) isResizeEnabled;
- (BOOL) isMovingEnabled;
- setHorizontallyStretchable: (BOOL)b;
- setVerticallyStretchable: (BOOL)b;
- (BOOL) isHorizontallyStretchable;
- (BOOL) isVerticallyStretchable;
- setHorizontalStretchable: (BOOL)b;
- setVerticalStretchable: (BOOL)b;
- (BOOL) isHorizontalStretchable;
- (BOOL) isVerticalStretchable;
- (BOOL) isStretchable;
- setOffset: (int)o;
- (int) offset;
- setFixedExtentWidth: (int)w;
- setFixedExtentHeight: (int)h;
- (QSize*) fixedExtent;
- setNewLine: (BOOL)b;
- (BOOL) newLine;
- (int) orientation;
- (QSize*) sizeHint;
- (QSize*) minimumSize;
- (QSize*) minimumSizeHint;
- (QBoxLayout*) boxLayout;
- setOpaqueMoving: (BOOL)b;
- (BOOL) opaqueMoving;
- (BOOL) eventFilter: (QObject *)o e: (QEvent *)e;
- (NSString *) caption;
- undock: (QWidget *)w;
- undock;
- dock;
- setOrientation: (int)o;
- setCaption: (NSString *)s;
- (BOOL) event: (QEvent *)e;
+ (int) InDock;
+ (int) OutsideDock;
+ (int) Never;
+ (int) Docked;
+ (int) Undocked;
+ (int) Always;
@end

/** Override these methods in subclasses of QDockWindow to customise event handling behaviour */
@protocol QDockWindowEventHandling
- keyPressEvent:(QKeyEvent*) arg1;
- keyReleaseEvent:(QKeyEvent*) arg1;
- focusOutEvent:(QFocusEvent*) arg1;
- childEvent:(QChildEvent*) arg1;
- dragMoveEvent:(QDragMoveEvent*) arg1;
- leaveEvent:(QEvent*) arg1;
- tabletEvent:(QTabletEvent*) arg1;
- showEvent:(QShowEvent*) e;
- contextMenuEvent:(QContextMenuEvent*) e;
- mousePressEvent:(QMouseEvent*) arg1;
- imComposeEvent:(QIMEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- mouseReleaseEvent:(QMouseEvent*) arg1;
- mouseDoubleClickEvent:(QMouseEvent*) arg1;
- dragLeaveEvent:(QDragLeaveEvent*) arg1;
- enterEvent:(QEvent*) arg1;
- focusInEvent:(QFocusEvent*) arg1;
- imEndEvent:(QIMEvent*) arg1;
- dropEvent:(QDropEvent*) arg1;
- dragEnterEvent:(QDragEnterEvent*) arg1;
- mouseMoveEvent:(QMouseEvent*) arg1;
- moveEvent:(QMoveEvent*) arg1;
- wheelEvent:(QWheelEvent*) arg1;
- hideEvent:(QHideEvent*) e;
- imStartEvent:(QIMEvent*) arg1;
- closeEvent:(QCloseEvent*) arg1;
- paintEvent:(QPaintEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
- resizeEvent:(QResizeEvent*) e;
@end


#endif
