/***************************************************************************
                            QTextEdit.h -  description
                             -------------------
    begin                : Wed Nov 21 12:08:37 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Wed Nov 21 12:08:37 2001, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef QTEXTEDIT_H
#define QTEXTEDIT_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QScrollView.h>

@class QStyleSheet;
@class QMimeSourceFactory;
@class QPopupMenu;

@interface QTextEdit : QScrollView 
- initWithText: (NSString *)text context: (NSString *)context parent: (QWidget *)parent name: (NSString *)name;
- initWithText: (NSString *)text ;
- initWithWidget: (QWidget *)parent name: (NSString *)name;
- init;
- (void) dealloc;
- setPalette: (QPalette *)arg1;
- (NSString *) text;
- (NSString *) text: (int)para;
- (int) textFormat;
- (NSString *) context;
- (NSString *) documentTitle;
- getSelection: (int*)paraFrom indexFrom: (int*)indexFrom paraTo: (int*)paraTo indexTo: (int*)indexTo selNum: (int)selNum;
- getSelection: (int*)paraFrom indexFrom: (int*)indexFrom paraTo: (int*)paraTo indexTo: (int*)indexTo ;
- (BOOL) find: (NSString *)expr cs: (BOOL)cs wo: (BOOL)wo forward: (BOOL)forward para: (int*)para index: (int*)index;
- (BOOL) find: (NSString *)expr cs: (BOOL)cs wo: (BOOL)wo ;
- (int) paragraphs;
- (int) lines;
- (int) linesOfParagraph: (int)para;
- (int) lineOfChar: (int)para chr: (int)chr;
- (int) length;
- (QRect*) paragraphRect: (int)para;
- (int) paragraphAt: (QPoint*)pos;
- (int) charAt: (QPoint*)pos para: (int*)para;
- (int) paragraphLength: (int)para;
- (QStyleSheet*) styleSheet;
- (QMimeSourceFactory*) mimeSourceFactory;
- (QBrush*) paper;
- (BOOL) linkUnderline;
- (int) heightForWidth: (int)w;
- (BOOL) hasSelectedText;
- (NSString *) selectedText;
- (BOOL) isUndoAvailable;
- (BOOL) isRedoAvailable;
- (int) wordWrap;
- (int) wrapColumnOrWidth;
- (int) wrapPolicy;
- (int) tabStopWidth;
- (NSString *) anchorAt: (QPoint*)pos;
- (QSize*) sizeHint;
- (BOOL) isReadOnly;
- getCursorPosition: (int*)parag index: (int*)index;
- (BOOL) isModified;
- (BOOL) italic;
- (BOOL) bold;
- (BOOL) underline;
- (NSString *) family;
- (int) pointSize;
- (QColor*) color;
- (QFont*) font;
- (int) alignment;
- (int) undoDepth;
- (BOOL) getFormat: (int)para index: (int)index font: (QFont *)font color: (QColor*)color verticalAlignment: (int*)verticalAlignment;
- (BOOL) getParagraphFormat: (int)para font: (QFont *)font color: (QColor*)color verticalAlignment: (int*)verticalAlignment alignment: (int*)alignment displayMode: (int)displayMode listStyle: (int)listStyle listDepth: (int*)listDepth;
- (BOOL) isOverwriteMode;
- (QColor*) paragraphBackgroundColor: (int)para;
- (BOOL) isUndoRedoEnabled;
- (BOOL) eventFilter: (QObject *)o e: (QEvent *)e;
- setEnabled: (BOOL)arg1;
- setMimeSourceFactory: (QMimeSourceFactory*)factory;
- setStyleSheet: (QStyleSheet*)styleSheet;
- scrollToAnchor: (NSString *)name;
- setPaper: (QBrush *)pap;
- setLinkUnderline: (BOOL)arg1;
- setWordWrap: (int)mode;
- setWrapColumnOrWidth: (int)arg1;
- setWrapPolicy: (int)policy;
- copy;
- append: (NSString *)text;
- setText: (NSString *)txt;
- setText: (NSString *)txt context: (NSString *)context;
- setTextFormat: (int)f;
- selectAll: (BOOL)select;
- selectAll;
- setTabStopWidth: (int)ts;
- zoomIn: (int)range;
- zoomIn;
- zoomOut: (int)range;
- zoomOut;
- zoomTo: (int)size;
- sync;
- setReadOnly: (BOOL)b;
- undo;
- redo;
- cut;
- paste;
- pasteSubType: (NSString *)subtype;
- clear;
- del;
- indent;
- setItalic: (BOOL)b;
- setBold: (BOOL)b;
- setUnderline: (BOOL)b;
- setFamily: (NSString *)f;
- setPointSize: (int)s;
- setColor: (QColor *)c;
- setFont: (QFont *)f;
- setVerticalAlignment: (int)a;
- setAlignment: (int)a;
- setParagType: (int)dm listStyle: (int)listStyle;
- setCursorPosition: (int)parag index: (int)index;
- setSelection: (int)parag_from index_from: (int)index_from parag_to: (int)parag_to index_to: (int)index_to selNum: (int)selNum;
- setSelection: (int)parag_from index_from: (int)index_from parag_to: (int)parag_to index_to: (int)index_to ;
- setSelectionAttributes: (int)selNum back: (QColor *)back invertText: (BOOL)invertText;
- setModified: (BOOL)m;
- resetFormat;
- setUndoDepth: (int)d;
//- setFormat: (QTextFormat*)f flags: (int)flags;
- ensureCursorVisible;
//- placeCursor: (QPoint*)pos c: (QTextCursor*)c;
//- placeCursor: (QPoint*)pos ;
- moveCursor: (int)action select: (BOOL)select;
- doKeyboardAction: (int)action;
- removeSelectedText: (int)selNum;
- removeSelectedText;
- removeSelection: (int)selNum;
- removeSelection;
- setCurrentFont: (QFont *)f;
- setOverwriteMode: (BOOL)b;
- scrollToBottom;
- insert: (NSString *)text indent: (BOOL)indent checkNewLine: (BOOL)checkNewLine removeSelected: (BOOL)removeSelected;
- insert: (NSString *)text ;
- insertAt: (NSString *)text para: (int)para index: (int)index;
- removeParagraph: (int)para;
- insertParagraph: (NSString *)text para: (int)para;
- setParagraphBackgroundColor: (int)para bg: (QColor *)bg;
- clearParagraphBackground: (int)para;
- setUndoRedoEnabled: (BOOL)b;
- repaintChanged;
- updateStyles;
- drawContents: (QPainter *)p cx: (int)cx cy: (int)cy cw: (int)cw ch: (int)ch;
- (BOOL) event: (QEvent *)e;
- (BOOL) focusNextPrevChild: (BOOL)next;
//- (QTextDocument*) document;
//- (QTextCursor*) textCursor;
//- setDocument: (QTextDocument*)doc;
- (QPopupMenu*) createPopupMenu: (QPoint*)pos;
- (QPopupMenu*) createPopupMenu;
- drawCursor: (BOOL)visible;
- windowActivationChange: (BOOL)arg1;
- doChangeInterval;
+ (int) NoWrap;
+ (int) WidgetWidth;
+ (int) FixedPixelWidth;
+ (int) FixedColumnWidth;
+ (int) AtWordBoundary;
+ (int) Anywhere;
+ (int) AtWhiteSpace;
+ (int) ActionBackspace;
+ (int) ActionDelete;
+ (int) ActionReturn;
+ (int) ActionKill;
+ (int) MoveBackward;
+ (int) MoveForward;
+ (int) MoveWordBackward;
+ (int) MoveWordForward;
+ (int) MoveUp;
+ (int) MoveDown;
+ (int) MoveLineStart;
+ (int) MoveLineEnd;
+ (int) MoveHome;
+ (int) MoveEnd;
+ (int) MovePgUp;
+ (int) MovePgDown;
+ (int) AlignNormal;
+ (int) AlignSuperScript;
+ (int) AlignSubScript;
@end

/** Override these methods in subclasses of QTextEdit to customise event handling behaviour */
@protocol QTextEditEventHandling
- keyPressEvent:(QKeyEvent*) e;
- keyReleaseEvent:(QKeyEvent*) arg1;
- focusOutEvent:(QFocusEvent*) arg1;
- childEvent:(QChildEvent*) arg1;
- viewportDragMoveEvent:(QDragMoveEvent*) arg1;
- dragMoveEvent:(QDragMoveEvent*) arg1;
- contentsWheelEvent:(QWheelEvent*) e;
- leaveEvent:(QEvent*) arg1;
- tabletEvent:(QTabletEvent*) arg1;
- showEvent:(QShowEvent*) arg1;
- contentsContextMenuEvent:(QContextMenuEvent*) e;
- viewportContextMenuEvent:(QContextMenuEvent*) arg1;
- contextMenuEvent:(QContextMenuEvent*) arg1;
- viewportMousePressEvent:(QMouseEvent*) arg1;
- mousePressEvent:(QMouseEvent*) arg1;
- imComposeEvent:(QIMEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- viewportMouseReleaseEvent:(QMouseEvent*) arg1;
- mouseReleaseEvent:(QMouseEvent*) arg1;
- viewportMouseDoubleClickEvent:(QMouseEvent*) arg1;
- mouseDoubleClickEvent:(QMouseEvent*) arg1;
- viewportDragLeaveEvent:(QDragLeaveEvent*) arg1;
- dragLeaveEvent:(QDragLeaveEvent*) arg1;
- enterEvent:(QEvent*) arg1;
- contentsDropEvent:(QDropEvent*) e;
- focusInEvent:(QFocusEvent*) arg1;
- imEndEvent:(QIMEvent*) arg1;
- contentsDragLeaveEvent:(QDragLeaveEvent*) e;
- viewportDropEvent:(QDropEvent*) arg1;
- dropEvent:(QDropEvent*) arg1;
- contentsMouseDoubleClickEvent:(QMouseEvent*) e;
- viewportDragEnterEvent:(QDragEnterEvent*) arg1;
- dragEnterEvent:(QDragEnterEvent*) arg1;
- viewportMouseMoveEvent:(QMouseEvent*) arg1;
- mouseMoveEvent:(QMouseEvent*) arg1;
- contentsDragMoveEvent:(QDragMoveEvent*) e;
- moveEvent:(QMoveEvent*) arg1;
- contentsMouseReleaseEvent:(QMouseEvent*) e;
- viewportWheelEvent:(QWheelEvent*) arg1;
- wheelEvent:(QWheelEvent*) arg1;
- hideEvent:(QHideEvent*) arg1;
- contentsDragEnterEvent:(QDragEnterEvent*) e;
- contentsMouseMoveEvent:(QMouseEvent*) e;
- contentsMousePressEvent:(QMouseEvent*) e;
- imStartEvent:(QIMEvent*) arg1;
- closeEvent:(QCloseEvent*) arg1;
- viewportPaintEvent:(QPaintEvent*) arg1;
- paintEvent:(QPaintEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
- viewportResizeEvent:(QResizeEvent*) arg1;
- resizeEvent:(QResizeEvent*) e;
@end


#endif
