/*
**************************************************************************
                                 description
                             --------------------
    copyright            : (C) 2003 by Luis Carvalho
    email                : lpassos@oninetspeed.pt
**************************************************************************

**************************************************************************
*                                                                        *
*  This program is free software; you can redistribute it and/or modify  *
*  it under the terms of the GNU General Public License as published by  *
*  the Free Software Foundation; either version 2 of the License, or     *
*  (at your option) any later version.                                   *
*                                                                        *
**************************************************************************/

#include "pmlibraryhandle.h"
#include "pmlibraryobject.h"

#include <stdlib.h>
#include <unistd.h>

#include <qdir.h>
#include <qfile.h>
#include <qdom.h>
#include <qtextstream.h>
#include <qimage.h>

#include <klocale.h>
#include <kmessagebox.h>
#include <kstandarddirs.h>

#include "pmdebug.h"

PMLibraryHandle::PMLibraryHandle( )
{
   setPath( "" );
   setAuthor( i18n( "Unknown" ) );
   setName( i18n( "Unknown" ) );
   m_readOnly = true;
}

PMLibraryHandle::PMLibraryHandle( const QString& path )
{
   setPath( path );
   setAuthor( i18n( "Unknown" ) );
   setName( i18n( "Unknown" ) );
   loadLibraryInfo( );
}

PMLibraryHandle::~PMLibraryHandle( )
{
}

void PMLibraryHandle::setName( const QString& name )
{
   m_name = name;
}

void PMLibraryHandle::setPath( const QString& path )
{
   m_path = path;
}

void PMLibraryHandle::setAuthor( const QString& author )
{
   m_author = author;
}

void PMLibraryHandle::setDescription( const QString& description )
{
   m_description = description;
}

void PMLibraryHandle::loadLibraryInfo( )
{
   // 1. Open the information file (library_index.xml)
   QFile file( m_path + "/library_index.xml" );

   if( !file.open( IO_ReadOnly ) )
   {
      kdError( PMArea ) << "Could not find the library index." << endl;
      return;
   }
   
   // 2. Read the information
   QDomDocument doc( "KPOVLIBINDEX" );
   doc.setContent( &file );

   QDomElement e = doc.documentElement( );

   setName( e.attribute( "name", i18n( "Unknown" ) ) );
   setAuthor( e.attribute( "author", i18n( "Unknown" ) ) );
   setDescription( e.attribute( "description", "" ) );

   if( e.attribute( "readonly", "true" ) == "true" )
      m_readOnly = true;
   else
      m_readOnly = false;
}

PMLibraryHandle::PMResult PMLibraryHandle::createLibrary( )
{
   // Test if the library exists.
   QDir d( m_path );

   if( !d.exists( ) )
   {
      // If it doesn't, create it
      if( !d.mkdir( m_path ) )
      {
         return PMLibraryHandle::CouldNotCreateDir;
      }
   }
   else
   {
      return PMLibraryHandle::ExistingDir;
   }

   return saveLibraryInfo( );
}

PMLibraryHandle::PMResult PMLibraryHandle::saveLibraryInfo( )
{
   // Save the information to the index
   QFile file( m_path + "/library_index.xml" );
   if( !file.open( IO_WriteOnly ) )
   {
      return PMLibraryHandle::CouldNotCreateInfo;
   }

   // Create the XML DOM tree
   QDomDocument doc( "KPOVLIBINDEX" );
   QDomElement e = doc.createElement( "library" );
   e.setAttribute( "name", name( ) );
   e.setAttribute( "author", author( ) );
   e.setAttribute( "description", description( ) );
   doc.appendChild( e );

   // Save to the file
   QTextStream str( &file );
   str.setEncoding( QTextStream::UnicodeUTF8 );
   str << doc.toString( );
   file.close( );

   return PMLibraryHandle::Ok;
}

PMLibraryHandle::PMResult PMLibraryHandle::createNewObject( )
{
   PMLibraryObject aux;
   QCString s = m_path.latin1( );
   QString unknownIcon = locate( "data" , "kpovmodeler/questionmark.png" );
   QImage img;
   int fh;

   if( m_readOnly )
      return PMLibraryHandle::ReadOnlyLib;

   aux.setName( i18n( "Empty" ) );
   aux.setObjects( QByteArray( ) );
   img.load( unknownIcon, "PNG" );
   aux.setPreview( img );

   s = s + "/objXXXXXX.kpml";
   if( ( fh = mkstemps( s.data( ), 5 ) ) < 0 )
   {
      // Ooops! Error creating the file.
      return PMLibraryHandle::CouldNotCreateFile;
   } 

   // Success creating the file
   close( fh );
   aux.save( s );
   return PMLibraryHandle::Ok;
}
