/* 
 * Copyright (C) 2003-2004 the xine project
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: open_mrl.c,v 1.13 2004/12/02 19:43:11 dsalt Exp $
 *
 * open mrl dialog (plus file browser)
 */

#include "globals.h"

#include <gtk/gtk.h>

#include "open_mrl.h"
#include "playlist.h"
#include "utils.h"
#include "script_engine.h"

static GtkWidget      *mrl_dialog;
static gboolean        mrl_visible;
static GtkWidget      *mrl_entry;

void file_dialog_show(void) {

  gchar **fnames;

  fnames = modal_multi_file_dialog (_("Select file(s) to open"), NULL);
  
  if (fnames) {
    int    pos, i;
    gchar *mrl;

    i = 0; pos = 0;
    while ( (mrl = fnames[i]) ) {

      if (i)
	playlist_add_mrl (mrl, -1);
      else
	pos = playlist_add_mrl (mrl, -1);
      
      i++;
    }

    playlist_play (pos);
  }

}

void file_dialog_init (void) {

  /* nothing to be done natm */
}

static void open_mrl_response_cb (GtkDialog *dbox, int response, gpointer data)
{
  const gchar  *mrl;
  int           item;
  switch (response)
  {
  case GTK_RESPONSE_OK:
    mrl = gtk_entry_get_text (GTK_ENTRY (mrl_entry));
    item = playlist_add_mrl (mrl, -1);
    playlist_play (item); /* then hide */
  default:
    mrl_visible = FALSE;
    gtk_widget_hide (mrl_dialog);
  }
}

static JSBool js_open_show (JSContext *cx, JSObject *obj, uintN argc, 
			    jsval *argv, jsval *rval) {

  /* se_t *se = (se_t *) JS_GetContextPrivate(cx); */

  se_log_fncall ("open_show");

  file_dialog_show ();
  
  return JS_TRUE;
}

static JSBool js_open_mrl_show (JSContext *cx, JSObject *obj, uintN argc, 
				jsval *argv, jsval *rval) {

  /* se_t *se = (se_t *) JS_GetContextPrivate(cx); */

  se_log_fncall ("open_mrl_show");

  open_mrl_show ();
  
  return JS_TRUE;
}

void open_mrl_init (void) {

  GtkWidget *label, *hbox;

  mrl_dialog = gtk_dialog_new_with_buttons (_("Open MRL..."), NULL, 0,
				GTK_STOCK_CANCEL, GTK_RESPONSE_DELETE_EVENT,
				GTK_STOCK_OK, GTK_RESPONSE_OK,
				NULL);

  gtk_window_set_default_size (GTK_WINDOW (mrl_dialog), 400, 150);
  gtk_window_set_position (GTK_WINDOW (mrl_dialog), GTK_WIN_POS_CENTER);
  hide_on_delete (mrl_dialog, &mrl_visible);
  g_signal_connect (GTK_OBJECT (mrl_dialog), "response",
		    G_CALLBACK (open_mrl_response_cb), NULL);
  gtk_dialog_set_default_response (GTK_DIALOG(mrl_dialog), GTK_RESPONSE_OK);

  hbox = gtk_hbox_new (0, 2);

  label = gtk_label_new ("mrl:");

  gtk_box_pack_start (GTK_BOX(hbox), label, FALSE, FALSE, 0);

  mrl_entry = gtk_entry_new ();
  gtk_box_pack_start (GTK_BOX(hbox), mrl_entry, TRUE, TRUE, 2);

  gtk_box_pack_start_defaults (GTK_BOX (GTK_DIALOG (mrl_dialog)->vbox), hbox);

  mrl_visible = 0;

  {
    static const se_f_def_t defs[] = {
      { "open_show", js_open_show, 0, 0, SE_GROUP_FILE, NULL, NULL },
      { "open_mrl_show", js_open_mrl_show, 0, 0, SE_GROUP_FILE, NULL, NULL },
      { NULL }
    };
    se_defuns (gse, NULL, defs);
  }
}

void open_mrl_show (void) {
  if (mrl_visible) {
    mrl_visible = FALSE;
    gtk_widget_hide (mrl_dialog);
  } else {
    mrl_visible = TRUE;
    gtk_widget_show_all (mrl_dialog);
    gtk_widget_grab_focus (mrl_entry);
  }
}

