/*****************************************************************************\
  dj3320_cmap.cpp : Implimentation for the DJ3320 color maps

  Copyright (c) 1996 - 2003UL, Hewlett-Packard Co.
  All rights reserved.

  Redistribution and use in source and binary formsUL, with or without
  modificationUL, are permitted provided that the following conditions
  are met:
  1. Redistributions of source code must retain the above copyright
     noticeUL, this list of conditions and the following disclaimer.
  2. Redistributions in binary form must reproduce the above copyright
     noticeUL, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.
  3. Neither the name of Hewlett-Packard nor the names of its
     contributors may be used to endorse or promote products derived
     from this software without specific prior written permission.

  THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR IMPLIED
  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
  NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
  TO, PATENT INFRINGEMENT; PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
  OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
  ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
  \***************************************************************************/


#ifdef APDK_DJ3320

#include "config.h"

#include "global_types.h"

APDK_BEGIN_NAMESPACE

// 300x300x1, K    - Plain, Draft, Grey
uint32_t ulMapCROSSBOW_K_3x3x1[] =
{
       255UL,        255UL,        247UL,        224UL,        197UL,        177UL, 
       167UL,        161UL,        157UL,        171UL,        165UL,        161UL, 
       156UL,        152UL,        148UL,        146UL,        142UL,        139UL, 
       147UL,        144UL,        141UL,        137UL,        134UL,        131UL, 
       128UL,        125UL,        122UL,        130UL,        127UL,        124UL, 
       120UL,        117UL,        113UL,        111UL,        107UL,        105UL, 
       112UL,        110UL,        106UL,        104UL,        100UL,         98UL, 
        95UL,         93UL,         90UL,         96UL,         94UL,         91UL, 
        89UL,         86UL,         84UL,         81UL,         79UL,         76UL, 
        83UL,         80UL,         77UL,         75UL,         72UL,         70UL, 
        68UL,         66UL,         63UL,         69UL,         67UL,         64UL, 
        62UL,         60UL,         58UL,         55UL,         53UL,         51UL, 
        57UL,         55UL,         53UL,         50UL,         49UL,         46UL, 
        45UL,         42UL,         40UL,        231UL,        203UL,        184UL, 
       168UL,        164UL,        159UL,        155UL,        150UL,        147UL, 
       157UL,        153UL,        149UL,        146UL,        143UL,        140UL, 
       136UL,        134UL,        130UL,        139UL,        135UL,        133UL, 
       129UL,        126UL,        123UL,        120UL,        116UL,        112UL, 
       122UL,        118UL,        115UL,        112UL,        109UL,        105UL, 
       103UL,        100UL,         97UL,        105UL,        101UL,         99UL, 
        96UL,         93UL,         91UL,         88UL,         85UL,         83UL, 
        90UL,         87UL,         85UL,         82UL,         80UL,         77UL, 
        75UL,         72UL,         70UL,         76UL,         74UL,         71UL, 
        69UL,         66UL,         64UL,         62UL,         59UL,         57UL, 
        63UL,         61UL,         58UL,         57UL,         54UL,         52UL, 
        50UL,         48UL,         46UL,         51UL,         49UL,         47UL, 
        45UL,         43UL,         41UL,         39UL,         37UL,         35UL, 
       169UL,        165UL,        160UL,        156UL,        151UL,        148UL, 
       145UL,        142UL,        138UL,        147UL,        144UL,        141UL, 
       137UL,        134UL,        131UL,        128UL,        125UL,        122UL, 
       130UL,        127UL,        124UL,        120UL,        117UL,        113UL, 
       111UL,        107UL,        105UL,        112UL,        110UL,        106UL, 
       104UL,        100UL,         98UL,         95UL,         93UL,         90UL, 
        96UL,         94UL,         91UL,         89UL,         86UL,         84UL, 
        81UL,         79UL,         76UL,         83UL,         80UL,         77UL, 
        75UL,         72UL,         70UL,         68UL,         66UL,         63UL, 
        69UL,         67UL,         64UL,         62UL,         60UL,         58UL, 
        55UL,         53UL,         51UL,         57UL,         55UL,         53UL, 
        50UL,         49UL,         46UL,         45UL,         42UL,         40UL, 
        46UL,         44UL,         42UL,         40UL,         38UL,         36UL, 
        34UL,         32UL,         30UL,        156UL,        152UL,        149UL, 
       146UL,        143UL,        139UL,        135UL,        133UL,        129UL, 
       138UL,        135UL,        132UL,        129UL,        125UL,        123UL, 
       119UL,        116UL,        112UL,        121UL,        118UL,        114UL, 
       112UL,        108UL,        105UL,        102UL,        100UL,         96UL, 
       104UL,        101UL,         99UL,         96UL,         93UL,         91UL, 
        88UL,         85UL,         83UL,         90UL,         87UL,         85UL, 
        82UL,         80UL,         77UL,         75UL,         72UL,         70UL, 
        76UL,         73UL,         71UL,         68UL,         66UL,         64UL, 
        62UL,         59UL,         57UL,         63UL,         60UL,         58UL, 
        56UL,         54UL,         51UL,         50UL,         47UL,         46UL, 
        51UL,         49UL,         47UL,         45UL,         43UL,         41UL, 
        39UL,         37UL,         35UL,         40UL,         39UL,         36UL, 
        35UL,         32UL,         31UL,         29UL,         27UL,         25UL, 
       146UL,        143UL,        140UL,        136UL,        134UL,        130UL, 
       127UL,        124UL,        121UL,        130UL,        126UL,        124UL, 
       120UL,        117UL,        113UL,        111UL,        107UL,        105UL, 
       112UL,        109UL,        106UL,        103UL,        100UL,         97UL, 
        95UL,         92UL,         90UL,         96UL,         93UL,         91UL, 
        88UL,         86UL,         83UL,         81UL,         78UL,         76UL, 
        83UL,         80UL,         77UL,         75UL,         72UL,         70UL, 
        68UL,         65UL,         63UL,         69UL,         67UL,         64UL, 
        62UL,         60UL,         58UL,         55UL,         53UL,         51UL, 
        57UL,         55UL,         52UL,         50UL,         48UL,         46UL, 
        44UL,         42UL,         40UL,         45UL,         44UL,         41UL, 
        40UL,         37UL,         36UL,         34UL,         32UL,         30UL, 
        35UL,         33UL,         31UL,         29UL,         27UL,         25UL, 
        23UL,         21UL,         19UL,        137UL,        134UL,        131UL, 
       128UL,        125UL,        122UL,        118UL,        115UL,        112UL, 
       121UL,        118UL,        114UL,        112UL,        108UL,        105UL, 
       102UL,         99UL,         96UL,        104UL,        101UL,         98UL, 
        96UL,         93UL,         91UL,         88UL,         85UL,         83UL, 
        89UL,         87UL,         84UL,         82UL,         79UL,         77UL, 
        74UL,         72UL,         69UL,         75UL,         73UL,         70UL, 
        68UL,         66UL,         64UL,         61UL,         59UL,         57UL, 
        62UL,         60UL,         58UL,         56UL,         54UL,         51UL, 
        49UL,         47UL,         45UL,         51UL,         49UL,         47UL, 
        45UL,         43UL,         41UL,         39UL,         37UL,         35UL, 
        40UL,         38UL,         36UL,         34UL,         32UL,         30UL, 
        29UL,         26UL,         25UL,         30UL,         27UL,         26UL, 
        24UL,         22UL,         20UL,         18UL,         16UL,         14UL, 
       129UL,        125UL,        123UL,        119UL,        116UL,        112UL, 
       110UL,        106UL,        104UL,        112UL,        109UL,        105UL, 
       103UL,        100UL,         97UL,         94UL,         92UL,         89UL, 
        96UL,         93UL,         91UL,         88UL,         86UL,         83UL, 
        81UL,         78UL,         75UL,         83UL,         80UL,         77UL, 
        75UL,         72UL,         70UL,         68UL,         65UL,         63UL, 
        69UL,         66UL,         64UL,         62UL,         60UL,         57UL, 
        55UL,         53UL,         51UL,         57UL,         54UL,         52UL, 
        50UL,         48UL,         46UL,         44UL,         42UL,         40UL, 
        45UL,         44UL,         41UL,         40UL,         37UL,         36UL, 
        34UL,         31UL,         30UL,         35UL,         33UL,         31UL, 
        29UL,         27UL,         25UL,         23UL,         21UL,         19UL, 
        24UL,         23UL,         20UL,         18UL,         16UL,         14UL, 
        12UL,         10UL,          8UL,        120UL,        117UL,        113UL, 
       111UL,        107UL,        105UL,        101UL,         99UL,         96UL, 
       104UL,        100UL,         98UL,         95UL,         93UL,         90UL, 
        88UL,         85UL,         83UL,         89UL,         87UL,         84UL, 
        81UL,         79UL,         76UL,         74UL,         71UL,         69UL, 
        75UL,         73UL,         70UL,         68UL,         66UL,         64UL, 
        61UL,         59UL,         57UL,         62UL,         60UL,         58UL, 
        56UL,         53UL,         51UL,         49UL,         47UL,         45UL, 
        50UL,         49UL,         46UL,         45UL,         42UL,         41UL, 
        39UL,         37UL,         35UL,         40UL,         38UL,         36UL, 
        34UL,         32UL,         30UL,         28UL,         26UL,         24UL, 
        30UL,         27UL,         26UL,         24UL,         22UL,         20UL, 
        18UL,         16UL,         13UL,         19UL,         17UL,         15UL, 
        13UL,         11UL,          8UL,          7UL,          4UL,          2UL, 
       111UL,        108UL,        105UL,        102UL,        100UL,         96UL, 
        93UL,         91UL,         88UL,         96UL,         93UL,         91UL, 
        88UL,         85UL,         83UL,         80UL,         78UL,         75UL, 
        82UL,         80UL,         77UL,         75UL,         72UL,         70UL, 
        67UL,         65UL,         62UL,         68UL,         66UL,         64UL, 
        62UL,         59UL,         57UL,         55UL,         53UL,         50UL, 
        57UL,         54UL,         52UL,         50UL,         48UL,         46UL, 
        44UL,         42UL,         40UL,         45UL,         43UL,         41UL, 
        39UL,         37UL,         35UL,         34UL,         31UL,         30UL, 
        35UL,         32UL,         31UL,         29UL,         27UL,         25UL, 
        23UL,         21UL,         19UL,         24UL,         23UL,         20UL, 
        18UL,         16UL,         14UL,         12UL,         10UL,          8UL, 
        13UL,         11UL,          9UL,          7UL,          5UL,          3UL, 
         1UL,          0UL,          0UL, 
};

// 600x600x1, K    - Plain, Normal, Grey

uint32_t ulMapCROSSBOW_K_6x6x1[] =
{
       255UL,        238UL,        218UL,        204UL,        189UL,        181UL, 
       171UL,        161UL,        154UL,        178UL,        168UL,        161UL, 
       153UL,        148UL,        141UL,        136UL,        130UL,        127UL, 
       140UL,        133UL,        129UL,        124UL,        121UL,        116UL, 
       113UL,        109UL,        106UL,        115UL,        112UL,        108UL, 
       104UL,        101UL,         97UL,         95UL,         91UL,         89UL, 
        96UL,         94UL,         90UL,         88UL,         85UL,         82UL, 
        79UL,         77UL,         74UL,         81UL,         78UL,         76UL, 
        73UL,         71UL,         69UL,         66UL,         65UL,         62UL, 
        67UL,         66UL,         63UL,         62UL,         59UL,         57UL, 
        55UL,         54UL,         51UL,         56UL,         55UL,         52UL, 
        51UL,         49UL,         47UL,         45UL,         44UL,         42UL, 
        47UL,         45UL,         43UL,         41UL,         40UL,         38UL, 
        37UL,         35UL,         33UL,        209UL,        191UL,        184UL, 
       173UL,        166UL,        156UL,        151UL,        144UL,        140UL, 
       154UL,        149UL,        143UL,        138UL,        132UL,        128UL, 
       123UL,        120UL,        115UL,        127UL,        122UL,        119UL, 
       114UL,        111UL,        107UL,        104UL,        100UL,         96UL, 
       106UL,        102UL,         99UL,         95UL,         93UL,         90UL, 
        87UL,         84UL,         81UL,         89UL,         85UL,         83UL, 
        80UL,         78UL,         75UL,         73UL,         70UL,         68UL, 
        74UL,         71UL,         69UL,         67UL,         65UL,         63UL, 
        61UL,         59UL,         57UL,         62UL,         60UL,         58UL, 
        56UL,         54UL,         52UL,         50UL,         48UL,         47UL, 
        51UL,         50UL,         48UL,         46UL,         44UL,         43UL, 
        41UL,         39UL,         38UL,         42UL,         40UL,         38UL, 
        37UL,         35UL,         34UL,         32UL,         31UL,         29UL, 
       176UL,        168UL,        159UL,        153UL,        146UL,        141UL, 
       135UL,        130UL,        125UL,        140UL,        133UL,        129UL, 
       124UL,        121UL,        116UL,        113UL,        109UL,        106UL, 
       115UL,        112UL,        108UL,        104UL,        101UL,         97UL, 
        95UL,         91UL,         89UL,         96UL,         94UL,         90UL, 
        88UL,         85UL,         82UL,         79UL,         77UL,         74UL, 
        81UL,         78UL,         76UL,         73UL,         71UL,         69UL, 
        66UL,         65UL,         62UL,         67UL,         66UL,         63UL, 
        62UL,         59UL,         57UL,         55UL,         54UL,         51UL, 
        56UL,         55UL,         52UL,         51UL,         49UL,         47UL, 
        45UL,         44UL,         42UL,         47UL,         45UL,         43UL, 
        41UL,         40UL,         38UL,         37UL,         35UL,         33UL, 
        38UL,         36UL,         34UL,         32UL,         31UL,         29UL, 
        28UL,         26UL,         25UL,        153UL,        148UL,        143UL, 
       136UL,        132UL,        127UL,        122UL,        119UL,        114UL, 
       125UL,        122UL,        118UL,        114UL,        110UL,        107UL, 
       103UL,        100UL,         96UL,        105UL,        102UL,         98UL, 
        95UL,         92UL,         90UL,         86UL,         84UL,         81UL, 
        88UL,         85UL,         83UL,         80UL,         77UL,         75UL, 
        72UL,         70UL,         67UL,         74UL,         71UL,         69UL, 
        67UL,         65UL,         63UL,         61UL,         59UL,         57UL, 
        62UL,         60UL,         58UL,         56UL,         54UL,         52UL, 
        50UL,         48UL,         47UL,         51UL,         49UL,         48UL, 
        46UL,         44UL,         42UL,         41UL,         39UL,         38UL, 
        42UL,         40UL,         38UL,         37UL,         35UL,         33UL, 
        32UL,         30UL,         29UL,         33UL,         31UL,         30UL, 
        28UL,         27UL,         25UL,         24UL,         22UL,         21UL, 
       138UL,        132UL,        128UL,        123UL,        120UL,        115UL, 
       112UL,        108UL,        105UL,        115UL,        111UL,        108UL, 
       104UL,        101UL,         97UL,         95UL,         91UL,         89UL, 
        96UL,         93UL,         90UL,         87UL,         85UL,         81UL, 
        79UL,         76UL,         74UL,         81UL,         78UL,         76UL, 
        73UL,         71UL,         68UL,         66UL,         64UL,         62UL, 
        67UL,         66UL,         63UL,         62UL,         59UL,         57UL, 
        55UL,         53UL,         51UL,         56UL,         55UL,         52UL, 
        51UL,         49UL,         47UL,         45UL,         44UL,         42UL, 
        46UL,         45UL,         43UL,         41UL,         39UL,         38UL, 
        36UL,         35UL,         33UL,         37UL,         36UL,         34UL, 
        32UL,         31UL,         29UL,         28UL,         26UL,         25UL, 
        28UL,         27UL,         26UL,         24UL,         22UL,         21UL, 
        19UL,         18UL,         16UL,        124UL,        121UL,        116UL, 
       113UL,        109UL,        106UL,        102UL,         99UL,         95UL, 
       105UL,        102UL,         98UL,         95UL,         92UL,         90UL, 
        86UL,         83UL,         81UL,         88UL,         85UL,         82UL, 
        80UL,         77UL,         75UL,         72UL,         70UL,         67UL, 
        73UL,         71UL,         69UL,         67UL,         65UL,         63UL, 
        60UL,         59UL,         56UL,         62UL,         60UL,         57UL, 
        56UL,         54UL,         52UL,         50UL,         48UL,         46UL, 
        51UL,         49UL,         48UL,         46UL,         44UL,         42UL, 
        40UL,         39UL,         37UL,         42UL,         40UL,         38UL, 
        37UL,         35UL,         33UL,         32UL,         30UL,         29UL, 
        33UL,         31UL,         30UL,         28UL,         27UL,         25UL, 
        24UL,         22UL,         21UL,         25UL,         23UL,         22UL, 
        20UL,         19UL,         17UL,         16UL,         14UL,         12UL, 
       114UL,        110UL,        107UL,        103UL,        100UL,         96UL, 
        94UL,         90UL,         88UL,         95UL,         93UL,         90UL, 
        87UL,         84UL,         81UL,         78UL,         76UL,         73UL, 
        81UL,         78UL,         76UL,         73UL,         71UL,         68UL, 
        66UL,         64UL,         62UL,         67UL,         65UL,         63UL, 
        61UL,         59UL,         57UL,         55UL,         53UL,         51UL, 
        56UL,         54UL,         52UL,         50UL,         49UL,         47UL, 
        45UL,         43UL,         42UL,         46UL,         44UL,         43UL, 
        41UL,         39UL,         38UL,         36UL,         34UL,         33UL, 
        37UL,         36UL,         34UL,         32UL,         31UL,         29UL, 
        28UL,         26UL,         25UL,         28UL,         27UL,         25UL, 
        24UL,         22UL,         21UL,         19UL,         18UL,         16UL, 
        20UL,         19UL,         17UL,         16UL,         14UL,         13UL, 
        11UL,         10UL,          8UL,        104UL,        101UL,         97UL, 
        95UL,         91UL,         89UL,         85UL,         83UL,         80UL, 
        88UL,         85UL,         82UL,         79UL,         77UL,         74UL, 
        72UL,         69UL,         67UL,         73UL,         71UL,         69UL, 
        66UL,         65UL,         62UL,         60UL,         58UL,         56UL, 
        62UL,         60UL,         57UL,         56UL,         54UL,         52UL, 
        50UL,         48UL,         46UL,         51UL,         49UL,         47UL, 
        46UL,         44UL,         42UL,         40UL,         39UL,         37UL, 
        41UL,         40UL,         38UL,         37UL,         35UL,         33UL, 
        31UL,         30UL,         28UL,         32UL,         31UL,         29UL, 
        28UL,         26UL,         25UL,         23UL,         22UL,         20UL, 
        25UL,         23UL,         22UL,         20UL,         19UL,         17UL, 
        16UL,         14UL,         12UL,         16UL,         15UL,         13UL, 
        12UL,         10UL,          9UL,          7UL,          6UL,          4UL, 
        95UL,         92UL,         90UL,         86UL,         84UL,         81UL, 
        78UL,         76UL,         73UL,         80UL,         78UL,         75UL, 
        73UL,         70UL,         68UL,         66UL,         64UL,         62UL, 
        67UL,         65UL,         63UL,         61UL,         59UL,         57UL, 
        55UL,         53UL,         51UL,         56UL,         54UL,         52UL, 
        50UL,         48UL,         47UL,         45UL,         43UL,         41UL, 
        46UL,         44UL,         43UL,         41UL,         39UL,         38UL, 
        36UL,         34UL,         33UL,         37UL,         35UL,         34UL, 
        32UL,         31UL,         29UL,         28UL,         26UL,         25UL, 
        28UL,         27UL,         25UL,         24UL,         22UL,         21UL, 
        19UL,         18UL,         16UL,         20UL,         19UL,         17UL, 
        16UL,         14UL,         12UL,         11UL,          9UL,          8UL, 
        12UL,         11UL,          9UL,          8UL,          6UL,          5UL, 
         3UL,          2UL,          0UL, 
};

// 300x300x1, CMY  - Plain Draft, Color Pen Only

uint32_t ulMapCROSSBOW_CMY_3x3x1[ 9 * 9 * 9 ] =
{
4294967040UL, 4294967040UL, 2499804928UL, 1073741568UL,  619577088UL,  383844096UL, 
 198573824UL,   63766272UL,   12975872UL, 4292869888UL, 4293394176UL, 2381905664UL, 
 838074112UL,  535494400UL,  350093056UL,  164888320UL,   30080768UL,   12779264UL, 
4285398784UL, 4285660928UL, 2961506048UL,  966983424UL,  246087424UL,   79036160UL, 
  62717696UL,   29032192UL,   11730688UL, 4282184960UL, 4282318592UL, 4282842880UL, 
1833565952UL,  744423168UL,  259391232UL,  126025472UL,   59244288UL,    9043712UL, 
4280872960UL, 4280811264UL, 4280614656UL, 3626434304UL, 1311768320UL,  523894528UL, 
 240123648UL,  106888960UL,    6618880UL, 4280217600UL, 4280089344UL, 4279566080UL, 
4279566080UL, 2300313344UL,  958725888UL,  388497152UL,  121044736UL,    4652800UL, 
4279495424UL, 4279366912UL, 4278976256UL, 4278517504UL, 3071082240UL, 1494482688UL, 
 555155200UL,  203030272UL,    2883328UL, 4278838528UL, 4278710016UL, 4278517504UL, 
4278714112UL, 3439787776UL, 2047147776UL, 1040973568UL,  235667200UL,     982784UL, 
4278250752UL, 4278250752UL, 4278250752UL, 4278249728UL, 3439389952UL, 2298540800UL, 
1359018752UL,  604045056UL,      65280UL, 4294960384UL, 1325354752UL,  704642816UL, 
 134217472UL,  134217472UL,  117440256UL,   83033856UL,   48234240UL,   13303552UL, 
4293254400UL, 4294967040UL, 2515271424UL,  517013248UL,   63110912UL,   12254976UL, 
  11730688UL,   11206400UL,   11075328UL, 4285195008UL, 4286447360UL, 2727345920UL, 
 881655552UL,  210894592UL,    9961216UL,   10157824UL,   10157824UL,   10551040UL, 
4282050560UL, 4281597696UL, 4013752064UL, 1631911680UL,  458358528UL,   73531136UL, 
   7339776UL,    7995136UL,    8781568UL, 4280740352UL, 4280220928UL, 4280221440UL, 
2770599680UL, 1059520256UL,  322043648UL,   54722304UL,    5373696UL,    6225664UL, 
4280019456UL, 4279169024UL, 4279365632UL, 3574595328UL, 1813118720UL,  739573504UL, 
 203161344UL,   19726080UL,    4194048UL, 4279231488UL, 4278510336UL, 4278640384UL, 
3892834304UL, 2399600384UL, 1242169088UL,  521076480UL,  101646080UL,    2096896UL, 
4278640640UL, 4278241792UL, 4278242304UL, 4076918016UL, 2801853184UL, 1711336192UL, 
 855895296UL,  235008512UL,     524032UL, 4278246656UL, 4278240512UL, 4278241280UL, 
4278241280UL, 3070281728UL, 2046873600UL, 1191237632UL,  520148992UL,      55040UL, 
4294930944UL, 4127145472UL,  872370432UL,  385862656UL,  218103552UL,  134217472UL, 
  83230464UL,   65339136UL,   13631232UL, 4294603520UL, 4294941696UL, 2281675776UL, 
 385861376UL,   15790592UL,   14417664UL,   13172480UL,   12254976UL,   11927296UL, 
4285692160UL, 4286680320UL, 2307498496UL, 1418377216UL,  193460224UL,    9043712UL, 
   9109248UL,    9240320UL,    9109248UL, 4282296832UL, 4282370048UL, 3628255744UL, 
1633073664UL,  509011968UL,   23065856UL,    7140608UL,    7732992UL,    8388352UL, 
4280599552UL, 4280405760UL, 4280079616UL, 2368003328UL,  824438784UL,  238155776UL, 
   4516608UL,    5437184UL,    6487808UL, 4279749888UL, 4279225344UL, 4279026176UL, 
2937046272UL, 1494344192UL,  605287680UL,  119337472UL,    3140864UL,    4321792UL, 
4279029504UL, 4278437632UL, 4278236928UL, 3255022592UL, 2030290944UL, 1057281792UL, 
 335798272UL,   51177984UL,    2417152UL, 4278505216UL, 4278236416UL, 4278232832UL, 
3607144960UL, 2432742400UL, 1543553536UL,  788644864UL,  201377536UL,     514816UL, 
4278239232UL, 4278235648UL, 4278233088UL, 3925911552UL, 2751506944UL, 1895870208UL, 
1174450688UL,  503362048UL,      43520UL, 4294915840UL, 4294910720UL, 1778329344UL, 
 520043520UL,  385846272UL,  218087424UL,  133881856UL,   65599488UL,   13892352UL, 
4294653440UL, 4294915584UL, 2147432960UL,  469717248UL,   16744960UL,   15707136UL, 
  14338560UL,   13098240UL,   12580608UL, 4288300800UL, 4288694784UL, 2946258432UL, 
1453483776UL,  162692352UL,   11836672UL,   11187200UL,   10536704UL,   10280192UL, 
4282798336UL, 4283326208UL, 3075891456UL, 1499032064UL,  912028928UL,   56599040UL, 
   6795776UL,    7193600UL,    7330560UL, 4280711680UL, 4280713472UL, 4280714240UL, 
2301330432UL,  976647936UL,  204971008UL,    4827136UL,    5750016UL,    6477568UL, 
4279539968UL, 4279342080UL, 4279340032UL, 2987364864UL, 1461097472UL,  504799744UL, 
  52540672UL,    3652864UL,    4706048UL, 4278823424UL, 4278492160UL, 4278422784UL, 
3171191040UL, 1896320768UL, 1057595136UL,  319202560UL,   18067456UL,    2864384UL, 
4278496768UL, 4278228224UL, 4278226176UL, 3422587136UL, 2264960000UL, 1459655680UL, 
 771987968UL,  184654848UL,     829184UL, 4278230784UL, 4278228224UL, 4278226688UL, 
3623913984UL, 2566949888UL, 1895860736UL, 1241549824UL,  520131072UL,      35840UL, 
4294908928UL, 4294905344UL, 3170831872UL,  352260352UL,  520042240UL,  301950464UL, 
 167610624UL,   82813952UL,   14726144UL, 4294447872UL, 4294577920UL, 3120503040UL, 
 654253056UL,   33502720UL,   16277760UL,   14909696UL,   14129664UL,   14004736UL, 
4288945920UL, 4289142528UL, 3031048448UL, 1237462016UL,  164051200UL,   12409344UL, 
  11892480UL,   11899392UL,   11578368UL, 4283706368UL, 4284100864UL, 3579981568UL, 
1734491648UL,  879510528UL,   75322880UL,    8678656UL,    8684800UL,    8495616UL, 
4281022976UL, 4281220864UL, 4281286144UL, 1949778176UL,  976897792UL,  524243456UL, 
  21655296UL,    5406464UL,    5872640UL, 4279655168UL, 4279654144UL, 4279718912UL, 
3038205696UL, 1494964736UL,  606163456UL,   69824768UL,    4097024UL,    4889600UL, 
4279007488UL, 4278676480UL, 4278673664UL, 3171507968UL, 1896441344UL,  974022400UL, 
 286026752UL,    1672960UL,    3249408UL, 4278616576UL, 4278219776UL, 4278283264UL, 
3489753344UL, 2181261056UL, 1375955200UL,  822504448UL,  151090432UL,    1146624UL, 
4278221824UL, 4278219776UL, 4278219264UL, 3758125568UL, 2483056384UL, 1828743680UL, 
1275094784UL,  587230976UL,      28928UL, 4294906112UL, 4294903552UL, 4127133440UL, 
1509888768UL,  486480896UL,  335489792UL,  201280000UL,  116613632UL,   14841088UL, 
4294577664UL, 4294772992UL, 3690923776UL, 1375668992UL,   67047680UL,   16722688UL, 
  15354368UL,   14311680UL,   13988352UL, 4289989632UL, 4289005056UL, 3131836160UL, 
1724387584UL,  299045632UL,   13249280UL,   12339456UL,   12214016UL,   12415488UL, 
4284683264UL, 4284617728UL, 3664385024UL, 1835996672UL,  780213760UL,   59320064UL, 
   9192960UL,    9526272UL,    9729792UL, 4281737472UL, 4281999616UL, 4281999104UL, 
2185502976UL, 1095181312UL,  558509056UL,   56245760UL,    6706944UL,    7107072UL, 
4280036352UL, 4279971584UL, 4279970048UL, 2820548352UL, 1327704320UL,  606350336UL, 
 321664768UL,   20731648UL,    4813312UL, 4279322368UL, 4278993920UL, 4279123456UL, 
3289332736UL, 1947155968UL,  907424768UL,  336869120UL,   18831104UL,    3566592UL, 
4278670336UL, 4278275584UL, 4278274560UL, 3439544576UL, 2181449984UL, 1275480320UL, 
 789006592UL,  117657344UL,    1465856UL, 4278212864UL, 4278212352UL, 4278211584UL, 
3623900672UL, 2533381632UL, 1577078528UL, 1174423808UL,  654331648UL,      21504UL, 
4294904064UL, 4294902528UL, 4294904576UL, 2331970560UL,  973017856UL,  352261120UL, 
 218045440UL,  133707264UL,   15026432UL, 4294444800UL, 4294639872UL, 4026466304UL, 
2113864448UL,  654248192UL,   16715520UL,   15671552UL,   14497536UL,   14108416UL, 
4290774528UL, 4290380800UL, 3753640192UL, 2110390528UL,  702152960UL,   14093312UL, 
  12853504UL,   12531456UL,   12732672UL, 4286319616UL, 4284743680UL, 3547136000UL, 
2105345792UL, 1066142720UL,  160499456UL,    9707008UL,    9909760UL,   10438400UL, 
4282848000UL, 4282519040UL, 3796241408UL, 2185890816UL, 1145966080UL,  525997056UL, 
  56761088UL,    7156736UL,    7949312UL, 4280358656UL, 4280227328UL, 4280685568UL, 
2401965568UL, 1378751488UL,  691082240UL,  338959104UL,   21376768UL,    5523968UL, 
4279442176UL, 4279115264UL, 4279180288UL, 3071351552UL, 1863523072UL,  907417344UL, 
 370546944UL,  203499264UL,    3229440UL, 4278989056UL, 4278595072UL, 4278594560UL, 
3355913216UL, 2231971328UL, 1309224448UL,  688661504UL,  151462912UL,    1786880UL, 
4278204160UL, 4278203904UL, 4278203904UL, 3439343104UL, 2432710400UL, 1493186048UL, 
 922758912UL,  637546240UL,      13824UL, 4294902784UL, 4294902784UL, 4294903296UL, 
2818508288UL, 1476331776UL,  754912768UL,  218040576UL,  117116416UL,   15409920UL, 
4294246656UL, 4293722112UL, 4159897600UL, 2515861504UL, 1291452416UL,  301465856UL, 
  15665920UL,   14816256UL,   14360832UL, 4291101696UL, 4290576384UL, 3988717568UL, 
2462384128UL, 1422917632UL,  399704064UL,   13437184UL,   12850176UL,   12919040UL, 
4286907904UL, 4286709760UL, 4085711104UL, 2408186112UL, 1502740736UL,  731513600UL, 
  27001856UL,   10097408UL,   10625280UL, 4283500800UL, 4282777600UL, 3578396672UL, 
2303983616UL, 1280770048UL,  912656128UL,  241829376UL,    7409920UL,    8332288UL, 
4281010432UL, 4281273088UL, 3710649344UL, 2452685824UL, 1446249216UL,  691601664UL, 
 457575168UL,   21761536UL,    6039040UL, 4279634944UL, 4279438336UL, 3608546304UL, 
2484866048UL, 1495141376UL, 1042483456UL,  388039680UL,  153356544UL,    3809536UL, 
4278782976UL, 4278456064UL, 4278587136UL, 3204845056UL, 1997082112UL, 1242107392UL, 
 688655360UL,  151587584UL,    1646848UL, 4278196480UL, 4278196224UL, 4143978240UL, 
3355449600UL, 2365593856UL, 1509956352UL,  872421632UL,  469767680UL,       7936UL, 
4294901760UL, 4294901760UL, 4294639616UL, 3321495552UL, 2230779904UL, 1240793088UL, 
 653590528UL,  267583488UL,   15925248UL, 4293918720UL, 4293591040UL, 4209442816UL, 
2833448960UL, 1843724288UL,  920977408UL,  400687104UL,   81723392UL,   14483456UL, 
4290707456UL, 4290707456UL, 4039114752UL, 2764308480UL, 1925513216UL, 1204224000UL, 
 432275456UL,   29622272UL,   12713984UL, 4287168512UL, 4287168512UL, 4287758336UL, 
2627010560UL, 1922498560UL, 1385824256UL,  664731648UL,   77725696UL,   10616832UL, 
4284219392UL, 4284088320UL, 4200660992UL, 2993291264UL, 1684865024UL, 1366228992UL, 
 863305728UL,  209453056UL,    8192000UL, 4281794560UL, 4281729024UL, 3980328960UL, 
2571370496UL, 1715732480UL,  977338368UL,  827195392UL,  374931456UL,    6160384UL, 
4280025088UL, 4279631872UL, 4146003968UL, 2535718912UL, 1630076928UL, 1042874368UL, 
 606666752UL,  422838272UL,    3932160UL, 4278845440UL, 4278255616UL, 4278452224UL, 
3490250752UL, 1627980032UL, 1040974592UL,  470548480UL,  320077824UL,    2293760UL, 
4278190080UL, 4278190080UL, 3892314112UL, 3036676096UL, 2181038080UL, 1442840576UL, 
 771751936UL,  335544320UL,          0UL, 
};

// 300x300x1, KCMY - Plain Draft, Both Pens

uint32_t ulMapCROSSBOW_KCMY_3x3x1[ 9 * 9 * 9 ] =
{
1330601906UL,   13500224UL,   12582697UL,   12386074UL,   12254995UL,   12254990UL, 
  12254986UL,   12386053UL,   12451584UL, 4280614716UL,  184614723UL,   10288939UL, 
  12255003UL,   12386067UL,   12254990UL,   12254986UL,   12386053UL,   12123904UL, 
4281269534UL, 4279566124UL,  184614710UL,    6618912UL,    9568021UL,   10682126UL, 
  11206410UL,   11403012UL,   11206400UL, 4281138958UL, 4280090387UL, 3842047776UL, 
 251723559UL,    3473177UL,    6618893UL,    8060677UL,    9043714UL,    8912640UL, 
4280941063UL, 4280549129UL, 4278648595UL, 2768305944UL,  335609628UL,    1638165UL, 
   4325131UL,  157482753UL,    6749952UL, 4280741633UL, 4280613378UL, 4279369479UL, 
4278255375UL, 2080440081UL,  335609621UL,     655120UL,   53214983UL,    4849408UL, 
4280084224UL, 4280021504UL, 4279697152UL, 4278451974UL, 3523346184UL, 1510211337UL, 
 318897931UL,   67895045UL,    2752256UL, 4279165696UL, 4279168256UL, 4278714112UL, 
4278714112UL, 4228316928UL, 2450128641UL, 1141636866UL,  319553280UL,     982784UL, 
4278250752UL, 4278251264UL, 4278252032UL, 4278253568UL, 3741384448UL, 2566979328UL, 
1577123584UL,  721485568UL,      65280UL, 4294903620UL,   16717634UL,   16776996UL, 
  67108627UL,   33554187UL,   15990535UL,   15073028UL,   14352129UL,   13172480UL, 
4284972085UL, 2240126303UL, 1071513390UL,   46989077UL,   13172493UL,   29687559UL, 
  12910338UL,   12648192UL,   11599616UL, 4282571287UL, 4281270055UL, 2508062496UL, 
 327024407UL,  127598349UL,  162397954UL,   28180224UL,   11206400UL,   10878720UL, 
4281593867UL, 4280549135UL, 3928096534UL,  890961689UL,  256311056UL,  242089732UL, 
  75104000UL,    8191744UL,    8716032UL, 4281135110UL, 4280549124UL, 4280549129UL, 
2819948301UL,  789905168UL,  254410507UL,  256835328UL,   22347520UL,    6291200UL, 
4280739584UL, 4279890688UL, 4280090368UL, 4145544963UL, 2031222537UL,  722730761UL, 
 371326723UL,  103808768UL,    4194048UL, 4280017664UL, 4278970880UL, 4279167488UL, 
4279172864UL, 2903506688UL, 1578434304UL,  655687424UL,  152043264UL,    2031360UL, 
4279164672UL, 4278311424UL, 4278311168UL, 4278444544UL, 3171155712UL, 1963261696UL, 
 990183168UL,  319028992UL,     458496UL, 4278247424UL, 4278242304UL, 4278243328UL, 
4278243840UL, 3305168640UL, 2231432448UL, 1359019776UL,  604045056UL,      65280UL, 
4294904113UL, 3187605553UL,   16718636UL,   16764692UL,   16776969UL,   16776960UL, 
  33554178UL,  116784896UL,   13631232UL, 4292296993UL, 4294655551UL, 1375700775UL, 
  67104783UL,   16776960UL,   16776960UL,   15990528UL,   14221056UL,   12451584UL, 
4285889803UL, 4287600921UL, 3402297099UL, 1689646345UL,  380632832UL,   27655936UL, 
  10682112UL,   10551040UL,   10157824UL, 4283021060UL, 4282567943UL, 4283627275UL, 
2037181193UL,  728563458UL,  208797440UL,    7667456UL,    8388352UL,    9043712UL, 
4281650946UL, 4281261313UL, 4280743684UL, 2855271171UL, 1110441734UL,  473956096UL, 
 105512704UL,    5701376UL,    6487808UL, 4280800512UL, 4280014848UL, 4279557888UL, 
3441025792UL, 1897725696UL,  824114944UL,  254017280UL,   53608192UL,    4325120UL, 
4279882496UL, 4278964736UL, 4278439680UL, 3657942784UL, 2265571840UL, 1275919616UL, 
 520945408UL,  101842688UL,    2359040UL, 4278964736UL, 4278305792UL, 4278236928UL, 
3842224640UL, 2617361664UL, 1711529984UL,  923070464UL,  251918848UL,     524032UL, 
4278241792UL, 4278237184UL, 4278234880UL, 4076908288UL, 2936059648UL, 2046870528UL, 
1275123456UL,  520152832UL,      57088UL, 4294904859UL, 4294902044UL,  872349728UL, 
  16719385UL,   16751625UL,   16773888UL,  100663043UL,  167771904UL,   15204096UL, 
4294910995UL, 4294903326UL, 1660888088UL,  117397264UL,   33535744UL,   16771072UL, 
  16776960UL,   16252672UL,   13696768UL, 4289353221UL, 4290531848UL, 4040718602UL, 
1843235338UL,  468165888UL,   14404608UL,   13625856UL,   12647680UL,   11861760UL, 
4284245504UL, 4284905729UL, 4068445956UL, 2038009602UL, 1232575488UL,   74244096UL, 
   7335680UL,    7731968UL,    8191744UL, 4281829888UL, 4281635328UL, 4281768960UL, 
2805637120UL, 1330222080UL,  390512384UL,   21810176UL,    6087936UL,    6814464UL, 
4280591616UL, 4280067072UL, 4279999744UL, 3491211008UL, 1763683584UL,  723501568UL, 
 153539328UL,    3660544UL,    4646144UL, 4279742976UL, 4279150336UL, 4278819328UL, 
3490419712UL, 2097979392UL, 1175368960UL,  470795264UL,  102223104UL,    2936832UL, 
4278826752UL, 4278428160UL, 4278293760UL, 3573779456UL, 2349043968UL, 1543741184UL, 
 872854528UL,  201570048UL,     968448UL, 4278234368UL, 4278230272UL, 4278227968UL, 
3741355264UL, 2634060032UL, 1996526080UL, 1308663040UL,  553692928UL,      43520UL, 
4294906637UL, 4294902546UL, 2902392851UL,   16713236UL,   16720653UL,   16743425UL, 
 167751682UL,  167756800UL,   16238336UL, 4294909450UL, 4294904077UL, 3405713677UL, 
 352263180UL,  117394432UL,   16745472UL,   16754688UL,   16761344UL,   15188480UL, 
4291245826UL, 4292293378UL, 4092082434UL, 1593654278UL,  486495232UL,   15889408UL, 
  14718208UL,   14201856UL,   13421056UL, 4284955648UL, 4285940736UL, 4286662144UL, 
2508150272UL, 1317690880UL,  160591104UL,   10062336UL,   10267904UL,    9821440UL, 
4282009088UL, 4281879552UL, 4282470145UL, 2454344704UL, 1246386688UL,  726557696UL, 
  21988608UL,   22518272UL,    6209536UL, 4280509952UL, 4280181248UL, 4280180992UL, 
3609290496UL, 1763929088UL,  791568640UL,  120356608UL,    3970048UL,    4896512UL, 
4279532544UL, 4279203072UL, 4279004160UL, 3608111616UL, 2131652352UL, 1091662848UL, 
 370244864UL,   18585856UL,    3253248UL, 4278684928UL, 4278484224UL, 4278416384UL, 
3674631424UL, 2298767872UL, 1443131648UL,  872840448UL,  151224576UL,    1281280UL, 
4278225920UL, 4278223360UL, 4278221312UL, 3892343808UL, 2533388544UL, 1862298880UL, 
1325428992UL,  637567488UL,      33280UL, 4294906885UL, 4294902539UL, 4261347341UL, 
 989790221UL,   16717321UL,   16720901UL,  167730946UL,  201292800UL,   16746240UL, 
4294908930UL, 4294906115UL, 4294904838UL, 1526664966UL,  201271040UL,   16725504UL, 
  16736768UL,   16742912UL,   16416512UL, 4291239424UL, 4292679424UL, 4075297024UL, 
2281186048UL,  536815360UL,   33502976UL,   15751680UL,   15168512UL,   14385664UL, 
4285539072UL, 4286391296UL, 4287047168UL, 2375100672UL, 1067462400UL,  212153856UL, 
  10637824UL,   10973696UL,   11505408UL, 4282264320UL, 4282263808UL, 4282656512UL, 
2723229184UL, 1414804480UL,  777665536UL,  107104768UL,    7432704UL,    7640320UL, 
4280561408UL, 4280235008UL, 4280364800UL, 3257348352UL, 1546532352UL,  791624192UL, 
 372457728UL,   20866816UL,    4623616UL, 4279454208UL, 4279191296UL, 4279321600UL, 
3658760704UL, 2215855104UL, 1008154880UL,  387399168UL,   18964224UL,    3373312UL, 
4278672896UL, 4278473728UL, 4278604032UL, 3741797888UL, 2349288448UL, 1309231616UL, 
 856248064UL,  117854464UL,    1532928UL, 4278215168UL, 4278214400UL, 4278212864UL, 
3942668032UL, 2634045184UL, 1627410944UL, 1224756224UL,  687888128UL,      23552UL, 
4294907392UL, 4294903556UL, 4294901766UL, 2516516870UL,  335479049UL,   67048964UL, 
 117383426UL,  167723520UL,   16734464UL, 4294906624UL, 4294904576UL, 4294904832UL, 
2650737664UL,  603918080UL,   16718080UL,   16722176UL,   16730368UL,   16732672UL, 
4291760384UL, 4292677120UL, 4125756160UL, 2599751168UL,  939463424UL,   33494784UL, 
  16722688UL,   15942144UL,   15225088UL, 4286386944UL, 4286516736UL, 4286909952UL, 
2442597120UL, 1286018816UL,  330307072UL,   11806208UL,   11812608UL,   12408320UL, 
4282849024UL, 4282848768UL, 4283307520UL, 2690062080UL, 1415452928UL,  661200640UL, 
 107946752UL,    8141312UL,    8869632UL, 4280687616UL, 4280490752UL, 4281014784UL, 
2754682368UL, 1580473088UL,  825629440UL,  423239424UL,   21771776UL,    5724416UL, 
4279508224UL, 4279312640UL, 4279443712UL, 3356892928UL, 1997938432UL,  974593024UL, 
 370547712UL,  237252864UL,    2906624UL, 4278793728UL, 4278464768UL, 4278595328UL, 
3741921024UL, 2399875328UL, 1376465664UL,  722217216UL,  151725568UL,    1787392UL, 
4278205440UL, 4278204928UL, 4278204672UL, 3976214784UL, 2634037760UL, 1577072896UL, 
 973091072UL,  654324480UL,      14592UL, 4294904576UL, 4294904064UL, 4294901764UL, 
3640591362UL, 1610550017UL,  520031744UL,  134156032UL,  117379328UL,   16721664UL, 
4294903552UL, 4294902016UL, 4294901760UL, 3053387776UL, 1258225920UL,  117375744UL, 
  16716544UL,   16718592UL,   16721408UL, 4292281856UL, 4292871168UL, 4159112192UL, 
2867659776UL, 1509884928UL,  385811968UL,   16716032UL,   16718592UL,   16065536UL, 
4287170048UL, 4287366656UL, 4287890944UL, 2493318912UL, 1588004608UL,  834079744UL, 
  62916352UL,   12719872UL,   13116416UL, 4283369728UL, 4283303424UL, 4283565568UL, 
2623144960UL, 1331627776UL,  963776000UL,  326700032UL,    8655616UL,    9708544UL, 
4281208064UL, 4281207808UL, 4281601536UL, 2822311424UL, 1597770752UL,  876547072UL, 
 507973888UL,   22286080UL,    6563584UL, 4279504384UL, 4279505152UL, 4028174080UL, 
2719747840UL, 1629425408UL, 1042484992UL,  522652672UL,  237702912UL,    4137984UL, 
4278783744UL, 4278588160UL, 4278652416UL, 3439791872UL, 2131300096UL, 1275793664UL, 
 688656128UL,  185273856UL,    1453568UL, 4278197248UL, 4278196992UL, 4278196480UL, 
4026538240UL, 2684361472UL, 1627397120UL,  973085440UL,  503322368UL,       7936UL, 
4294901760UL, 4294901760UL, 4294901760UL, 4211015680UL, 2768175104UL, 1375666176UL, 
 620691456UL,  201261056UL,   16711680UL, 4294901760UL, 4294901760UL, 4294901760UL, 
3305046016UL, 1996423168UL,  872349696UL,  268369920UL,   16711680UL,   16711680UL, 
4292476928UL, 4292476928UL, 3857121280UL, 2917597184UL, 2012151808UL, 1207435264UL, 
 351993856UL,   16580608UL,   16580608UL, 4287758336UL, 4287692800UL, 4288479232UL, 
2460745728UL, 1840185344UL, 1387593728UL,  667025408UL,   63569920UL,   13565952UL, 
4284219392UL, 4284088320UL, 4284743680UL, 3077636096UL, 1551171584UL, 1316552704UL, 
 880934912UL,  244121600UL,    9764864UL, 4281597952UL, 4281532416UL, 4282253312UL, 
2688679936UL, 1682178048UL,  877002752UL,  793837568UL,  391708672UL,    6684672UL, 
4279828480UL, 4279435264UL, 4280156160UL, 2636055552UL, 1646658560UL, 1042678016UL, 
 472580096UL,  456720384UL,    4325376UL, 4278779904UL, 4278321152UL, 4278452224UL, 
3674800128UL, 1628112384UL, 1175389696UL,  638780416UL,  286720000UL,    2359296UL, 
4278190080UL, 4278190080UL, 4278190080UL, 3288334336UL, 2298478592UL, 1509949440UL, 
 822083584UL,  369098752UL,          0UL,
};

// 600x600x1, CMY  - Plain Normal, Color Pen Only

uint32_t ulMapCROSSBOW_CMY_6x6x1[ 9 * 9 * 9 ] =
{
4294967040UL, 2969566976UL, 1492844288UL,  886243072UL,  583073536UL,  347143936UL, 
 178716416UL,   44367616UL,   11075328UL, 4292280064UL, 3166895872UL, 1455881984UL, 
 785055488UL,  482148096UL,  280035072UL,  111607552UL,   11075328UL,   10551040UL, 
4285464320UL, 4285857536UL, 1717501696UL,  812973824UL,  344391424UL,  110034688UL, 
  43974400UL,    9895680UL,    9895680UL, 4282449664UL, 4282449664UL, 3896704768UL, 
1279065856UL,  541261568UL,  207814400UL,  107544320UL,    6881024UL,    7143168UL, 
4281006592UL, 4280745728UL, 4280745728UL, 2687041280UL, 1110638336UL,  439418624UL, 
 171769600UL,   72023808UL,    5570304UL, 4279691776UL, 4279566080UL, 4279172864UL, 
3759210240UL, 1780023040UL,  673251072UL,  270466816UL,  103481088UL,    3997440UL, 
4278902272UL, 4278775296UL, 4278517504UL, 3859218176UL, 2148073216UL, 1074593536UL, 
 370343680UL,  169148160UL,    2424576UL, 4278507520UL, 4278378496UL, 4278382080UL, 
3926058496UL, 2550329344UL, 1476722432UL,  671416064UL,  168492800UL,    1113856UL, 
4278247424UL, 4278246912UL, 4278246400UL, 4026587136UL, 2885737472UL, 1811998208UL, 
1107359744UL,  503381760UL,      65280UL, 4294959616UL, 2634007552UL, 1325399808UL, 
 620756736UL,  218103552UL,   82378496UL,   14352128UL,   13434624UL,   12779264UL, 
4291092480UL, 4294967040UL, 2499477248UL,  988872448UL,  316079872UL,   80019200UL, 
  12386048UL,   11599616UL,   10682112UL, 4285464320UL, 4286119680UL, 2929524480UL, 
1318518528UL,  546504448UL,  177274624UL,    9240320UL,    9240320UL,    9502464UL, 
4282447360UL, 4282056448UL, 4064870144UL, 1716846336UL,  777715456UL,  274661120UL, 
  39911168UL,    6618880UL,    7012096UL, 4280872448UL, 4280352512UL, 4280483584UL, 
2351628032UL, 1144192768UL,  439549696UL,  138215168UL,    4652800UL,    5177088UL, 
4279689216UL, 4279037440UL, 4279169024UL, 3121807104UL, 1578434304UL,  706543360UL, 
 270597888UL,   36241152UL,    3473152UL, 4278768640UL, 4278376448UL, 4278507008UL, 
3255229440UL, 1946610176UL, 1007351808UL,  437189632UL,  135331584UL,    2031360UL, 
4278373888UL, 4278237696UL, 4278237696UL, 3321937920UL, 2147534848UL, 1342230528UL, 
 637720576UL,  201646080UL,     720640UL, 4278242816UL, 4278237184UL, 4278237696UL, 
3623926272UL, 2550184960UL, 1644216832UL,  973131264UL,  402707968UL,      56832UL, 
4294931968UL, 3573511168UL, 1224696832UL,  452972544UL,   83885824UL,   83885824UL, 
  48955136UL,   13696768UL,   12779264UL, 4294934016UL, 4294944768UL, 2499783168UL, 
 922736128UL,  184549120UL,   14483200UL,   13041408UL,   12123904UL,   11075328UL, 
4284773376UL, 4287800320UL, 2963450880UL, 1788658176UL,  546629120UL,  109641472UL, 
   8716032UL,    8716032UL,    8584960UL, 4282427904UL, 4282564096UL, 4132490240UL, 
1952757760UL,  777964032UL,  274652160UL,   39905792UL,    6881024UL,    7274240UL, 
4280729600UL, 4280470016UL, 4280473600UL, 2385168384UL, 1077071872UL,  406246400UL, 
 104649728UL,    4644352UL,    5307392UL, 4279549952UL, 4279158272UL, 4279156736UL, 
2786245120UL, 1444464128UL,  639420928UL,  237161984UL,   36361216UL,    3595264UL, 
4278763008UL, 4278500352UL, 4278366208UL, 2919671808UL, 1778955264UL,  906674176UL, 
 403489280UL,  135581184UL,    2149888UL, 4278369280UL, 4278233088UL, 4227898880UL, 
3019939328UL, 1979753472UL, 1275244032UL,  637711360UL,  201635840UL,     838144UL, 
4278237184UL, 4278232576UL, 4093680640UL, 3187710976UL, 2214632960UL, 1509990400UL, 
 906012672UL,  369142784UL,      43008UL, 4294918656UL, 4294917632UL, 1224684032UL, 
 419378176UL,  150964736UL,  117426176UL,   82235392UL,   47505408UL,   13037568UL, 
4294920192UL, 4294919168UL, 2231324160UL,  855597056UL,  184519168UL,   15643136UL, 
  14077440UL,   12770816UL,   11726848UL, 4287646720UL, 4289745920UL, 2863558656UL, 
1790342144UL,  581991936UL,   44340736UL,   10400768UL,    9881600UL,    9888768UL, 
4282140672UL, 4282536448UL, 3730992640UL, 1851942400UL, 1147432960UL,  241209344UL, 
  39888896UL,    6864896UL,    6872576UL, 4280577536UL, 4280448000UL, 4280975872UL, 
2519758336UL, 1211919360UL,  440172544UL,  105026048UL,    4894208UL,    5687808UL, 
4279667712UL, 4279406592UL, 4279534592UL, 2887025152UL, 1444707840UL,  639665152UL, 
 203723264UL,   36610048UL,    3847168UL, 4278884352UL, 4278620672UL, 4278617088UL, 
2819127808UL, 1644854272UL,  906789888UL,  403736576UL,  102274048UL,    2400256UL, 
4278361088UL, 4278224896UL, 4278222848UL, 2818733568UL, 1812231680UL, 1208253440UL, 
 604275712UL,  201754624UL,    1085952UL, 4278228992UL, 4278225408UL, 4160782848UL, 
2818603520UL, 1979742720UL, 1476425216UL,  939556352UL,  402686976UL,      33280UL, 
4294912512UL, 4294910976UL, 2365529600UL,  251597824UL,  150939648UL,  184508416UL, 
 116685312UL,   48140800UL,   13674496UL, 4294323712UL, 4294910976UL, 2935956992UL, 
 822029312UL,  184497664UL,   16735232UL,   14711296UL,   13275648UL,   12494848UL, 
4289342464UL, 4290783232UL, 3502254080UL, 1456092672UL,  549732352UL,   45635072UL, 
  11562496UL,   11045376UL,   10790912UL, 4282919424UL, 4283837440UL, 4033360384UL, 
1751663616UL, 1148078080UL,  309219840UL,    7365120UL,    7633408UL,    7775232UL, 
4280430080UL, 4280431616UL, 4281351680UL, 2285650432UL, 1212170752UL,  641878528UL, 
 105144320UL,   38564864UL,    5412864UL, 4279388672UL, 4279390720UL, 4279652352UL, 
3021754368UL, 1512066560UL,  774261760UL,  237656576UL,    3304960UL,    4230656UL, 
4278740480UL, 4278739968UL, 4278868992UL, 3020707840UL, 1712216064UL,  907171328UL, 
 403987456UL,   68971520UL,    2653696UL, 4278349312UL, 4278217216UL, 4278346752UL, 
2953075712UL, 1812224000UL, 1174689792UL,  637951488UL,  201876480UL,    1338368UL, 
4278219776UL, 4278218240UL, 4227885568UL, 2986370048UL, 1845518336UL, 1409309696UL, 
 973102080UL,  436233216UL,      25600UL, 4294908416UL, 4294906880UL, 3573485568UL, 
 788466176UL,  184488960UL,  184492032UL,   83836928UL,   48912896UL,   14446080UL, 
4293793792UL, 4294904320UL, 3539931136UL, 1258229760UL,  150935040UL,   16721408UL, 
  15353344UL,   13523968UL,   13134848UL, 4289206272UL, 4290383872UL, 3737260032UL, 
1656754688UL,  517348352UL,   46671872UL,   12207104UL,   11819520UL,   11561472UL, 
4283701248UL, 4284880896UL, 3932953088UL, 1853103104UL,  913974272UL,  276703744UL, 
   8141824UL,    8541184UL,    8809984UL, 4280556032UL, 4281212928UL, 3996917760UL, 
2084839936UL,  977677312UL,  709504000UL,  206452736UL,    5656064UL,    6187520UL, 
4279376896UL, 4279510016UL, 4279903744UL, 2988582912UL, 1478896128UL,  707274752UL, 
 405417984UL,   36850176UL,    4221440UL, 4278859264UL, 4278860288UL, 4278989824UL, 
3121493504UL, 1779578368UL,  840314368UL,  437793280UL,  102778368UL,    2908160UL, 
4278471168UL, 4278339072UL, 4278469632UL, 3053732352UL, 1845903360UL, 1107704320UL, 
 638073856UL,  201998848UL,    1462784UL, 4278211584UL, 4278211072UL, 4227878400UL, 
3087026688UL, 1946175488UL, 1207976960UL,  905986048UL,  469779968UL,      18944UL, 
4294904832UL, 4294903808UL, 4177463296UL, 1761544192UL,  520030208UL,  117378560UL, 
 117380096UL,   83832320UL,   15091200UL, 4293135360UL, 4294903296UL, 3640591360UL, 
1828652032UL,  419366400UL,   16716288UL,   16523264UL,   14037504UL,   13517824UL, 
4289465344UL, 4289988608UL, 3736469504UL, 1925187072UL,  684591616UL,   80744960UL, 
  12853760UL,   12071424UL,   11944448UL, 4284484608UL, 4285008384UL, 3765176320UL, 
1953892352UL, 1014894592UL,  344462336UL,    8788992UL,    9056256UL,    9716736UL, 
4281208320UL, 4281995264UL, 3728871424UL, 2118651904UL, 1112412160UL,  575936512UL, 
 173415424UL,    6040576UL,    6964224UL, 4279373824UL, 4280030720UL, 4280292352UL, 
2217088000UL, 1244403200UL,  573185024UL,  405806080UL,  104475136UL,    4604928UL, 
4278850048UL, 4278983680UL, 4279114240UL, 3121748480UL, 1813256704UL,  873994752UL, 
 404101120UL,  270541824UL,    2769408UL, 4278461440UL, 4278461952UL, 4278461440UL, 
3087410176UL, 1913005568UL, 1141384192UL,  537665536UL,  235807232UL,    1587712UL, 
4278202368UL, 4278202368UL, 4026544128UL, 3053465600UL, 1946169344UL, 1207971840UL, 
 704653824UL,  469772800UL,      12288UL, 4294706176UL, 4294902272UL, 3875472384UL, 
2197750784UL, 1124008960UL,  352257024UL,  117376512UL,   50268672UL,   16720384UL, 
4292609024UL, 4293525504UL, 3605659648UL, 2096365568UL,  989790208UL,  218038784UL, 
  15993856UL,   15078912UL,   14163968UL, 4289594368UL, 4289724928UL, 3467771904UL, 
2092433408UL, 1187381760UL,  315228672UL,   12848128UL,   12588032UL,   12197888UL, 
4285531648UL, 4285400064UL, 3631350784UL, 2054553600UL, 1283458048UL,  612894208UL, 
 110233600UL,    9310720UL,    9838592UL, 4282386432UL, 4282122752UL, 3594650112UL, 
2118647808UL, 1145962496UL,  710411776UL,  274729472UL,    6557696UL,    7217664UL, 
4280027648UL, 4280420864UL, 3324380672UL, 2116683776UL, 1244661248UL,  607127040UL, 
 372771840UL,  104861696UL,    4989952UL, 4278979584UL, 4279110656UL, 4279372800UL, 
2887125504UL, 1343753216UL,  706481152UL,  303697408UL,  237113344UL,    2892288UL, 
4278454784UL, 4278455808UL, 4278586880UL, 2986741248UL, 1913130496UL, 1141509632UL, 
 537660928UL,  201984512UL,    1449984UL, 4278195712UL, 4278195712UL, 4093646336UL, 
3019905024UL, 1946163200UL, 1207966208UL,  637540352UL,  335549952UL,       7680UL, 
4294901760UL, 4294901760UL, 4244111360UL, 3036413952UL, 1862205440UL, 1056899072UL, 
 520028160UL,  218038272UL,   16711680UL, 4292608000UL, 4291690496UL, 3603824640UL, 
2396258304UL, 1524498432UL,  719716352UL,  283770880UL,   49152000UL,   15597568UL, 
4289462272UL, 4289069056UL, 3400007680UL, 2225995776UL, 1555300352UL,  918028288UL, 
 314179584UL,   12451840UL,   12582912UL, 4285792256UL, 4285530112UL, 3497394176UL, 
2088370176UL, 1551892480UL, 1082392576UL,  478806016UL,   76808192UL,    9961472UL, 
4283039744UL, 4282908672UL, 3595436032UL, 2287206400UL, 1246887936UL, 1012531200UL, 
 643956736UL,  174587904UL,    7208960UL, 4280942592UL, 4280811520UL, 3459252224UL, 
2083913728UL, 1379139584UL,  708050944UL,  607911936UL,  239468544UL,    5111808UL, 
4279631872UL, 4279369728UL, 3726114816UL, 2250244096UL, 1310457856UL,  706609152UL, 
 270532608UL,  270925824UL,    3014656UL, 4278714368UL, 4278452224UL, 4278452224UL, 
2819227648UL, 1678639104UL,  738984448UL,  336331776UL,   68157440UL,    1835008UL, 
4278190080UL, 4278190080UL, 3456106496UL, 2483027968UL, 1744830464UL, 1174405120UL, 
 637534208UL,  268435456UL,          0UL, 
};

// 600x600x1, KCMY - Plain Normal, Both Pens

uint32_t ulMapCROSSBOW_KCMY_6x6x1[ 9 * 9 * 9 ] =
{
1413633791UL,   77528918UL,   78053164UL,   44105496UL,   44105488UL,   43974410UL, 
  43974404UL,   10682114UL,   11075328UL, 4279697248UL,  303628118UL,  108461864UL, 
  43974422UL,   44105486UL,   44105480UL,   10551044UL,   11075328UL,   10551040UL, 
4279821356UL, 4161863474UL,  302710570UL,   71892758UL,   41090826UL,    9109250UL, 
  10419970UL,    9895680UL,    9895680UL, 4279821844UL, 4279303960UL, 2919825182UL, 
 403373850UL,   69664526UL,  140443394UL,  107544320UL,    6881024UL,    7143168UL, 
4279690762UL, 4279435018UL, 4278648592UL, 2114387730UL,  504299282UL,  136249098UL, 
 171769600UL,   72023808UL,    5570304UL, 4279559682UL, 4279435010UL, 4278779652UL, 
3590782726UL, 1577910022UL,  504692486UL,  270466816UL,  103481088UL,    3997440UL, 
4278902272UL, 4278775296UL, 4278517504UL, 3859218176UL, 2148073216UL, 1074593536UL, 
 370343680UL,  169148160UL,    2424576UL, 4278507520UL, 4278378496UL, 4278382080UL, 
3926058496UL, 2550329344UL, 1476722432UL,  671416064UL,  168492800UL,    1113856UL, 
4278247424UL, 4278246912UL, 4278246400UL, 4026587136UL, 2885737472UL, 1811998208UL, 
1107359744UL,  503381760UL,      65280UL, 4294907494UL,  218051656UL,   83885862UL, 
  50331410UL,   50331398UL,   15007490UL,   14352128UL,   13434624UL,   12779264UL, 
4281486922UL, 1514822238UL,  680450102UL,  214236950UL,   80281352UL,   12648194UL, 
  12386048UL,   11599616UL,   10682112UL, 4280333352UL, 4280338476UL, 1110491190UL, 
 543751960UL,  310705928UL,  177274624UL,    9240320UL,    9240320UL,    9502464UL, 
4280078356UL, 4279692818UL, 3222732568UL,  807337756UL,  373489420UL,  274661120UL, 
  39911168UL,    6618880UL,    7012096UL, 4279819784UL, 4279563270UL, 4279566088UL, 
1947401996UL,  706412302UL,  338493188UL,  138215168UL,    4652800UL,    5177088UL, 
4279557634UL, 4279037440UL, 4279169024UL, 3121807104UL, 1578434304UL,  706543360UL, 
 270597888UL,   36241152UL,    3473152UL, 4278768640UL, 4278376448UL, 4278507008UL, 
3255229440UL, 1946610176UL, 1007351808UL,  437189632UL,  135331584UL,    2031360UL, 
4278373888UL, 4278237696UL, 4278237696UL, 3321937920UL, 2147534848UL, 1342230528UL, 
 637720576UL,  201646080UL,     720640UL, 4278242816UL, 4278237184UL, 4278237696UL, 
3623926272UL, 2550184960UL, 1644216832UL,  973131264UL,  402707968UL,      56832UL, 
4294906418UL, 1862209076UL,  150938144UL,   50313228UL,   16776962UL,   16776962UL, 
  48955136UL,   13696768UL,   12779264UL, 4289471022UL, 2829594174UL,  785400884UL, 
 352302608UL,  184549120UL,   14483200UL,   13041408UL,   12123904UL,   11075328UL, 
4281746456UL, 4283062820UL, 1717068326UL, 1182178834UL,  546629120UL,  109641472UL, 
   8716032UL,    8716032UL,    8584960UL, 4280848908UL, 4280853518UL, 3492455956UL, 
1413781008UL,  744278018UL,  274652160UL,   39905792UL,    6881024UL,    7274240UL, 
4280466434UL, 4280206850UL, 4280210434UL, 2351482370UL, 1009700354UL,  406246400UL, 
 104649728UL,    4644352UL,    5307392UL, 4279549952UL, 4279158272UL, 4279156736UL, 
2786245120UL, 1444464128UL,  639420928UL,  237161984UL,   36361216UL,    3595264UL, 
4278763008UL, 4278500352UL, 4278366208UL, 2919671808UL, 1778955264UL,  906674176UL, 
 403489280UL,  135581184UL,    2149888UL, 4278369280UL, 4278233088UL, 4227898880UL, 
3019939328UL, 1979753472UL, 1275244032UL,  637711360UL,  201635840UL,     838144UL, 
4278237184UL, 4278232576UL, 4093680640UL, 3187710976UL, 2214632960UL, 1509990400UL, 
 906012672UL,  369142784UL,      43008UL, 4294906392UL, 4294904346UL,  520029718UL, 
  50273804UL,   16745476UL,  117426176UL,   82235392UL,   47505408UL,   13037568UL, 
4292090392UL, 4294905882UL, 1392450074UL,  318717968UL,  184519168UL,   15643136UL, 
  14077440UL,   12770816UL,   11726848UL, 4285672976UL, 4286982678UL, 2156152342UL, 
1217679890UL,  581991936UL,   44340736UL,   10400768UL,    9881600UL,    9888768UL, 
4282009090UL, 4282273282UL, 3259520014UL, 1851942400UL, 1147432960UL,  241209344UL, 
  39888896UL,    6864896UL,    6872576UL, 4280577536UL, 4280448000UL, 4280975872UL, 
2519758336UL, 1211919360UL,  440172544UL,  105026048UL,    4894208UL,    5687808UL, 
4279667712UL, 4279406592UL, 4279534592UL, 2887025152UL, 1444707840UL,  639665152UL, 
 203723264UL,   36610048UL,    3847168UL, 4278884352UL, 4278620672UL, 4278617088UL, 
2819127808UL, 1644854272UL,  906789888UL,  403736576UL,  102274048UL,    2400256UL, 
4278361088UL, 4278224896UL, 4278222848UL, 2818733568UL, 1812231680UL, 1208253440UL, 
 604275712UL,  201754624UL,    1085952UL, 4278228992UL, 4278225408UL, 4160782848UL, 
2818603520UL, 1979742720UL, 1476425216UL,  939556352UL,  402686976UL,      33280UL, 
4294905868UL, 4294903822UL, 1929315342UL,   50268166UL,  117384706UL,  184508416UL, 
 116685312UL,   48140800UL,   13674496UL, 4292876300UL, 4294905866UL, 2566852620UL, 
 553589258UL,  184497664UL,   16735232UL,   14711296UL,   13275648UL,   12494848UL, 
4288947716UL, 4290520066UL, 3468699650UL, 1355034628UL,  549732352UL,   45635072UL, 
  11562496UL,   11045376UL,   10790912UL, 4282919424UL, 4283837440UL, 4033360384UL, 
1751663616UL, 1148078080UL,  309219840UL,    7365120UL,    7633408UL,    7775232UL, 
4280430080UL, 4280431616UL, 4281351680UL, 2285650432UL, 1212170752UL,  641878528UL, 
 105144320UL,   38564864UL,    5412864UL, 4279388672UL, 4279390720UL, 4279652352UL, 
3021754368UL, 1512066560UL,  774261760UL,  237656576UL,    3304960UL,    4230656UL, 
4278740480UL, 4278739968UL, 4278868992UL, 3020707840UL, 1712216064UL,  907171328UL, 
 403987456UL,   68971520UL,    2653696UL, 4278349312UL, 4278217216UL, 4278346752UL, 
2953075712UL, 1812224000UL, 1174689792UL,  637951488UL,  201876480UL,    1338368UL, 
4278219776UL, 4278218240UL, 4227885568UL, 2986370048UL, 1845518336UL, 1409309696UL, 
 973102080UL,  436233216UL,      25600UL, 4294905860UL, 4294904326UL, 3372155910UL, 
 754911234UL,  184488960UL,  184492032UL,   83836928UL,   48912896UL,   14446080UL, 
4293530626UL, 4294904322UL, 3472820740UL, 1258229760UL,  150935040UL,   16721408UL, 
  15353344UL,   13523968UL,   13134848UL, 4289206272UL, 4290383872UL, 3737260032UL, 
1656754688UL,  517348352UL,   46671872UL,   12207104UL,   11819520UL,   11561472UL, 
4283701248UL, 4284880896UL, 3932953088UL, 1853103104UL,  913974272UL,  276703744UL, 
   8141824UL,    8541184UL,    8809984UL, 4280556032UL, 4281212928UL, 3996917760UL, 
2084839936UL,  977677312UL,  709504000UL,  206452736UL,    5656064UL,    6187520UL, 
4279376896UL, 4279510016UL, 4279903744UL, 2988582912UL, 1478896128UL,  707274752UL, 
 405417984UL,   36850176UL,    4221440UL, 4278859264UL, 4278860288UL, 4278989824UL, 
3121493504UL, 1779578368UL,  840314368UL,  437793280UL,  102778368UL,    2908160UL, 
4278471168UL, 4278339072UL, 4278469632UL, 3053732352UL, 1845903360UL, 1107704320UL, 
 638073856UL,  201998848UL,    1462784UL, 4278211584UL, 4278211072UL, 4227878400UL, 
3087026688UL, 1946175488UL, 1207976960UL,  905986048UL,  469779968UL,      18944UL, 
4294904832UL, 4294903808UL, 4177463298UL, 1761544192UL,  520030208UL,  117378560UL, 
 117380096UL,   83832320UL,   15091200UL, 4293135360UL, 4294903296UL, 3640591360UL, 
1828652032UL,  419366400UL,   16716288UL,   16523264UL,   14037504UL,   13517824UL, 
4289465344UL, 4289988608UL, 3736469504UL, 1925187072UL,  684591616UL,   80744960UL, 
  12853760UL,   12071424UL,   11944448UL, 4284484608UL, 4285008384UL, 3765176320UL, 
1953892352UL, 1014894592UL,  344462336UL,    8788992UL,    9056256UL,    9716736UL, 
4281208320UL, 4281995264UL, 3728871424UL, 2118651904UL, 1112412160UL,  575936512UL, 
 173415424UL,    6040576UL,    6964224UL, 4279373824UL, 4279899650UL, 4280292352UL, 
2217088000UL, 1244403200UL,  573185024UL,  405806080UL,  104475136UL,    4604928UL, 
4278850048UL, 4278983680UL, 4279114240UL, 3121748480UL, 1813256704UL,  873994752UL, 
 404101120UL,  270541824UL,    2769408UL, 4278461440UL, 4278461952UL, 4278461440UL, 
3087410176UL, 1913005568UL, 1141384192UL,  537665536UL,  235807232UL,    1587712UL, 
4278202368UL, 4278202368UL, 4026544128UL, 3053465600UL, 1946169344UL, 1207971840UL, 
 704653824UL,  469772800UL,      12288UL, 4294706176UL, 4294902272UL, 3875472384UL, 
2197750784UL, 1124008960UL,  352257024UL,  117376512UL,   50268672UL,   16720384UL, 
4292609024UL, 4293525504UL, 3605659648UL, 2096365568UL,  989790208UL,  218038784UL, 
  15993856UL,   15078912UL,   14163968UL, 4289594368UL, 4289724928UL, 3467771904UL, 
2092433408UL, 1187381760UL,  315228672UL,   12848128UL,   12588032UL,   12197888UL, 
4285531648UL, 4285400064UL, 3631350784UL, 2054553600UL, 1283458048UL,  612894208UL, 
 110233600UL,    9310720UL,    9838592UL, 4282386432UL, 4282122752UL, 3594650112UL, 
2118647808UL, 1145962496UL,  710411776UL,  274729472UL,    6557696UL,    7217664UL, 
4280027648UL, 4280420864UL, 3324380672UL, 2116683776UL, 1244661248UL,  607127040UL, 
 372771840UL,  104861696UL,    4989952UL, 4278979584UL, 4279110656UL, 4279372800UL, 
2887125504UL, 1343753216UL,  706481152UL,  303697408UL,  237113344UL,    2892288UL, 
4278454784UL, 4278455808UL, 4278586880UL, 2986741248UL, 1913130496UL, 1141509632UL, 
 537660928UL,  201984512UL,    1449984UL, 4278195712UL, 4278195712UL, 4093646336UL, 
3019905024UL, 1946163200UL, 1207966208UL,  637540352UL,  335549952UL,       7680UL, 
4294901760UL, 4294901760UL, 4244111360UL, 3036413952UL, 1862205440UL, 1056899072UL, 
 520028160UL,  218038272UL,   16711680UL, 4292608000UL, 4291690496UL, 3603824640UL, 
2396258304UL, 1524498432UL,  719716352UL,  283770880UL,   49152000UL,   15597568UL, 
4289462272UL, 4289069056UL, 3400007680UL, 2225995776UL, 1555300352UL,  918028288UL, 
 314179584UL,   12451840UL,   12582912UL, 4285792256UL, 4285530112UL, 3497394176UL, 
2088370176UL, 1551892480UL, 1082392576UL,  478806016UL,   76808192UL,    9961472UL, 
4283039744UL, 4282908672UL, 3595436032UL, 2287206400UL, 1246887936UL, 1012531200UL, 
 643956736UL,  174587904UL,    7208960UL, 4280942592UL, 4280811520UL, 3459252224UL, 
2083913728UL, 1379139584UL,  708050944UL,  607911936UL,  239468544UL,    5111808UL, 
4279631872UL, 4279369728UL, 3726114816UL, 2250244096UL, 1310457856UL,  706609152UL, 
 270532608UL,  270925824UL,    3014656UL, 4278714368UL, 4278452224UL, 4278452224UL, 
2819227648UL, 1678639104UL,  738984448UL,  336331776UL,   68157440UL,    1835008UL, 
4278190080UL, 4278190080UL, 3456106496UL, 2483027968UL, 1744830464UL, 1174405120UL, 
 637534208UL,  268435456UL,          0UL, 
};

APDK_END_NAMESPACE

#endif
