#ifndef INC_AST_hpp__
#define INC_AST_hpp__

/**
 * <b>SOFTWARE RIGHTS</b>
 * <p>
 * ANTLR 2.6.0 MageLang Insitute, 1999
 * <p>
 * We reserve no legal rights to the ANTLR--it is fully in the
 * public domain. An individual or company may do whatever
 * they wish with source code distributed with ANTLR or the
 * code generated by ANTLR, including the incorporation of
 * ANTLR, or its output, into commerical software.
 * <p>
 * We encourage users to develop software with ANTLR. However,
 * we do ask that credit is given to us for developing
 * ANTLR. By "credit", we mean that if you use ANTLR or
 * incorporate any source code into one of your programs
 * (commercial product, research project, or otherwise) that
 * you acknowledge this fact somewhere in the documentation,
 * research report, etc... If you like ANTLR and have
 * developed a nice tool with the output, please mention that
 * you developed it using ANTLR. In addition, we ask that the
 * headers remain intact in our source code. As long as these
 * guidelines are kept, we expect to continue enhancing this
 * system and expect to make other tools available as they are
 * completed.
 * <p>
 * The ANTLR gang:
 * @version ANTLR 2.6.0 MageLang Insitute, 1999
 * @author Terence Parr, <a href=http://www.MageLang.com>MageLang Institute</a>
 * @author <br>John Lilley, <a href=http://www.Empathy.com>Empathy Software</a>
 * @author <br><a href="mailto:pete@yamuna.demon.co.uk">Pete Wells</a>
 */

#include "antlr/config.hpp"
#include "antlr/ASTRefCount.hpp"
#include "antlr/Token.hpp"
#include <vector>
#include <string>

ANTLR_BEGIN_NAMESPACE(antlr)

struct ASTRef;

class AST {
public:
	AST() : ref(0) {}
	virtual ~AST() {}

	virtual void addChild(RefAST c)=0;

	virtual bool equals(RefAST t) const=0;
	virtual bool equalsList(RefAST t) const=0;
	virtual bool equalsListPartial(RefAST t) const=0;
	virtual bool equalsTree(RefAST t) const=0;
	virtual bool equalsTreePartial(RefAST t) const=0;

	virtual ANTLR_USE_NAMESPACE(std)vector<RefAST> findAll(RefAST t)=0;
	virtual ANTLR_USE_NAMESPACE(std)vector<RefAST> findAllPartial(RefAST t)=0;

	/** Get the first child of this node; null if no children */
	virtual RefAST getFirstChild() const=0;
	/** Get  the next sibling in line after this one */
	virtual RefAST getNextSibling() const=0;

	/** Get the token text for this node */
	virtual ANTLR_USE_NAMESPACE(std)string getText() const=0;
	/** Get the token type for this node */
	virtual int getType() const=0;

	virtual void initialize(int t,const ANTLR_USE_NAMESPACE(std)string& txt)=0;
	virtual void initialize(RefAST t)=0;
	virtual void initialize(RefToken t)=0;

	/** Set the first child of a node. */
	virtual void setFirstChild(RefAST c)=0;
	/** Set the next sibling after this one. */
	virtual void setNextSibling(RefAST n)=0;

	/** Set the token text for this node */
	virtual void setText(const ANTLR_USE_NAMESPACE(std)string& txt)=0;
	/** Set the token type for this node */
	virtual void setType(int type)=0;

	virtual ANTLR_USE_NAMESPACE(std)string toString() const=0;
	virtual ANTLR_USE_NAMESPACE(std)string toStringList() const=0;
	virtual ANTLR_USE_NAMESPACE(std)string toStringTree() const=0;
private:
	friend struct ASTRef;
	ASTRef* ref;

	AST(const AST& other);
	AST(RefAST other);
	AST& operator=(const AST& other);
	AST& operator=(RefAST other);
};

extern RefAST nullAST;
extern AST* const nullASTptr;

#ifdef NEEDS_OPERATOR_LESS_THAN
inline operator<(RefAST l,RefAST r); // {return true;}
#endif

ANTLR_END_NAMESPACE

#endif //INC_AST_hpp__
