/* This file is part of the KDE project
   Copyright 2004 Ariya Hidayat <ariya@kde.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/

#ifndef KSPREAD_TESTER
#define KSPREAD_TESTER

#include <qstring.h>
#include <qstringlist.h>

namespace KSpread
{

class Tester
{
public:
  Tester();
  virtual ~Tester() {;};

public:
  virtual QString name() = 0;
  virtual void run() = 0;
  unsigned count() const;
  unsigned failed() const;
  QStringList errors() const;

protected:
  void fail( const char *file, int line, const QString& msg );
  int testCount;
  QStringList errorList;
};

}

#endif // KSPREAD_TESTER
