/**
 *
 * $Header: /cvsroot/lesstif/lesstif/test/Xm/misc/test1.c,v 1.7 2001/03/16 16:28:36 amai Exp $
 * print out the translations
 *
 **/

#include <stdio.h>
#include <stdlib.h>
#include <Xm/Xm.h>
#include <Xm/TransltnsP.h>


static void
put_escaped(const char *str)
{
  int i;
  int last_was_newline = 1, got_colon = 0, ccnt = 0;

  putchar(' ');
  putchar(' ');
  putchar(' ');
  putchar(' ');
  ccnt = 4;
  for (i = 0; str[i]; i++)
  {
    if (last_was_newline)
    {
      if (str[i] == ':')
      {
	last_was_newline = 0;
	putchar(':');
        ccnt++;
	continue;
      }
      last_was_newline = 0;
    }

    switch (str[i])
    {
    case '\\':
      putchar('\\');
      putchar('\\');
      break;
    case '\t':
      putchar('\\');
      putchar('t');
      ccnt += 8;
      break;
    case '\n':
      putchar('\\');
      putchar('n');
      putchar('\\');
      putchar('\n');
      putchar(' ');
      putchar(' ');
      putchar(' ');
      putchar(' ');
      last_was_newline=1;
      ccnt = 4;
      break;
    case '\r':
      putchar('\\');
      putchar('r');
      ccnt = 0;
      break;
    case '\v':
      putchar('\\');
      putchar('v');
      break;
    case ':':
      putchar(':');
      ccnt++;
      got_colon=1;
      break;
    default:
      putchar(str[i]);
      ccnt++;
      break;
    }

    if (got_colon)
    {
      while (ccnt<30)
      {
	ccnt++;
	putchar(' ');
      }
      got_colon = 0;
    }
  }
}


int
main(int argc, char *argv[]) {

  printf("/*\n");
  printf(" * This file is generated by test/Xm/test1.c:  Do NOT edit.\n");
  printf(" */\n");
  printf("char _XmArrowB_defaultTranslations[] = \"\\\n");
  put_escaped( _XmArrowB_defaultTranslations);
  printf("\";\n\n");

  printf("char _XmBulletinB_defaultTranslations[] = \"\\\n");
  put_escaped( _XmBulletinB_defaultTranslations);
  printf("\";\n\n");

  printf("char _XmCascadeB_menubar_events[] = \"\\\n");
  put_escaped( _XmCascadeB_menubar_events);
  printf("\";\n\n");

  printf("char _XmCascadeB_p_events[] = \"\\\n");
  put_escaped( _XmCascadeB_p_events);
  printf("\";\n\n");

  printf("char _XmDrawingA_defaultTranslations[] = \"\\\n");
  put_escaped( _XmDrawingA_defaultTranslations);
  printf("\";\n\n");

  printf("char _XmDrawingA_traversalTranslations[] = \"\\\n");
  put_escaped( _XmDrawingA_traversalTranslations);
  printf("\";\n\n");

  printf("char _XmDrawnB_defaultTranslations[] = \"\\\n");
  put_escaped( _XmDrawnB_defaultTranslations);
  printf("\";\n\n");

  printf("char _XmFrame_defaultTranslations[] = \"\\\n");
  put_escaped( _XmFrame_defaultTranslations);
  printf("\";\n\n");

  printf("char _XmLabel_defaultTranslations[] = \"\\\n");
  put_escaped( _XmLabel_defaultTranslations);
  printf("\";\n\n");

  printf("char _XmLabel_menuTranslations[] = \"\\\n");
  put_escaped( _XmLabel_menuTranslations);
  printf("\";\n\n");

  printf("char _XmLabel_menu_traversal_events[] = \"\\\n");
  put_escaped( _XmLabel_menu_traversal_events);
  printf("\";\n\n");

  printf("char _XmList_ListXlations1[] = \"\\\n");
  put_escaped( _XmList_ListXlations1);
  printf("\";\n\n");

  printf("char _XmList_ListXlations2[] = \"\\\n");
  put_escaped( _XmList_ListXlations2);
  printf("\";\n\n");

  printf("char _XmManager_managerTraversalTranslations[] = \"\\\n");
  put_escaped( _XmManager_managerTraversalTranslations);
  printf("\";\n\n");

  printf("char _XmManager_defaultTranslations[] = \"\\\n");
  put_escaped( _XmManager_defaultTranslations);
  printf("\";\n\n");

  printf("char _XmMenuShell_translations [] = \"\\\n");
  put_escaped( _XmMenuShell_translations);
  printf("\";\n\n");

  printf("char _XmPrimitive_defaultTranslations[] = \"\\\n");
  put_escaped( _XmPrimitive_defaultTranslations);
  printf("\";\n\n");

  printf("char _XmPushB_defaultTranslations[] = \"\\\n");
  put_escaped( _XmPushB_defaultTranslations);
  printf("\";\n\n");

  printf("char _XmPushB_menuTranslations[] = \"\\\n");
  put_escaped( _XmPushB_menuTranslations);
  printf("\";\n\n");

  printf("char _XmRowColumn_menu_traversal_table[] = \"\\\n");
  put_escaped( _XmRowColumn_menu_traversal_table);
  printf("\";\n\n");

  printf("char _XmRowColumn_bar_table[] = \"\\\n");
  put_escaped( _XmRowColumn_bar_table);
  printf("\";\n\n");

  printf("char _XmRowColumn_option_table[] = \"\\\n");
  put_escaped( _XmRowColumn_option_table);
  printf("\";\n\n");

  printf("char _XmRowColumn_menu_table[] = \"\\\n");
  put_escaped( _XmRowColumn_menu_table);
  printf("\";\n\n");

  printf("char _XmSash_defTranslations[] = \"\\\n");
  put_escaped( _XmSash_defTranslations);
  printf("\";\n\n");

  printf("char _XmScrollBar_defaultTranslations[] = \"\\\n");
  put_escaped( _XmScrollBar_defaultTranslations);
  printf("\";\n\n");

  printf("char _XmScrolledW_ScrolledWindowXlations[] = \"\\\n");
  put_escaped( _XmScrolledW_ScrolledWindowXlations);
  printf("\";\n\n");

#if (XmVERSION == 1)
  printf("char _XmScrolledW_WorkWindowTranslationTable[] = \"\\\n");
  put_escaped( _XmScrolledW_WorkWindowTranslationTable);
  printf("\";\n\n");
  printf("char _XmScrolledW_ClipWindowTranslationTable[] = \"\\\n");
  put_escaped( _XmScrolledW_ClipWindowTranslationTable);
  printf("\";\n\n");
#else
  printf("char _XmClipWindowTranslationTable[] = \"\\\n");
  put_escaped( _XmClipWindowTranslationTable);
  printf("\";\n\n");
#endif

  printf("char _XmSelectioB_defaultTextAccelerators[] = \"\\\n");
  put_escaped( _XmSelectioB_defaultTextAccelerators);
  printf("\";\n\n");

  printf("char _XmTearOffB_overrideTranslations[] = \"\\\n");
  put_escaped( _XmTearOffB_overrideTranslations);
  printf("\";\n\n");

  printf("char _XmTextF_EventBindings1[] = \"\\\n");
  put_escaped( _XmTextF_EventBindings1);
  printf("\";\n\n");

  printf("char _XmTextF_EventBindings2[] = \"\\\n");
  put_escaped( _XmTextF_EventBindings2);
  printf("\";\n\n");

  printf("char _XmTextF_EventBindings3[] = \"\\\n");
  put_escaped( _XmTextF_EventBindings3);
  printf("\";\n\n");

  printf("char _XmTextIn_XmTextEventBindings1[] = \"\\\n");
  put_escaped( _XmTextIn_XmTextEventBindings1);
  printf("\";\n\n");

  printf("char _XmTextIn_XmTextEventBindings2[] = \"\\\n");
  put_escaped( _XmTextIn_XmTextEventBindings2);
  printf("\";\n\n");

  printf("char _XmTextIn_XmTextEventBindings3[] = \"\\\n");
  put_escaped( _XmTextIn_XmTextEventBindings3);
  printf("\";\n\n");

  printf("char _XmToggleB_defaultTranslations[] = \"\\\n");
  put_escaped( _XmToggleB_defaultTranslations);
  printf("\";\n\n");

  printf("char _XmToggleB_menuTranslations[] = \"\\\n");
  put_escaped( _XmToggleB_menuTranslations);
  printf("\";\n\n");

  printf("char _XmVirtKeys_fallbackBindingString[] = \"\\\n");
  put_escaped( _XmVirtKeys_fallbackBindingString);
  printf("\";\n\n");


  exit(0);
}
