/*
** Header file for inclusion with words_xml2latex.c
**
** Copyright (C) 2000, 2002 Robert JACOLIN
**
** This library is free software; you can redistribute it and/or
** modify it under the terms of the GNU Library General Public
** License as published by the Free Software Foundation; either
** version 2 of the License, or (at your option) any later version.
**
** This library is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
** Library General Public License for more details.
**
** To receive a copy of the GNU Library General Public License, write to the
** Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
**
*/

#ifndef __XML2LATEXPARSER_H__
#define __XML2LATEXPARSER_H__

#include <QFile>   /* for QFile class */
#include <QTextStream> /* for QTextStream class */
#include <QString>  /* for QString class */
#include "fileheader.h"
#include "document.h"

class Xml2LatexParser : public XmlParser
{
    QFile _file;
    QTextStream _out;
    /** Name of the latex file. */
    //QString  _filename;
    /** The Words document exported. */
    const KoStore* _in;

    /** Words document header. */
    //FileHeader  _header;
    /** The root class which contains one words document. */
    Document    _document;

public:
    /**
     * @param in The document from words.
     * @param fileOut Output latex filename.
     * @param config ???
     */
    Xml2LatexParser(const KoStore* in, const QString& fileOut, Config* config);

    virtual ~Xml2LatexParser() {}

    void analyze();
    void generate();

};

#endif /* __XML2LATEXPARSER_H__ */
