import re

inputFilename = 'runtime.opt.ll'
sourceFilename = r'C:/Users/chwallis/Desktop/DXILShaderPatch/runtime.c'
outputFilename = 'C:/Users/chwallis/Desktop/DXILShaderPatch/runtime.h'

source = open(sourceFilename).read()

input = open(inputFilename).read()
m = re.search(r'"nvptx"(.*?)attributes #', input, re.DOTALL)
dxil = m.group(1)

# split the string up to avoid  error C2026: string too big, trailing characters truncated
lines = dxil.splitlines()
dxil = []
count = 0
for line in lines:
    count += len(line)
    dxil.append(line)
    if count > 10000:
        dxil.append(')AAA",')
        dxil.append('R"AAA(')
        count = 0
dxil = '\n'.join(dxil)

template = """
// This file generated by compiling the following source (runtime.c) as follows:
//    clang -S -emit-llvm -target nvptr runtime.c
//    opt -S -mem2reg runtime.ll -o runtime.opt.ll
// The resulting LLVM-IR is stripped of its datalayout and replaced with one
// compatible with DXIL.

// runtime.c
#if 0 
%SOURCE%
#endif

static const char* runtimeString[] = { R"AAA(
target datalayout = "e-m:e-p:32:32-i1:32-i8:32-i16:32-i32:32-i64:64-f16:32-f32:32-f:64:64-n8:16:32:64"
target triple = "dxil-ms-dx"

%DXIL%

attributes #0 = { nounwind }
attributes #1 = { nounwind }
)AAA"
};

#include <sstream>
static std::string getRuntimeString()
{
  std::ostringstream out;
  for( size_t i=0; i < _countof(runtimeString); ++i)
    out << runtimeString[i];

  return out.str();
}
"""

output = re.sub(r'%SOURCE%', source, template)
output = re.sub(r'%DXIL%', dxil, output)
open(outputFilename, 'w').write(output)
