/*
 * yenta.h 1.2 1996/11/21 17:30:01 (David Hinds)
 */

#ifndef _LINUX_YENTA_H
#define _LINUX_YENTA_H

#ifndef PCI_VENDOR_ID_RICOH
#define PCI_VENDOR_ID_RICOH		0x1180
#endif

#ifndef PCI_DEVICE_ID_RICOH_RL5C466
#define PCI_DEVICE_ID_RICOH_RL5C466	0x0466
#endif

#ifndef PCI_VENDOR_ID_SMC
#define PCI_VENDOR_ID_SMC		0x10b3
#endif

#ifndef PCI_DEVICE_ID_SMC_34C90
#define PCI_DEVICE_ID_SMC_34C90		0xb106
#endif

#ifndef PCI_DEVICE_ID_CIRRUS_6832
#define PCI_DEVICE_ID_CIRRUS_6832	0x1110
#endif

#ifndef PCI_VENDOR_ID_TI
#define PCI_VENDOR_ID_TI		0x104c
#endif

#ifndef PCI_DEVICE_ID_TI_1131
#define PCI_DEVICE_ID_TI_1131		0xac12
#endif

#define CB_CONTROL_REG_BASE		0x0010

#define CB_STATUS			0x0016	/* 16 bit */
#define  CB_STATUS_FAST_BTB		0x0080
#define  CB_STATUS_DATA_PARITY_ERR	0x0100
#define  CB_STATUS_CDEVSEL		0x0600
#define  CB_STATUS_SIGNAL_ABORT		0x0800
#define  CB_STATUS_RECV_ABORT		0x1000
#define  CB_STATUS_MASTER_ABORT		0x2000
#define  CB_STATUS_SYSTEM_ERROR		0x4000
#define  CB_STATUS_PARITY_ERROR		0x8000

#define CB_MEM_BASE_0			0x001c
#define CB_MEM_LIMIT_0			0x0020
#define CB_MEM_BASE_1			0x0024
#define CB_MEM_LIMIT_1			0x0028
#define CB_IO_BASE_0			0x002c
#define CB_IO_LIMIT_0			0x0030
#define CB_IO_BASE_1			0x0034
#define CB_IO_LIMIT_1     		0x0038

/* Bridge Control Register */
#define CB_BRIDGE_CONTROL		0x003e	/* 16 bit */
#define  CB_BCR_PARITY_ENA		0x0001
#define  CB_BCR_SERR_ENA		0x0002
#define  CB_BCR_ISA_ENA			0x0004
#define  CB_BCR_VGA_ENA			0x0008
#define  CB_BCR_MABORT			0x0020
#define  CB_BCR_CB_RESET		0x0040
#define  CB_BCR_ISA_IRQ			0x0080
#define  CB_BCR_PREFETCH_0		0x0100
#define  CB_BCR_PREFETCH_1		0x0200
#define  CB_BCR_WRITE_POST		0x0400

#define CB_SUBSYSTEM_VENDOR_ID	0x0040	/* 16 bit */
#define CB_SUBSYSTEM_ID		0x0042	/* 16 bit */
#define CB_LEGACY_MODE_BASE	0x0044

#endif /* _LINUX_YENTA_H */
