#!/bin/sh

# libmove sourcelib targetlib
#
# This allows you to move a new shared library into place,
# even on a running system.
libmove() {
  LIBSOURCE=$1
  LIBTARGET=$2
  LIBFOO="`dirname $LIBTARGET`/libfoo.so.0.0.0"
  # link duplicate of target lib so we can safely copy over it:
  if [ -r $LIBTARGET ]; then
    cp -a $LIBTARGET $LIBFOO
    if [ -x /sbin/ldconfig ]; then
      ldconfig -l $LIBFOO
    fi
  fi
  mv $LIBSOURCE $LIBTARGET
  if [ -x /sbin/ldconfig ]; then
    ldconfig -l $LIBTARGET
  fi
  rm -f $LIBFOO
}

( cd lib/incoming
  for file in * ; do
    libmove $file ../$file
  done )
#### Now, get rid of the temporary directory:
rm -rf lib/incoming

# In case there's no ldconfig, make the main link:
if [ ! -x /sbin/ldconfig ]; then
  ( cd lib ; rm -rf libdb.so.2 )
  ( cd lib ; ln -sf libdb1.so.2 libdb.so.2 )
fi

# The rest of the symlinks:
( cd lib ; rm -rf libdb1.so.2 )
( cd lib ; ln -sf libdb1.so.2.1.3 libdb1.so.2 )
( cd usr/lib ; rm -rf libdb1.so )
( cd usr/lib ; ln -sf ../../lib/libdb1.so.2 libdb1.so )
