#include "settings.h"
#include "settings.moc"

#include <qlabel.h>
#include <qhbox.h>
#include <qlayout.h>

#include <klocale.h>

#include "defines.h"
#include "board.h"


QCheckBox *createAnimations(KSettingWidget *sw)
{
    QCheckBox *cb = new QCheckBox(i18n("Enable animations"), sw);
    sw->settings()->plug(cb, OP_GROUP, "enable animations", true);
    return cb;
}

KIntNumInput *createBlockSize(KSettingWidget *sw)
{
    KIntNumInput *in = new KIntNumInput(sw);
    const BoardInfo &bi = Factory::self()->boardInfo();
    in->setRange(bi.minBlockSize, bi.maxBlockSize);
    sw->settings()->plug(in, OP_GROUP, "block size", bi.minBlockSize);
    return in;
}

KDoubleNumInput *createFadeStrength(KSettingWidget *sw)
{
    KDoubleNumInput *dn = new KDoubleNumInput(sw);
    dn->setRange(0, 1, 0.01);
    sw->settings()->plug(dn, OP_GROUP, "fade intensity", 1.0);
    return dn;
}

KColorButton *createFadeColor(KSettingWidget *sw)
{
    KColorButton *cb = new KColorButton(sw);
    sw->settings()->plug(cb, OP_GROUP, "fade color", Qt::black);
    return cb;
}

//-----------------------------------------------------------------------------
AppearanceSettingsWidget::AppearanceSettingsWidget()
    : KSettingWidget(i18n("Appearance"), "appearance")
{
    QGridLayout *top = new QGridLayout(this, 6, 3, KDialog::marginHint(),
                                       KDialog::spacingHint());
    top->setColStretch(2, 1);

    QLabel *label = new QLabel(i18n("Block size"), this);
    top->addWidget(label, 0, 0);
    KIntNumInput *bs = createBlockSize(this);
    top->addMultiCellWidget(bs, 0, 0, 1, 2);

    top->addRowSpacing(1, KDialog::spacingHint());

    label = new QLabel(i18n("Fade strength"), this);
    top->addWidget(label, 2, 0);
    KDoubleNumInput *fs = createFadeStrength(this);
    top->addMultiCellWidget(fs, 2, 2, 1, 2);
    label = new QLabel(i18n("Fade color"), this);
    top->addWidget(label, 3, 0);
    KColorButton *fc = createFadeColor(this);
    top->addWidget(fc, 3, 1);

    top->addRowSpacing(4, KDialog::spacingHint());

    QCheckBox *cb = createAnimations(this);
    top->addMultiCellWidget(cb, 5, 5, 0, 2);
}

bool AppearanceSettingsWidget::readAnimations()
{
    KSettingWidget sw;
    QCheckBox *cb = createAnimations(&sw);
    return sw.settings()->readValue(cb).toBool();
}

uint AppearanceSettingsWidget::readBlockSize()
{
    KSettingWidget sw;
    KIntNumInput *in = createBlockSize(&sw);
    return sw.settings()->readValue(in).toUInt();
}

double AppearanceSettingsWidget::readFadeStrength()
{
    KSettingWidget sw;
    KDoubleNumInput *dn = createFadeStrength(&sw);
    return sw.settings()->readValue(dn).toDouble();
}

QColor AppearanceSettingsWidget::readFadeColor()
{
    KSettingWidget sw;
    KColorButton *cb = createFadeColor(&sw);
    return sw.settings()->readValue(cb).toColor();
}
