//////////////////////////////////////////////////////////////         
//      $Id: updateLoc.h,v 1.17.2.1 2003/03/13 00:05:21 rnolden Exp $ 
//
// Author: Toivo Pedaste
//
#ifndef DEBLOCATE_H
#define DEBLOCATE_H

#include "../config.h"

// Standard Headers
#include <stdio.h>

// Qt Headers
#include <qdir.h>
#include <qwidget.h>
#include <qframe.h>
#include <qlabel.h>
#include <qfiledialog.h> 
#include <qgroupbox.h> 
#include <qcheckbox.h>
#include <qlayout.h> 
#include <qlineedit.h>

// KDE headers
#include <kbuttonbox.h>
#include <kdialogbase.h>

class pkgInterface;
class updateLoc;
class cacheObj;
class LcacheObj;
class KComboBox;

//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
class dpanel : public QWidget
{
  Q_OBJECT

public:
  dpanel(updateLoc *upd, QString Pfilter, QWidget *parent,
	 bool buse = TRUE, const char * name  = 0, bool bsubdirs = TRUE );
  ~dpanel();


  QString getText();
  void setText(QString s);
  bool getUse();
  void setUse(int n);
  bool getSubdirs();
  void setSubdirs(int n);

private:

  QCheckBox *psubdirs;
  QCheckBox *puse;
  QHBoxLayout* pack;
  QLineEdit *pent;
  QPushButton *pbut;

  dpanel *base;
  QString filter;

 public slots:
  void fileOpen();
  void dirOpen();

};

//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
class updateLoc : public QWidget
{
  Q_OBJECT

public:

  updateLoc (QWidget *p, int panelNumber, int numberLines, pkgInterface *inter,
	     QString options, QString iname, QString filter,
	     QString lmsg, QString bmsg = 0, bool subdirs = FALSE);
  ~updateLoc(); 

  void readSettings();
  void writeSettings();

  void applyS(LcacheObj *slist);

  bool haveBase;
  dpanel *base;

private:

  QString interName;
  QString packL, packU, packS, packC, availB;
  int panNumber;

  int wdth;
  
  QPushButton  *butloc;

  QHBoxLayout* hloc;

  pkgInterface *interface;

  QGroupBox *fbase;
  QVBoxLayout* vbase;

  enum { PNUM = 40 };
  int numLines;
  dpanel *dp[PNUM];
  KComboBox *combo[PNUM];

  QVBoxLayout* vl;
  QVBoxLayout* vtop, *vf;
  QGroupBox *frame1;
  KButtonBox* hb;

};
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
class Locations : public KDialogBase
{
  Q_OBJECT

public:
Locations( QString msg);
void dLocations(int numberDirs,  int numberLines,
		     pkgInterface *inter, QString label,
		     QString iname, QString filter, QString dirMsg,
		     bool subdirs=TRUE );

void pLocations(int numberDirs,  int numberLines,
		     pkgInterface *inter, QString label,
		     QString iname, QString filter,
		     QString packMsg, QString baseMsg = 0,
		     bool subdirs=FALSE);

void cLocations(int numberDirs, int numberLines,
		     pkgInterface *inter, QString label, QString iname,
		     QString filter, 
		QString packMsg, QString baseMsg, QString options);

  // bmsg indicates the panel has a base entry
~Locations();
void restore();

int numPanels;
enum { PANNUM = 10 };
updateLoc *pn[PANNUM];

public slots:
    void apply_slot();

signals:
  void returnVal(LcacheObj *);

};

//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

#endif
